﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../../language_menu.dwt.ascx"%>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<ali:Get ID="Module" Object="Module" Operation="Get(Request.QueryString['Namespace'])" />
<title>词典</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet"  href="../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<style >
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string _contentLangName = null;
protected string ContentLangName
{
	get
	{
		if (_contentLangName != null)
			return _contentLangName;
			
		_contentLangName = Manager.Languages.Select(Alias.Language.Ab + "='" + ContentLang + "'")[0][Alias.Language.Name + PageLang].ToString();

		return _contentLangName;
	}
}

protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Module.Dictionary.Namespace + "=" + Request.QueryString["Namespace"]);
	string and = String.Empty;

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Module.Dictionary.Name + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Content")
			condition.Append(and + Alias.Module.Dictionary.Content + "='" + keyword + "'");
	}
	#endregion
	
	return condition.ToString();
}
</script>
<script >
var _page = 'module_dictionary_list',
    _lang = '<%=ContentLang%>',
    _webPath = '<%=WebPath%>',
    _imagePath = '<%=ImagePath%>',
    _namespace ='<%=Request.QueryString["Namespace"]%>',
    _lang_working ='正在操作...',
    _lang_operation_fail ='操作失败！',
    _lang_operation_success ='操作成功！',
    _lang_name_empty = '标识不能空！',
    _lang_confirm_delete = '要删除此项吗？';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" ></div>
	<div class="Title"><a href="../list.aspx">模块列表</a> → <span class="<%=ContentLang%>Font"><%=Module[Name]%></span></div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" > 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../edit.aspx?Lang=<%=ContentLang%>&amp;Namespace=<%=Request.QueryString["Namespace"]%>">编辑</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../object/list.aspx?Lang=<%=ContentLang%>&amp;Namespace=<%=Request.QueryString["Namespace"]%>">对象列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../object/add.aspx?Lang=<%=ContentLang%>&amp;Namespace=<%=Request.QueryString["Namespace"]%>">添加对象</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">词典</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../dictionary/add.aspx?Lang=<%=ContentLang%>&amp;Namespace=<%=Request.QueryString["Namespace"]%>">添词</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<input id="Keyword" class="Text <%=ContentLang%>Font" >
		<select id="KeywordType">
			<option value="Name">标识</option>
			<option value="Content">内容</option>
		</select>
		<input id="Search" type="button" value="搜索" class="Button" >
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th width="150">标识</th>
					<th>内容</th>
					<th width="40">修改</th>
					<th width="40">删除</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Module.Dictionary" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
					<ali:Record>
						<tr data-id="<%=Name%>">
							<form>
								<td><input type="text" name="Name" value="<%=Name%>" size="30" class="Text" ></td>
								<td><textarea name="Content" cols="50" rows="3" class="Text <%=ContentLang%>Font"><%=Content%></textarea></td>
								<td><input type="image" src="<%=ImagePath%>modify.gif" ></td>
								<td><a href="">删除</a></td>
							</form>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif">
							<img src="<%=ImagePath%>pagination/previous_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif">
							<img src="<%=ImagePath%>pagination/last_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>