﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.OnlineService.Name + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Account")
			condition.Append(and + Alias.OnlineService.Account + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.OnlineService.Sort + " ASC";
			break;
		case "2":
			sort = Alias.OnlineService.InnerID + " DESC";
			break;
		case "3":
			sort = Alias.OnlineService.InnerID + " ASC";
			break;
		default:
			sort = Alias.OnlineService.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">移动</th>
			<th>名称</th>
			<th>类型</th>
			<th>账号</th>
			<th width="40">删除</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="OnlineService" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ali:Record>
				<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="">
					<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
					<td class="<%=ContentLang%>Font"><a href="../online_service/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<td>
						<%If Convert.ToString(Type) == "WW"%>
							阿里旺旺
						<%ElseIf Convert.ToString(Type) == "Phone"%>
							电话
						<%Else%>
							QQ
						<%EndIf%>
					</td>
					<td><%=Account%></td>
					<td><a href="">删除</a></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
		<div class="Pagination">
			<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
			<div class="Right">
				<ali:FirstPage>
					<ali:Yes>
						<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
						<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
					</ali:Yes>
					<ali:No>
						<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
						<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
					</ali:No>
				</ali:FirstPage>
				<ali:CurrentPage Range="5">
					<ali:Yes>
						<span class="Current"><%=Index%></span>						
					</ali:Yes>
					<ali:No>
						<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
					</ali:No>
				</ali:CurrentPage>
				<ali:LastPage>
					<ali:Yes>
						<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
						<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
					</ali:Yes>
					<ali:No>
						<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
						<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
					</ali:No>
				</ali:LastPage>
			</div>
		</div>
	</ali:Pagination>

