﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>在线客服列表</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet" href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.OnlineService.Name + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Account")
			condition.Append(and + Alias.OnlineService.Account + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.OnlineService.Sort + " ASC";
			break;
		case "2":
			sort = Alias.OnlineService.InnerID + " DESC";
			break;
		case "3":
			sort = Alias.OnlineService.InnerID + " ASC";
			break;
		default:
			sort = Alias.OnlineService.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<script >
var _page = 'online_service_list',
    _lang = '<%=ContentLang%>',
    _webPath = '<%=WebPath%>',
    _imagePath = '<%=ImagePath%>',
    _lang_working = '正在操作...',
    _lang_operation_fail = '操作失败！',
    _lang_operation_success = '操作成功！',
    _lang_confirm_delete = '要删除此项吗？';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif"></div>
	<div class="Title">在线客服列表</div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif"> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">在线客服列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../online_service/add.aspx?Lang=<%=ContentLang%>">添加在线客服</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">	
		<select id="Sort">
			<option value="1">手动</option>
			<option value="2">编号↓</option>
			<option value="3">编号↑</option>
		</select>
		<input id="Keyword" value="<%=Request.QueryString["Keyword"]%>" class="Text <%=ContentLang%>Font" >
		<select id="KeywordType">
			<option value="Name">名称</option>
			<option value="Account">账号</option>
		</select>
		<input id="Search" type="button" value="搜索" class="Button" >
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th width="40">移动</th>
					<th>名称</th>
					<th>类型</th>
					<th>账号</th>
					<th width="40">删除</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="OnlineService" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="">
							<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
							<td class="<%=ContentLang%>Font"><a href="../online_service/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
							<td>
								<%If Convert.ToString(Type) == "WW"%>
									阿里旺旺
								<%ElseIf Convert.ToString(Type) == "Phone"%>
									电话
								<%Else%>
									QQ
								<%EndIf%>
							</td>
							<td><%=Account%></td>
							<td><a href="">删除</a></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
				<div class="Pagination">
					<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
					<div class="Right">
						<ali:FirstPage>
							<ali:Yes>
								<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
								<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
							</ali:Yes>
							<ali:No>
								<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
								<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
							</ali:No>
						</ali:FirstPage>
						<ali:CurrentPage Range="5">
							<ali:Yes>
								<span class="Current"><%=Index%></span>						
							</ali:Yes>
							<ali:No>
								<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
							</ali:No>
						</ali:CurrentPage>
						<ali:LastPage>
							<ali:Yes>
								<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
								<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
							</ali:Yes>
							<ali:No>
								<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
								<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
							</ali:No>
						</ali:LastPage>
					</div>
				</div>
			</ali:Pagination>
		</div>
	<div class="Footer"></div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=JsPath%>move.js"></script>
<script src="<%=JsPath%>tree_handler.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>