﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>权限设置</title>
<ali:Comment><link rel="stylesheet"  href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<alicmsUC:Ime Ime="false" Eot="true" runat="server" />
<style >
.Block TBODY TD{text-align:center}
IMG{border:0}
</style>
<script language="c#" runat="server">
protected Guid _instanceID = Guid.Empty;
protected Guid _languageID = Guid.Empty;
protected Guid _objectID = Guid.Empty;
protected Guid _operationID = Guid.Empty;
protected Guid _roleID = Guid.Empty;
protected StringBuilder _condition;

protected override void OnLoad(EventArgs e)
{
	if (!String.IsNullOrEmpty(Request.QueryString["InstanceID"]))
		_instanceID = new Guid(Request.QueryString["InstanceID"]);
	else if (!String.IsNullOrEmpty(Request.QueryString["InstanceInnerID"]))
		_instanceID = (Guid)Manager.Channels.Select(Alias.Instance.InnerID + "=" + Request.QueryString["InstanceInnerID"])[0][Alias.Instance.ID];
	else
		_instanceID = (Guid)SystemChannel[Alias.Instance.ID];

	if (!String.IsNullOrEmpty(Request.QueryString["LanguageID"]))
		_languageID = new Guid(Request.QueryString["LanguageID"]);
	else if (!String.IsNullOrEmpty(Request.QueryString["LanguageInnerID"]))
		_languageID = (Guid)Manager.Languages.Select(Alias.Language.InnerID + "=" + Request.QueryString["LanguageInnerID"])[0][Alias.Language.ID];
	else
		_languageID = (Guid)Manager.Languages.Select(Alias.Language.Ab + "='" + PageLang + "'")[0][Alias.Language.ID];

	if (!String.IsNullOrEmpty(Request.QueryString["ObjectID"]))
	{
		_objectID = new Guid(Request.QueryString["ObjectID"]);
	}
	else if (!String.IsNullOrEmpty(Request.QueryString["ObjectName"]))
	{
		DataRow[] rows = null;
		using (AliCMS.SystemModule.Module.IObject bll = (AliCMS.SystemModule.Module.IObject)Manager.CreateObject("Module.Object", InstanceID, ContentLang, false))
		{
			DataRow instance = Manager.Channels.Select(Alias.Instance.ID + "='" + _instanceID + "'")[0];

			Dictionary<string, object> condition = new Dictionary<string, object>();
			condition[Alias.Module.Object.ModuleID] = instance[Alias.Module.ID];
			DataTable objectTable = bll.List(-1, -1,  condition, null);
			string[] names = Request.QueryString["ObjectName"].Split('.');
			foreach (string name in names)
			{
				if (String.IsNullOrEmpty(name))
					continue;

				if (_objectID == Guid.Empty)
					rows = objectTable.Select(Alias.Module.Object.Name + "='" + name + "'");
				else
					rows = objectTable.Select(Alias.Module.Object.Name + "='" + name + "' AND " + Alias.Module.Object.ParentID + "='" + _objectID + "'");
				_objectID = (Guid)rows[0][Alias.Module.Object.ID];
			}
		}
	}

	if (!String.IsNullOrEmpty(Request.QueryString["OperationID"]))
	{
		_operationID = new Guid(Request.QueryString["OperationID"]);
	}
	else if (!String.IsNullOrEmpty(Request.QueryString["OperationName"]))
	{
		using (AliCMS.SystemModule.Module.Object.IOperation bll = (AliCMS.SystemModule.Module.Object.IOperation)Manager.CreateObject("Module.Object.Operation", InstanceID, ContentLang, false))
		{
			Dictionary<string, object> condition = new Dictionary<string, object>();
			condition[Alias.Module.Object.Operation.ObjectID] = _objectID;
			DataTable operationTable = bll.List(-1, -1,  condition, null);
			DataRow[] rows = operationTable.Select(Alias.Module.Object.Operation.Name + "='" + Request.QueryString["OperationName"] + "'");
			_operationID = (Guid)rows[0][Alias.Module.Object.Operation.ID];
		}
	}

	if (!String.IsNullOrEmpty(Request.QueryString["RoleID"]))
		_roleID = new Guid(Request.QueryString["RoleID"]);

	_condition = new StringBuilder();
	_condition.Append(Alias.Permission.InstanceID + "=" + _instanceID);
	_condition.Append(" AND " + Alias.Permission.LanguageID + "=" + _languageID);
	if (_objectID != Guid.Empty)
		_condition.Append(" AND " + Alias.Permission.ObjectID + "=" + _objectID);
	if (_operationID != Guid.Empty)
		_condition.Append(" AND " + Alias.Permission.OperationID + "=" + _operationID);
	if (!String.IsNullOrEmpty(Request.QueryString["RecordID"]))
		_condition.Append(" AND " + Alias.Permission.RecordID + "=" + Request.QueryString["RecordID"]);
	if (_roleID != Guid.Empty)
		_condition.Append(" AND " + Alias.Permission.RoleID + "=" + _roleID);
}

protected string GetRoleName(DataRow record)
{
	DataRow[] rows = RoleTable.Select(Alias.Role.ID + "='" + record[Alias.Permission.RoleID] + "'");
	if (rows.Length == 0)
		return String.Empty;
	else
		return rows[0][Alias.Role.Name].ToString();
}
</script>
<script >
var _xmlDoc = CreateXmlDom(),
    _action = null,
    _isLoading = true,
    _instanceToModule = new Object(),
    _objectIDToName = new Object(),
    _OperationIDToName = new Object();
</script>
</head>
<body onload="InstanceID_OnChange()">
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" ></div>
	<div class="Title">权限设置</div>
	<div class="LanguageFilter"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../role/list.aspx?Lang=<%=ContentLang%>">角色列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../role/add.aspx?Lang=<%=ContentLang%>">添加角色</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../role/privilege.aspx?Lang=<%=ContentLang%>">特权设置</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">权限设置</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<form method="post" onsubmit="return OnAdd(this)">

		实例：
		<select name="InstanceID" class="Text" onchange="InstanceID_OnChange()">
			<ali:List Object="Instance">
				<ali:Record>
					<%If Guid.Equals(ID, _instanceID)%>
						<option value="<%=ID%>" ModuleID="<%=ModuleID%>" selected="selected"><%=Name%></option>
					<%Else%>
						<option value="<%=ID%>" ModuleID="<%=ModuleID%>"><%=Name%></option>
					<%EndIf%>
				</ali:Record>
			</ali:List>
		</select>
				
		语言：
		<select name="LanguageID" class="Text" onchange="OnSearch()">
			<ali:List Object="Language">
				<ali:Record>
					<%If Guid.Equals(ID, _languageID)%>
						<option value="<%=ID%>" selected="selected"><%=Name%></option>
					<%Else%>
						<option value="<%=ID%>"><%=Name%></option>
					<%EndIf%>
					
				</ali:Record>
			</ali:List>
		</select>
		
		对象：<select name="ObjectID" class="Text" onchange="ObjectID_OnChange()"><option value="">--未指定--</option></select>
		操作：<select name="OperationID" class="Text" onchange="OnSearch()"><option value="">--未指定--</option></select>
		<br />
		记录：<input type="text" name="RecordID" value="<%=Request.QueryString["RecordID"]%>" onchange="OnSearch()" />
		
		角色：
		<select name="RoleID" class="Text" onchange="OnSearch()"><option value="">--游客--</option>
			<ali:List ID="RoleTable" Object="Role">
					<ali:Record>
						<%If Guid.Equals(ID, _roleID)%>
							<option value="<%=ID%>" selected="selected"><%=Name%></option>
						<%Else%>
							<option value="<%=ID%>"><%=Name%></option>
						<%EndIf%>
					</ali:Record>
			</ali:List>
		</select>
		<input type="checkbox" name="IsAllowed" id="IsAllowed" /><label for="IsAllowed">许可</label>
		<input type="submit" id="Add" class="Button" value="添加" />
		</form>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>对象</th>
					<th>操作</th>
					<th>记录</th>
					<th>角色</th>
					<th>许可</th>
					<th width="40">删除</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Permission" Page="PageNumber" PageSize="20" Condition="_condition">
					<ali:Record>
						<tr id="Row<%=ID%>">
							<td><%=ObjectName%></td>
							<td><%=OperationName%></td>
							<td><%=RecordID%></td>
							<td><%=GetRoleName(Record)%></td>
							<td>
								<%If Convert.ToBoolean(IsAllowed)%>
									<input type="checkbox" value="<%=ID%>" onclick="OnCheck(this)" checked="checked" />
								<%Else%>
									<input type="checkbox" value="<%=ID%>" onclick="OnCheck(this)" />
								<%EndIf%>
							</td>
							<td><a href="javascript:OnDelete('<%=ID%>')"><img src="<%=ImagePath%>delete.gif" /></a></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination ID="Pagination" Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script>
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		if (_action == "ObjectList")
		{
			var objectSelect = document.forms[0].ObjectID;
		
			_xmlDoc.loadXML(xmlHttp.responseText);
			BuildTreeOptions(_xmlDoc, AliCMS.SystemModule.Module_Object.ParentID, AliCMS.SystemModule.Module_Object.ID, AliCMS.SystemModule.Module_Object.Name, objectSelect);
			
			_objectIDToName.length = 0;
			for (var i = 0; i < objectSelect.options.length; i++)
			{
				var id = objectSelect.options[i].value;
				if (id == "")
					continue;
				
				var name = "";
				var itemNode = null;
				var nodes = _xmlDoc.selectNodes("//" + AliCMS.SystemModule.Module_Object.ID);
				for (var j = 0; j < nodes.length; j++)
				{
					var node = nodes[j];
					if (node.text == id)
					{
						itemNode = node.parentNode;
						break;
					}
				}

				var parentID = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.ParentID).text;
				while (parentID != "00000000-0000-0000-0000-000000000000")
				{
					if (name == "")
						name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text;
					else
						name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text + "." + name;
					
					nodes = _xmlDoc.selectNodes("//" + AliCMS.SystemModule.Module_Object.ID);
					for (var j = 0; j < nodes.length; j++)
					{
						var node = nodes[j];
						if (node.text == parentID)
						{
							itemNode = node.parentNode;
							break;
						}
					}
					parentID = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.ParentID).text;
				}
				
				if (name == "")
					name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text;
				else
					name = itemNode.selectSingleNode(AliCMS.SystemModule.Module_Object.Name).text + "." + name;
				
				_objectIDToName[id] = name;
			}
			
			if (_isLoading)
			{
				CheckAndSelect("<%=_objectID%>", objectSelect);
				ObjectID_OnChange();
			}
			else
			{
				OnSearch();
			}
		}
		else if (_action == "OperationList")
		{
			var operationSelect = document.forms[0].OperationID;
			_OperationIDToName.length = 0;
		
			_xmlDoc.loadXML(xmlHttp.responseText);
			var itemList = _xmlDoc.documentElement.childNodes;
			for (var i = 0; i < itemList.length; i++)
			{
				if (typeof (childNodes[i].selectSingleNode) == "undefined")
					continue;
						
				var id = itemList[i].selectSingleNode(AliCMS.SystemModule.Module_Object_Operation.ID).text;
				var name = itemList[i].selectSingleNode(AliCMS.SystemModule.Module_Object_Operation.Name).text;
				operationSelect.options.add(new Option(name, id));
				_OperationIDToName[id] = name;
			}
			
			if (_isLoading)
			{
				CheckAndSelect("<%=_operationID%>", operationSelect);
				_isLoading = false;
			}
			
			OnSearch();
		}
		else if (_action == "Modify")
		{
		}
		else
		{
			var list = document.getElementById("List");
			list.innerHTML = HandleFake404(xmlHttp);
			
			if (_action == "Add")
			{
				alert("添加成功！");
				document.getElementById("Add").disabled = false;
			}
			else if (_action == "Delete")
			{
				alert("删除成功！");
			}
		}
	}
	else
	{
		if (_action == "Add")
			alert("添加失败！请查看日志！");
		else if (_action == "Delete")
			alert("删除失败！请查看日志！");
		else if (_action == "ObjectList")
			alert("获取对象列表失败！请查看日志！");
		else if (_action == "OperationList")
			alert("获取页面列表失败！请查看日志！");
		else
			alert("失败！请查看日志！");
		document.getElementById("Add").disabled = false;
	}
}

function OnAdd(form)
{
	var data = "InstanceID=" + form.InstanceID.value + "&LanguageID=" + form.LanguageID.value;

	if (form.ObjectID.value == "")
	{
		alert("没有任何对象！");
		return false;
	}
	data += "&ObjectID=" + form.ObjectID.value;
	data += "&ObjectName=" + _objectIDToName[form.ObjectID.value];
	
	if (form.OperationID.value == "")
	{
		alert("没有任何操作！");
		return false;
	}
	data += "&OperationID=" + form.OperationID.value;
	data += "&OperationName=" + _OperationIDToName[form.OperationID.value];

	if (form.RecordID.value != "") data += "&RecordID=" + form.RecordID.value;
	if (form.RoleID.value != "") data += "&RoleID=" + form.RoleID.value;
	data += "&IsAllowed=" + form.IsAllowed.checked;

	document.getElementById("Add").disabled = true;
	_action = "Add";
	_ajax.Post("<%=WebPath%>alicms.aspx?Lang=<%=ContentLang%>&Object=Permission&Operation=Add&Transfer=" + encodeURIComponent(BuildHeader()), data, XmlHttpCallBack);
	return false;
}

function OnCheck(radio)
{
	_action = "Modify";
	_ajax.Post("<%=WebPath%>alicms.aspx?Lang=<%=ContentLang%>&Object=Permission&Operation=Modify&ID=" + radio.value + "&Transfer=" + encodeURIComponent(BuildHeader()), "IsAllowed=" + radio.checked, XmlHttpCallBack);
}

function OnDelete(id)
{
	if (!confirm("要删除此项吗？"))
		return;
	
	//服务器端删除
	_action = "Delete";
	_ajax.Post("<%=WebPath%>alicms.aspx?Lang=<%=ContentLang%>&Object=Permission&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()), null, XmlHttpCallBack);
}

function InstanceID_OnChange()
{
	var objectSelect = document.forms[0].ObjectID;
	objectSelect.length = 1;
	
	var operationSelect = document.forms[0].OperationID;
	operationSelect.length = 1;
	
	var instanceSelect = document.forms[0].InstanceID;
	if (instanceSelect.selectedIndex == -1 || instanceSelect.value == "")
		return;

	_action = "ObjectList";
	_ajax.Post("<%=WebPath%>alicms.aspx?Lang=<%=ContentLang%>&Object=Module.Object&Operation=List&Condition=" + encodeURIComponent(AliCMS.SystemModule.Module_Object.ModuleID + ":" + _instanceToModule[instanceSelect.value]), null, XmlHttpCallBack);
}

function ObjectID_OnChange()
{
	var operationSelect = document.forms[0].OperationID;
	operationSelect.length = 1;
	
	var objectSelect = document.forms[0].ObjectID;
	if (objectSelect.selectedIndex == -1 || objectSelect.value == "")
	{
		_isLoading = false;
		return;
	}
	
	_action = "OperationList";
	_ajax.Post("<%=WebPath%>alicms.aspx?Lang=<%=ContentLang%>&Object=Module.Object.Operation&Operation=List&Condition=" + encodeURIComponent(AliCMS.SystemModule.Module_Object_Operation.ObjectID + "=" + objectSelect.value), null, XmlHttpCallBack);
}

function BuildHeader()
{
	var form = document.forms[0];
	var qs = BuildAjaxPath(true) + "?InstanceID=" + form.InstanceID.value + "&LanguageID=" + form.LanguageID.value;
	if (form.ObjectID.value != "") qs += "&ObjectID=" + form.ObjectID.value;
	if (form.OperationID.value != "") qs += "&OperationID=" + form.OperationID.value;
	if (form.RecordID.value != "") qs += "&RecordID=" + form.RecordID.value;
	if (form.RoleID.value != "") qs += "&RoleID=" + form.RoleID.value;
	return qs;
}

function OnSearch()
{
	var page = (arguments.length == 0 ? "" : "&page=" + arguments[0]);
	_action = "Search";
	_ajax.Post(BuildHeader() + page, null, XmlHttpCallBack);
	return false;
}
</script>
<script >
			var items = document.forms[0].InstanceID.options;
			for (var i = 0; i < items.length; i++)
			{
				_instanceToModule[items[i].value] = items[i].ModuleID;
			}
</script>
<script >
HandleFake404();
</script>
<script src="<%=CommonPath%>ajax.js"></script>
<script src="<%=CommonPath%>xmldom.js"></script>
<script src="<%=JsPath%>common.js"></script>
<script src="<%=Manager.GetModulePath(null)%><%=Instance[AliCMS.SystemModule.Alias.Module.Namespace]%>/alias.js"></script>
</body>
</html>