﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:Get ID="Template" Object="Template" Operation="Get(Request.QueryString['TemplatePath'])" Validate="True" />
<ali:Get ID="Candidate" Object="InstanceConfig" Operation="GetLanguageSettings()" Lang="PageLang" />
<script language="c#" runat="server">
protected string _sourceLanguageAb;
protected string SourceLanguageAb
{
	get
	{
		if (!String.IsNullOrEmpty(_sourceLanguageAb))
			return _sourceLanguageAb;
		
		_sourceLanguageAb = Template[Alias.Template.Language].ToString();
		if (String.IsNullOrEmpty(_sourceLanguageAb))
			_sourceLanguageAb = PageLang;
			
		return _sourceLanguageAb;
	}
}

protected string _sourceLanguage = null;
protected string SourceLanguage
{
	get
	{
		if (_sourceLanguage != null)
			return _sourceLanguage;
			
		_sourceLanguage = Candidate.Select(Alias.Language.Ab + "='" + SourceLanguageAb + "'")[0][Alias.Language.Name].ToString();

		return _sourceLanguage;
	}
}

protected string _targetLanguageAb;
protected string TargetLanguageAb
{
	get
	{
		if (!String.IsNullOrEmpty(_targetLanguageAb))
			return _targetLanguageAb;
		
		
		if (!String.IsNullOrEmpty(Request.QueryString["Language"]))
		{
			_targetLanguageAb = Request.QueryString["Language"];
		}
		else if (Request.Cookies["TargetLanguageAb"] != null)
		{
			_targetLanguageAb = Request.Cookies["TargetLanguageAb"].Value;
		}
		else
		{
			foreach (DataRow row in Manager.Languages.Rows)
			{
				if (row[Alias.Language.Ab].ToString() != SourceLanguageAb)
				{
					_targetLanguageAb = row[Alias.Language.Ab].ToString();
					break;
				}
			}
		}
			
		return _targetLanguageAb;
	}
}

protected string _targetLanguage = null;
protected string TargetLanguage
{
	get
	{
		if (_targetLanguage != null)
			return _targetLanguage;
			
		if (String.IsNullOrEmpty(TargetLanguageAb))
			_targetLanguage = String.Empty;
		else
			_targetLanguage = Candidate.Select(Alias.Language.Ab + "='" + TargetLanguageAb + "'")[0][Alias.Language.Name].ToString();

		return _targetLanguage;
	}
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th>标识</th>
			<th>源语言（<%=SourceLanguage%>）</th>
			<th>目标语言（<%=TargetLanguage%>）</th>
			<th width="40">修改</th>
			<th width="40">删除</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Template.Dictionary" Page="PageNumber" PageSize="20" Condition="TemplatePath=Request.QueryString['TemplatePath'] and Language=TargetLanguageAb" Validate="True">
			<ali:Record>
				<tr data-id="<%=ID%>">
					<form>
						<td><input type="text" name="Name" value="<%=Name%>" size="10" class="Text" /></td>
						<td><textarea name="SourceLanguage" cols="30" rows="2" class="Text <%=SourceLanguageAb%>Font"><%=From%></textarea></td>
						<td><textarea name="TargetLanguage" cols="30" rows="2" class="Text <%=TargetLanguageAb%>Font"><%=To%></textarea></td>
						<td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
						<td><a href="">删除</a></td>
					</form>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="ListRecordCount">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>