﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th>路径</th>
			<th>名称</th>
			<th width="40">词典</th>
			<th width="60">模块邦定</th>
			<th width="60">页面管理</th>
			<th width="60">脚本管理</th>
			<th width="60">模块菜单</th>
			<th width="60">加密解密</th>
			<th width="60">清空缓存</th>
			<th width="40">删除</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Template" Page="PageNumber" PageSize="20" Condition="IsWebsite=false" Validate="True">
			<ali:Record>
				<tr id="<%=Path%>">
					<td><a href="../template/edit.aspx?Lang=<%=ContentLang%>&Path=<%=Path%>"><%=Path%></a></td>
					<td><a href="../template/edit.aspx?Lang=<%=ContentLang%>&Path=<%=Path%>"><%=Name%></a></td>
					<td><a href="../template/dictionary.aspx?TemplatePath=<%=Path%>">词典</a></td>
					<td><a href="../template/module.aspx?TemplatePath=<%=Path%>">模块邦定</a></td>
					<td><a href="../template/page/list.aspx?TemplatePath=<%=Path%>">页面管理</a></td>
					<td><a href="../template/script/list.aspx?TemplatePath=<%=Path%>">脚本管理</a></td>
					<td>
						<%If Convert.ToBoolean(IsAdmin)%>
							<a href="../template/menu/list.aspx?TemplatePath=<%=Path%>">模块菜单</a>
						<%EndIf%>
					</td>
					<td>
						<%If !String.Equals(Path, "System/")%>
							<a href="">加密</a>
							<a href="">解密</a>
						<%EndIf%>
					</td>
					<td><a href="">清空缓存</a></td>
					<td>
						<%If !String.Equals(Path, "System/")%>
							<a href="">删除</a>
						<%EndIf%>
					</td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>