﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<ali:Get ID="Template" Object="Template" Operation="Get(Request.QueryString['TemplatePath'])" Validate="True" />
<ali:Get ID="Candidate" Object="InstanceConfig" Operation="GetLanguageSettings()" Lang="PageLang" />
<title>词典</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet"  href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<alicmsUC:Ime Ime="true" Eot="true" DependOnContentLang="false" runat="server" />
<script language="c#" runat="server">
protected string _sourceLanguageAb;
protected string SourceLanguageAb
{
	get
	{
		if (!String.IsNullOrEmpty(_sourceLanguageAb))
			return _sourceLanguageAb;
		
		_sourceLanguageAb = Template[Alias.Template.Language].ToString();
		if (String.IsNullOrEmpty(_sourceLanguageAb))
			_sourceLanguageAb = PageLang;
			
		return _sourceLanguageAb;
	}
}

protected string _sourceLanguage = null;
protected string SourceLanguage
{
	get
	{
		if (_sourceLanguage != null)
			return _sourceLanguage;
			
		_sourceLanguage = Candidate.Select(Alias.Language.Ab + "='" + SourceLanguageAb + "'")[0][Alias.Language.Name].ToString();

		return _sourceLanguage;
	}
}

protected string _targetLanguageAb;
protected string TargetLanguageAb
{
	get
	{
		if (!String.IsNullOrEmpty(_targetLanguageAb))
			return _targetLanguageAb;
		
		if (!String.IsNullOrEmpty(Request.QueryString["Language"]))
		{
			_targetLanguageAb = Request.QueryString["Language"];
		}
		else if (Request.Cookies["TargetLanguageAb"] != null)
		{
			_targetLanguageAb = Request.Cookies["TargetLanguageAb"].Value;
		}
		else
		{
			foreach (DataRow row in Manager.Languages.Rows)
			{
				if (row[Alias.Language.Ab].ToString() != SourceLanguageAb)
				{
					_targetLanguageAb = row[Alias.Language.Ab].ToString();
					break;
				}
			}
		}
			
		return _targetLanguageAb;
	}
}

protected string _targetLanguage = null;
protected string TargetLanguage
{
	get
	{
		if (_targetLanguage != null)
			return _targetLanguage;
			
		if (String.IsNullOrEmpty(TargetLanguageAb))
			_targetLanguage = String.Empty;
		else
			_targetLanguage = Candidate.Select(Alias.Language.Ab + "='" + TargetLanguageAb + "'")[0][Alias.Language.Name].ToString();

		return _targetLanguage;
	}
}
</script>
<script >
var _page = 'template_dictionary_list',
    _lang = '<%=ContentLang%>',
    _webPath = '<%=WebPath%>',
    _imagePath = '<%=ImagePath%>',
    _templatePath = '<%=Request.QueryString["TemplatePath"]%>',
    _lang_working = '正在操作...',
    _lang_operation_fail = '操作失败！',
    _lang_operation_success = '操作成功！',
    _lang_confirm_delete = '要删除此项吗？',
    _lang_target_language_empty = '目标语言不能空！';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" ></div>
	<div class="Title"><a href="../template/list.aspx">模板列表</a> → <%=Request.QueryString["TemplatePath"]%></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../template/edit.aspx?Path=<%=Request.QueryString["TemplatePath"]%>">编辑</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">词典</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/module.aspx?TemplatePath=<%=Request.QueryString["TemplatePath"]%>">模块邦定</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/page/list.aspx?TemplatePath=<%=Request.QueryString["TemplatePath"]%>">页面列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/page/add.aspx?TemplatePath=<%=Request.QueryString["TemplatePath"]%>">添加页面</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/script/list.aspx?TemplatePath=<%=Request.QueryString["TemplatePath"]%>">脚本列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/script/add.aspx?TemplatePath=<%=Request.QueryString["TemplatePath"]%>">添加脚本</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/menu/list.aspx?TemplatePath=<%=Request.QueryString["TemplatePath"]%>">模块菜单</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/menu/add.aspx?TemplatePath=<%=Request.QueryString["TemplatePath"]%>">添加菜单</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<form>
			标识：<input type="text" name="Name" size="10" class="Text" >
			源语言（<%=SourceLanguage%>）：
				<textarea name="SourceLanguage" cols="20" rows="2" class="Text <%=SourceLanguageAb%>Font"></textarea>
			目标语言（<select name="TargetLanguageAb" class="Text">
						<ali:List Object="Language" Source="Candidate">
							<ali:Record>
								<%If !String.Equals(Ab, SourceLanguageAb)%>
									<%If String.Equals(Ab, TargetLanguageAb)%>
										<option value="<%=Ab%>" selected="selected"><%=Name%></option>
									<%Else%>
										<option value="<%=Ab%>"><%=Name%></option>
									<%EndIf%>
								<%EndIf%>
							</ali:Record>
						</ali:List>
					</select>）：
				<textarea name="TargetLanguage" cols="20" rows="2" class="Text <%=TargetLanguageAb%>Font"></textarea>
			<input type="submit" class="Button" value="添加" >
			<input type="button" id="GetChineseString" class="Button" value="抽取中文" >
		</form>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th>标识</th>
					<th>源语言（<%=SourceLanguage%>）</th>
					<th>目标语言（<%=TargetLanguage%>）</th>
					<th width="40">修改</th>
					<th width="40">删除</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Template.Dictionary" Page="PageNumber" PageSize="20" Condition="TemplatePath=Request.QueryString['TemplatePath'] and Language=TargetLanguageAb" Validate="True">
					<ali:Record>
						<tr data-id="<%=ID%>">
							<form>
								<td><input type="text" name="Name" value="<%=Name%>" size="10" class="Text" ></td>
								<td><textarea name="SourceLanguage" cols="30" rows="2" class="Text <%=SourceLanguageAb%>Font"><%=From%></textarea></td>
								<td><textarea name="TargetLanguage" cols="30" rows="2" class="Text <%=TargetLanguageAb%>Font"><%=To%></textarea></td>
								<td><input type="image" src="<%=ImagePath%>modify.gif" ></td>
								<td><a href="">删除</a></td>
							</form>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
	<div class="Footer"></div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>