﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>模板列表</title>
<link rel="stylesheet"  href="<%=CommonPath%>jquery/themes/lightness/all.css" >
<ali:Comment><link rel="stylesheet"  href="../../S01/CHS/css/common.css" ></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" >
<script >
var _page = 'template_list',
	_lang = '<%=ContentLang%>',
	_webPath = '<%=WebPath%>',
	_imagePath = '<%=ImagePath%>',
	_lang_working = '正在操作...',
	_lang_operation_fail = '操作失败！',
	_lang_operation_success = '操作成功！',
	_lang_confirm_delete = '要删除此项吗？',
	_lang_format_incorrect = '上传格式必须是zip格式！',
	_lang_uploading = '正在上传文件...';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" ></div>
	<div class="Title">模板列表</div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">模板列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../template/add.aspx?Lang=<%=ContentLang%>">添加模板</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">
			<form style="display:inline" id="install">
				<input id="FileTextbox" type="text" name="File" disabled="disabled" class="Text" >
				<input id="FileBrowse" type="button" value="浏览..." >
				<input type="submit" value="安装" >
			</form>
		</li>
		<li class="Right"></li>
	</ul>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th>路径</th>
					<th>名称</th>
					<th width="40">词典</th>
					<th width="60">模块邦定</th>
					<th width="60">页面管理</th>
					<th width="60">脚本管理</th>
					<th width="60">模块菜单</th>
					<th width="60">加密解密</th>
					<th width="60">清空缓存</th>
					<th width="40">删除</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Template" Page="PageNumber" PageSize="20" Condition="IsWebsite=false" Validate="True">
					<ali:Record>
						<tr id="<%=Path%>">
							<td><a href="../template/edit.aspx?Lang=<%=ContentLang%>&amp;Path=<%=Path%>"><%=Path%></a></td>
							<td><a href="../template/edit.aspx?Lang=<%=ContentLang%>&amp;Path=<%=Path%>"><%=Name%></a></td>
							<td><a href="../template/dictionary.aspx?TemplatePath=<%=Path%>">词典</a></td>
							<td><a href="../template/module.aspx?TemplatePath=<%=Path%>">模块邦定</a></td>
							<td><a href="../template/page/list.aspx?TemplatePath=<%=Path%>">页面管理</a></td>
							<td><a href="../template/script/list.aspx?TemplatePath=<%=Path%>">脚本管理</a></td>
							<td>
								<%If Convert.ToBoolean(IsAdmin)%>
									<a href="../template/menu/list.aspx?TemplatePath=<%=Path%>">模块菜单</a>
								<%EndIf%>
							</td>
							<td>
								<%If !String.Equals(Path, "System/")%>
									<a href="">加密</a>
									<a href="">解密</a>
								<%EndIf%>
							</td>
							<td><a href="">清空缓存</a></td>
							<td>
								<%If !String.Equals(Path, "System/")%>
									<a href="">删除</a>
								<%EndIf%>
							</td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif">
							<img src="<%=ImagePath%>pagination/previous_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif">
							<img src="<%=ImagePath%>pagination/last_page_off.gif">
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script src="<%=CommonPath%>jquery/core.js"></script>
<script src="<%=CommonPath%>jquery/ui.js"></script>
<script src="<%=CommonPath%>utility.js"></script>
<script src="<%=CommonPath%>uploader.js"></script>
<script src="<%=JsPath%>global.js"></script>
<script src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>