﻿function BuildHeader()
{
	if (_page == "user_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsLocked=" + $("#IsLocked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "user_money")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&UserID=" + _userInnerID + "&Page=" + _pageNumber;
	else if (_page == "app_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "app_user_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "product_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "product_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "combo_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "privilege_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&ID=" + _guid + "&Type=" + _type + "&InstanceID=" + $("#InstanceID").val() + "&CurrentLang=" + $("#CurrentLang").val();
	else if (_page == "order_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsAccepted=" + $("#IsAccepted").val() + "&IsPayed=" + $("#IsPayed").val() + "&IsDelivered=" + $("#IsDelivered").val() + "&IsFinished=" + $("#IsFinished").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			var list = $("#List");

			list.html(HandleFake404(data, "text"));
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
				
			MakeButton();
		}
	});
}

function MakeButton()
{
	var buttons = "";
	var button;
	
	//回收
	button = $("#IsRecycled");
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
	    {
		    buttons += "<button class='Button' id='Recycle'>" + _lang_recycle + "</button>";
	    }
	    else if (button[0].selectedIndex == 2)
	    {
		    buttons += "<button class='Button' id='Delete'>" + _lang_delete + "</button>";
		    buttons += "<button class='Button' id='Recover'>" + _lang_recover + "</button>";
	    }
	}

	//审核
	button = $("#IsChecked");
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		    buttons += "<button class='Button' id='Check'>" + _lang_check + "</button>";
		else if (button[0].selectedIndex == 2)
		    buttons += "<button class='Button' id='UnCheck'>" + _lang_uncheck + "</button>";
	}

	//锁定
	button = $("#IsLocked");
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		    buttons += "<button class='Button' id='Lock'>" + _lang_lock + "</button>";
	    else if (button[0].selectedIndex == 2)
		    button[0] += "<button class='Button' id='UnLock'>" + _lang_unlock + "</button>";
	}

	//受理
	button = $("#IsAccepted");
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		    buttons += "<button class='Button' id='Delete'>" + _lang_delete + "</button>";
	}

	//完成，归档，作废
	button = $('#IsFinished');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
		{
			if ($("#IsDelivered")[0].selectedIndex == 3)
			    buttons += "<button class='Button' id='Finish'>" + _lang_finish + "</button>";
		    buttons += '<button class="Button" id="Archive">' + _lang_archive + '</button>';
		    buttons += '<button class="Button" id="Cancel">' + _lang_cancel + '</button>';
		}
	    else if (button[0].selectedIndex == 2)
		{
		    buttons += '<button class="Button" id="Archive">' + _lang_archive + '</button>';
		    buttons += '<button class="Button" id="Cancel">' + _lang_cancel + '</button>';
		}
	    else if (button[0].selectedIndex == 3 || button[0].selectedIndex == 4)
		{
		    buttons += '<button class="Button" id="Delete">' + _lang_delete + '</button>';
		}
	}

	$("#ExtraButton").html(buttons);
}

function prepareCheckboxData(elements, data)
{
    elements = $(elements);
	if (!data)//添加页面
	{
		data = {};
		data.index = 0;
		data.list = [];
	}
	else//编辑页面
	{
		data.index = 0;
	    data.addIndex = 0;
	    data.deleteIndex = 0;
	    data.addList = [];
	    data.deleteList = [];
		if (!data.list)
			data.list = [];
    	    	
	    elements.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < data.list.length; j++)
			    {
				    if (this == data.list[j])
					    break;
			    }
			    if (j >= data.list.length)
				    data.addList.push($(this));
		    }
		    else
		    {
			    for (var j = 0; j < data.list.length; j++)
			    {
				    if (this == data.list[j])
				    {
					    data.deleteList.push($(this));
					    break;
				    }
			    }
		    }
	    });
	}

	data.list = elements.filter(':checked');
	
	return data;
}

//联动
function linkage(element, page, callback)
{
	var me = $(element);
	me.nextAll('select').remove();
	if (me.val() == '' || me.val() == '0')
	{
		//if (callback != null)
		//	callback();
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url: page + '?Lang=' + _lang + '&ParentID=' + encodeURIComponent(element.value),
		type: 'GET',
		error: function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			SetStatusMessage();
				
			var items = eval(data);
			if (items.length == 0)
			{
				if (callback != null)
					callback();
				return;
			}

			var html = '<option value="">' + _lang_not_set + '</option>';
			for (var i = 0; i < items.length; i++)
				html += '<option value="' + items[i].id + '" data-inner-id="' + items[i].innerId + '">' + items[i].name + '</option>';

			var next = me.next('select');
			if (next.length == 0)
			{
				html = '<select class="' + _lang + 'Font">' + html + '</select>';
				me.after(html);	
			}
			else
			{
				next.empty().append(html);			
			}

			if (callback != null)
				callback();
		}
	});	
}

function linkageSelect(data)
{
	if (data.parentChain == null)
	{
		$.get(data.parentChainPage, function(result)
		{
			data.parentChain = result;
			data.parents = result.split('.');
			linkageSelect(data)
		});

		return;
	}

	data.element = $(data.element);
	if (data.parents.length == 1)
	{
		data.element.find('[value=' + data.id + ']').attr('selected', true);
	}
	else
	{
		data.element.find('[data-inner-id=' + data.parents[data.index++] + ']').attr('selected', true);
		data.element.change();
	}
}

//-------------------------------------------------
//Start : 栏目设置
function InstanceConfig()
{
	var __object = 'InstanceConfig',
		__base = new Base();

	this.setBasicSettings = function()
	{
		if (!this.MobileValidationTimeLimit.value.match(/^\d*$/))
		{
			Alert(_lang_mobile_validation_time_limit_incorrect, function(){this.MobileValidationTimeLimit.select();}, this);
			return false;
		}	
		
		if (!this.EmailValidationTimeLimit.value.match(/^\d*$/))
		{
			Alert(_lang_email_validation_time_limit_incorrect, function(){this.EmailValidationTimeLimit.select();}, this);
			return false;
		}
		
		if (this.RechargeNotifyUrl.value != "" && !this.RechargeNotifyUrl.value.match(/^http:\/\/.*/))
		{
			Alert(_lang_recharge_notify_url_incorrect, function(){this.RechargeNotifyUrl.select();}, this);
			return false;
		}
		
		var data = "IsNeedToCheck=" + $("#IsNeedToCheckYes")[0].checked;
		data += "&MobileValidationTimeLimit=" + this.MobileValidationTimeLimit.value;
		data += "&EmailValidationTimeLimit=" + this.EmailValidationTimeLimit.value;
		data += "&EmailValidationMailSubject=" +  encodeURIComponent(this.EmailValidationMailSubject.value);
		data += "&EmailValidationMailContent=" +  encodeURIComponent(this.EmailValidationMailContent.value);
		data += "&FindPasswordMailSubject=" +  encodeURIComponent(this.FindPasswordMailSubject.value);
		data += "&FindPasswordMailContent=" +  encodeURIComponent(this.FindPasswordMailContent.value);
		data += "&MobileValidationSMS=" +  encodeURIComponent(this.MobileValidationSMS.value);
		data += "&RechargeNotifyUrl=" + encodeURIComponent(this.RechargeNotifyUrl.value);
		data += '&QQConnectAppID=' + encodeURIComponent(this.QQConnectAppID.value);
		data += '&QQConnectAppKey=' + encodeURIComponent(this.QQConnectAppKey.value);
		
		__base.post({object:__object,operation:"SetBasicSettings",data:data});
		
		return false;	
	};
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 代理等级
function AgentLevel()
{
	var __object = 'AgentLevel',
		__base = new Base();

	this.add = function()
	{
		if (this.Name.value == "")
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = "Name=" + encodeURIComponent(this.Name.value);
		data += "&Description=" + encodeURIComponent(this.Description.value);
		
		__base.add({object:__object,data:data});

		return false;	
	};
	
	this.modify = function()
	{
		if (this.Name.value == "")
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
			
		var data = "Name=" + encodeURIComponent(this.Name.value);
		data += "&Description=" + encodeURIComponent(this.Description.value);
		
		__base.modify({object:__object,data:data});
		
		return false;	
	};
	
	this.update = function(operation, id)
	{
		__base.update(__object, operation, id);
	};
}
//End : 代理等级
//-------------------------------------------------

//-------------------------------------------------
//Start : 角色
function Role()
{
	var __object = 'Role',
		__base = new Base();

	this.add = function()
	{
		if (this.No.value == "")
		{
			Alert(_lang_no_empty, function(){this.No.select();}, this);
			return false;
		}
		
		if (this.Name.value == "")
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		checkNo(add_Send);
		
		return false;
	};
	
	this.modify = function()
	{
		if (this.Name.value == "")
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
			
		modify_Send();
		
		return false;	
	};
	
	this.update = function(operation, id)
	{
		__base.update(__object, operation, id);
	};
	
	this.onNoChange = function()
	{
		var me = $(this);
		if (me.val() == "")
		{
			me.next("strong").html(_lang_no_empty);
		}
		else if (typeof(me.data("Old")) != "undefined" && me.val() == me.data("Old"))
		{
			me.next("strong").html("");
		}
		else
		{
			$.get(_webPath + "alicms.aspx?Object=" + __object + "&Operation=IsNoExist&No=" + encodeURIComponent(me.val()), function (data)
			{
				if (data.toLowerCase() == "true")
					me.next("strong").html(_lang_no_exist);
				else
					me.next("strong").html("");
			});
		}
	};
	
	var checkNo = function(nextCall)
	{
		var me = $("[name=No]");
		if (typeof(me.data("Old")) == "undefined" || me.val() != me.data("Old"))
		{
			$.get(_webPath + "alicms.aspx?Object=" + __object + "&Operation=IsNoExist&No=" + encodeURIComponent(me.val()), function (data)
			{
				if (data.toLowerCase() == "true")
				{
					Alert(_lang_no_exist, function(){me[0].select();}, this);
				}
				else
				{
					me.next("strong").html("");
					nextCall();
				}
			});
		}
		else
		{
			me.next("strong").html("");
			nextCall();
		}
	};

	var add_Send = function()
	{
		var form = $("form:first")[0];
		
		var data = "No=" + encodeURIComponent(form.No.value);
		data += "&Name=" + encodeURIComponent(form.Name.value);
		data += "&IsDefault=" + $("#IsDefaultYes")[0].checked;
		
		__base.add({object:__object,data:data});
	};

	var modify_Send = function()
	{
		var form = $("form:first")[0];
		
		var data = "Name=" + encodeURIComponent(form.Name.value);
		data += "&IsDefault=" + $("#IsDefaultYes")[0].checked;
		
		__base.modify({object:__object,data:data});
	};
}
//End : 角色
//-------------------------------------------------

//-------------------------------------------------
//Start : 用户
function User()
{
	var __object = 'User',
		__base = new Base(),
		__uploadHead,
		__role = [];

	this.onNameChange = function()
	{
		var me = $(this);
		if (me.val() == '')
		{
			me.next('strong').html(_lang_name_empty);
		}
		else if (typeof(me.data('old')) != 'undefined' && me.val() == me.data('old'))
		{
			me.next('strong').html('');
		}
		else
		{
			$.get(_webPath + 'alicms.aspx?Object=' + __object + '&Operation=IsNameExist&Name=' + encodeURIComponent(me.val()),function(data)
			{
				if (data.toLowerCase() == 'true')
					me.next('strong').html(_lang_name_exist);
				else
					me.next('strong').html('');
			});
		}
	};

	this.onMobileChange = function()
	{
		var me = $(this);
		if (me.val() == '' || (typeof(me.data('old')) != 'undefined' && me.val() == me.data('old')))
		{
			me.next('strong').html('');
			return;
		}
		else
		{
			$.get(_webPath + 'alicms.aspx?Object=' + __object + '&Operation=IsMobileExist&Mobile=' + encodeURIComponent(me.val()),function(data)
			{
				if (data.toLowerCase() == 'true')
					me.next('strong').html(_lang_mobile_exist);
				else
					me.next('strong').html('');
			});
		}
	};

	this.onEmailChange = function()
	{
		var me = $(this);
		if (me.val() == '' || (typeof(me.data('old')) != 'undefined' && me.val() == me.data('old')))
		{
			me.next('strong').html('');
			return;
		}
		else
		{
			$.get(_webPath + 'alicms.aspx?Object=' + __object + '&Operation=IsEmailExist&Email=' + encodeURIComponent(me.val()),function(data)
			{
				if (data.toLowerCase() == 'true')
					me.next('strong').html(_lang_email_exist);
				else
					me.next('strong').html('');
			});
		}
	};
	
	var checkName = function()
	{
		var me = $('[name=Name]');
		if (typeof(me.data('old')) == 'undefined' || me.val() != me.data('old'))
		{
			$.get(_webPath + 'alicms.aspx?Object=' + __object + '&Operation=IsNameExist&Name=' + encodeURIComponent(me.val()), function(data)
			{
				if (data.toLowerCase() == 'true')
				{
					Alert(_lang_name_exist, function(){me[0].select();}, this);
				}
				else
				{
					me.next('strong').html('');
					checkMobile();
				}
			});
		}
		else
		{
			me.next('strong').html('');
			checkMobile();
		}
	};
	
	var checkMobile = function()
	{
		var me = $('[name=Mobile]');
		if (me.val() == '')
		{
			checkEmail();
			return;
		}

		if (typeof(me.data('old')) == 'undefined' || me.val() != me.data('old'))
		{
			$.get(_webPath + 'alicms.aspx?Object=' + __object + '&Operation=IsMobileExist&Mobile=' + encodeURIComponent(me.val()), function(data)
			{
				if (data.toLowerCase() == 'true')
				{
					Alert(_lang_mobile_exist, function(){me[0].select();}, this);
				}
				else
				{
					me.next('strong').html('');
					checkEmail();
				}
			});
		}
		else
		{
			me.next('strong').html('');
			checkEmail();
		}
	};
	
	var checkEmail = function()
	{
		var me = $('[name=Email]');
		if (me.val() == '')
		{
			if (_page == 'user_add')
				add_Send();
			else
				modify_Send();
			return;
		}

		if (typeof(me.data('old')) == 'undefined' || me.val() != me.data('old'))
		{
			$.get(_webPath + 'alicms.aspx?Object=' + __object + '&Operation=IsEmailExist&Email=' + encodeURIComponent(me.val()), function(data)
			{
				if (data.toLowerCase() == 'true')
				{
					Alert(_lang_email_exist, function(){me[0].select();}, this);
				}
				else
				{
					me.next('strong').html('');
					if (_page == 'user_add')
						add_Send();
					else
						modify_Send();
				}
			});
		}
		else
		{
			me.next('strong').html('');
			if (_page == 'user_add')
				add_Send();
			else
				modify_Send();
		}
	};

	this.add = function()
	{
		if ($.trim(this.Name.value) == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		if ($.trim(this.Password.value) == '')
		{
			Alert(_lang_password_empty, function(){this.Password.select();}, this);
			return false;
		}
		
		if (this.Mobile.value != '' && !this.Mobile.value.match(/^\d{11}$/))
		{
			Alert(_lang_mobile_incorrect, function(){this.Mobile.select();}, this);
			return false;
		}
		
		if (this.Email.value != '' && !this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
		{
			Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
			return false;
		}
		
		//角色
		__role = prepareCheckboxData('[name=Role]');
		
		checkName();
	
		return false;	
	}
	
	function add_Send()
	{
		var form = $('form:first')[0];
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		if ($('#GuidCheckBox')[0].checked)
			data += '&ID=' + form.ID.value;
		data += '&Password=' + encodeURIComponent(form.Password.value);
		data += '&Mobile=' + encodeURIComponent(form.Mobile.value);
		data += '&Email=' + encodeURIComponent(form.Email.value);
		data += '&RealName=' + encodeURIComponent(form.RealName.value);
		data += '&Sex=' + encodeURIComponent(form.Sex.value);
		data += '&Birthday=' + encodeURIComponent(form.Birthday.value);
		data += '&QQ=' + encodeURIComponent(form.QQ.value);
		data += '&AgentLevelID=' + form.AgentLevelID.value;
		data += '&Profile=' + encodeURIComponent(form.Profile.value);

		var residence = $('#Residence [value!=""]:selected:last')
		if (residence.length)
			data += '&Residence=' + residence.val();
		
		var origin = $('#Origin [value!=""]:selected:last');
		if (origin.length)
			data += '&Origin=' + origin.val();

		__uploadHead = _uploader.NeedUpload('Head');
		if (!__uploadHead)
			data += '&Head=' + encodeURIComponent(form.Head.value);
	
		var guid = __base.add({object:__object,data:data,silent:true});
		if (guid)
		{
			var id = __base.post({object:__object,operation:'GetInnerIDFromGuid',params:'ID=' + guid,silent:true});
			add_addRole(guid, id);
		}
		else
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
		}
	}
	
	function add_addRole(guid, id)
	{
		if (__role.index >= __role.list.length)
		{
			uploadHead(id);
			return;
		}
		
		var data = 'UserID=' + guid;
		data += '&RoleID=' + __role.list[__role.index].value;
		
		__role.index++;
		
		__base.add({object:'User.Role',data:data,silent:true});
		add_addRole(guid);
	}

	this.modify = function()
	{
		if (this.Mobile.value != "" && !this.Mobile.value.match(/^\d{11}$/))
		{
			Alert(_lang_mobile_incorrect, function(){this.Mobile.select();}, this);
			return false;
		}
		
		if (this.Email.value != "" && !this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
		{
			Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
			return false;
		}
		
		checkName();
	
		return false;	
	}
	
	function modify_Send()
	{
		var form = $("form:first")[0];

		var data = "Mobile=" + encodeURIComponent(form.Mobile.value);
		if (form.Password.value != "")
			data += "&Password=" + encodeURIComponent(form.Password.value);
		data += "&Email=" + encodeURIComponent(form.Email.value);
		data += '&RealName=' + encodeURIComponent(form.RealName.value);
		data += '&Sex=' + encodeURIComponent(form.Sex.value);
		data += '&Birthday=' + encodeURIComponent(form.Birthday.value);
		data += '&QQ=' + encodeURIComponent(form.QQ.value);
		data += "&AgentLevelID=" + form.AgentLevelID.value;
		data += "&Profile=" + encodeURIComponent(form.Profile.value);

		var residence = $('#Residence [value!=""]:selected:last')
		if (residence.length)
			data += '&Residence=' + residence.val();
		else
			data += '&Residence=';
		
		var origin = $('#Origin [value!=""]:selected:last');
		if (origin.length)
			data += '&Origin=' + origin.val();
		else
			data += '&Origin=';

		__uploadHead = _uploader.NeedUpload('Head');
		if (!__uploadHead)
			data += '&Head=' + encodeURIComponent(form.Head.value);
		
		//角色
		prepareCheckboxData('[name=Role]', __role);
	
		__base.modify({object:__object,data:data,silent:true});
		
		$(form.Mobile).data('old', form.Mobile.value);
		$(form.Email).data('old', form.Email.value);
		
		modify_DeleteRole();
	}
	
	function modify_DeleteRole()
	{
		if (__role.deleteIndex >= __role.deleteList.length)
		{
			modify_AddRole();
			return;
		}
		
		__base.post({object:'User.Role',operation:'Delete',params:'UserID=' + _guid + '&RoleID=' + __role.deleteList[__role.deleteIndex].val(),silent:true});
		__role.deleteIndex++;
		modify_DeleteRole();
	}
	
	function modify_AddRole()
	{
		if (__role.addIndex >= __role.addList.length)
		{
			uploadHead(_id);
			return;
		}
		
		var data = 'UserID=' + _guid;
		data += '&RoleID=' + __role.addList[__role.addIndex].val();
		
		__role.addIndex++;
		
		__base.add({object:'User.Role',data:data,silent:true});
		modify_AddRole();
	}

	function uploadHead(id)
	{
		if (!__uploadHead)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
	
		_uploader.Init({Status:_lang_uploading_head,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadHead&ID=' + id});
		_uploader.Upload('Head', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			}
			else
			{
				$('#HeadTextbox').val(arguments[1]);
				
				Alert(_lang_operation_success);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
				return;
			}
		});
	}
	
	this.update = function(operation, id)
	{
		if (this.tagName == "BUTTON")
			operation = this.id;

		__base.update(__object, operation, id);
	};
	
	this.onEditInit = function()
	{
		__role.list = $('[name=Role]').filter(':checked');
		$('[name=Sex]').val(_sex);

		if (_residenceLinkageData.id != '')
			linkageSelect(_residenceLinkageData);
		if (_originLinkageData.id != '')
			linkageSelect(_originLinkageData);	
	};
	
	this.residenceCallback = function()
	{
		if (_residenceLinkageData == null)
			return;

		var last = $('#Residence select:last');
		if (_residenceLinkageData.index < _residenceLinkageData.parents.length)
		{
			last.find('[data-inner-id=' + _residenceLinkageData.parents[_residenceLinkageData.index++] + ']').attr('selected', true);
			last.change();
		}
		else if (_residenceLinkageData != null)
		{
			last.find('[value=' + _residenceLinkageData.id + ']').attr('selected', true);
			last.change();
			_residenceLinkageData = null;
		}
	};
	
	this.originCallback = function()
	{
		if (_originLinkageData == null)
			return;

		var last = $('#Residence select:last');
		if (_originLinkageData.index < _originLinkageData.parents.length)
		{
			last.find('[data-inner-id=' + _originLinkageData.parents[_originLinkageData.index++] + ']').attr('selected', true);
			last.change();
		}
		else if (_originLinkageData != null)
		{
			last.find('[value=' + _originLinkageData.id + ']').attr('selected', true);
			last.change();
			_originLinkageData = null;
		}
	};
}
//End : 用户
//-------------------------------------------------

//-------------------------------------------------
//Start : 资金
function UserMoney()
{
	var __object = 'User.Money',
		__base = new Base();
	
	this.add = function()
	{
		if (!this.Amount.value.match(/^-?\d+(\.\d+)?$/))
		{
			Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
			return false;
		}
		
		var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
		if (!re.test(this.Time.value))
		{
			Alert(_lang_time_incorrect, function(){this.Time.select();}, this);
			return false;
		}
	
		var data = "UserID=" + _userID;
		data += "&Amount=" + this.Amount.value;
		if (parseInt(this.Amount.value) > 0)
			data += "&Title=" + encodeURIComponent(_creatorName + _lang_title_plus);
		else
			data += "&Title=" + encodeURIComponent(_creatorName + _lang_title_minus);
		data += "&Time=" + encodeURIComponent(this.Time.value);
		data += "&Memo=" + encodeURIComponent(this.Memo.value);
		if (this.PaymentID.value != "")
		{
			var payment = $("[name=PaymentID] :selected");
			data += "&PaymentID=" + encodeURIComponent(payment.val());
			data += "&PaymentName=" + encodeURIComponent(payment.text());
			data += "&PaymentType=" + encodeURIComponent(payment.data("type"));
			data += "&PaymentAccount=" + encodeURIComponent(payment.data("account"));
		}
		
		__base.post({object:__object,data:data,operation:"Add",hasList:true});
		
		return false;
	};
}
//End : 资金
//-------------------------------------------------

//-------------------------------------------------
//Start : 应用
function App()
{
	var __object = 'App',
		__base = new Base(),
		__uploadLogo;

	this.add = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}

		var data = 'Name=' + encodeURIComponent(this.Name.value);
		data += '&Url=' + encodeURIComponent(this.Url.value);
		data += '&Profile=' + encodeURIComponent(this.Profile.value);

		__uploadLogo = _uploader.NeedUpload('Logo');
		if (!__uploadLogo)
			data += '&Logo=' + encodeURIComponent(form.Logo.value);

		var guid = __base.add({object:__object,data:data,silent:true});
		if (guid)
		{
			var id = __base.post({object:__object,operation:'GetInnerIDFromGuid',params:'ID=' + guid,silent:true});
			uploadLogo(id);
		}
		
		return false;
	};
	
	this.modify = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}

		var data = 'Name=' + encodeURIComponent(this.Name.value);
		data += '&Url=' + encodeURIComponent(this.Url.value);
		data += '&Profile=' + encodeURIComponent(this.Profile.value);

		__uploadLogo = _uploader.NeedUpload('Logo');
		if (!__uploadLogo)
			data += '&Logo=' + encodeURIComponent(form.Logo.value);

		__base.modify({object:__object,data:data,silent:true});

		uploadLogo(_id);

		return false;	
	};

	function uploadLogo(id)
	{
		if (!__uploadLogo)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
	
		_uploader.Init({Status:_lang_uploading_logo,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadLogo&ID=' + id});
		_uploader.Upload('Logo', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			}
			else
			{
				$('#LogoTextbox').val(arguments[1]);
				
				Alert(_lang_operation_success);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
				return;
			}
		});
	}
	
	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id);
	};
}
//End : 应用
//-------------------------------------------------

//-------------------------------------------------
//Start : 产品
function Product()
{
	var __object = 'Product',
		__base = new Base(),
		__uploadFile;

	this.add = function()
	{
		if (this.No.value == "")
		{
			Alert(_lang_no_empty, function(){this.No.select();}, this);
			return false;
		}
		
		if (this.Name.value == "")
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		if (!this.Price.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_price_incorrect, function(){this.Price.select();}, this);
			return false;
		}
		
		if (this.Kind.value == 'Instance' && this.InstanceID.selectedIndex == -1)
		{
			Alert(_lang_instance_id_empty);
			return false;
		}
		
		//代理价格
		_agentPriceIndex = 0;
		_agentPrices.length = 0;
		var rows = $("#AgentTable tbody tr");
		for (var i = 0; i < rows.length; i++)
		{
			var checkbox = rows.eq(i).find(":checkbox")[0];
			if (!checkbox.checked)
				continue;
	
			var inputs = rows.eq(i).find(":text");
	
			if (!inputs.eq(0).val().match(/^\d+(\.\d+)?%?$/))
			{
				Alert(_lang_agent_price_incorrect, function(){inputs[0].select();}, this);
				return false;
			}
	
			_agentPrices.push({LevelID:checkbox.value,Price:inputs.eq(0).val()});
		}
		
		checkNo(add_Send);
		
		return false;
	};
	
	this.modify = function()
	{
		if (this.No.value == "")
		{
			Alert(_lang_no_empty, function(){this.No.select();}, this);
			return false;
		}
		
		if (this.Name.value == "")
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		if (!this.Price.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_price_incorrect, function(){this.Price.select();}, this);
			return false;
		}
		
		if (this.Kind.value == 'Instance' && this.InstanceID.selectedIndex == -1)
		{
			Alert(_lang_instance_id_empty);
			return false;
		}
	
		//代理价格
		_agentPriceIndex = 0;
		var agentPrices = _agentPrices;
		_agentPrices = [];
		var rows = $("#AgentTable tbody tr");
		for (var i = 0; i < rows.length; i++)
		{
			var checkbox = rows.eq(i).find(":checkbox")[0];
			var inputs = rows.eq(i).find(":text");
			var levelID = checkbox.value;
			var price = inputs.eq(0).val();
	
			if (!price.match(/^\d+(\.\d+)?%?$/))
			{
				Alert(_lang_agent_price_incorrect, function(){inputs[0].select();}, this);
				return false;
			}
	
			if (checkbox.checked)
			{
				var j = 0;
				for (; j < agentPrices.length; j++)
				{
					if (levelID == agentPrices[j].LevelID)
						break;
				}
	
				if (j < agentPrices.length)
				{
					if (agentPrices[j].Action == "Delete")
						continue;
	
					if (price != agentPrices[j].Price)
						_agentPrices.push({LevelID:levelID,Price:price,Action:"Modify"});
					else
						_agentPrices.push({LevelID:levelID,Price:price,Action:null});
				}
				else
				{
					_agentPrices.push({LevelID:levelID,Price:price,Action:"Add"});
				}
			}
			else
			{
				for (var j = 0; j < agentPrices.length; j++)
				{
					if (levelID == agentPrices[j].LevelID)
					{
						if (agentPrices[j].Action != "Delete")
							_agentPrices.push({LevelID:levelID,Price:price,Action:"Delete"});
						break;
					}
				}
			}
		}
		
		checkNo(modify_Send);
		
		return false;	
	};
	
	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id);
	};
	
	this.onNoChange = function()
	{
		var me = $(this);
		if (me.val() == "")
		{
			me.next("strong").html(_lang_no_empty);
		}
		else if (typeof(me.data("Old")) != "undefined" && me.val() == me.data("Old"))
		{
			me.next("strong").html("");
		}
		else
		{
			$.get(_webPath + "alicms.aspx?Object=" + __object + "&Operation=IsNoExist&No=" + encodeURIComponent(me.val()), function (data)
			{
				if (data.toLowerCase() == "true")
					me.next("strong").html(_lang_no_exist);
				else
					me.next("strong").html("");
			});
		}
	};
	
	var checkNo = function(nextCall)
	{
		var me = $('[name=No]');
		var no = $('#prefix').text() + me.val();
		if (typeof(me.data('old')) == 'undefined' || no != me.data('old'))
		{
			$.get(_webPath + 'alicms.aspx?Object=' + __object + '&Operation=IsNoExist&No=' + encodeURIComponent(no), function (data)
			{
				if (data.toLowerCase() == 'true')
				{
					Alert(_lang_no_exist, function(){me[0].select();}, this);
				}
				else
				{
					me.next('strong').html('');
					nextCall();
				}
			});
		}
		else
		{
			me.next('strong').html('');
			nextCall();
		}
	};
	
	var add_Send = function()
	{
		var form = $('form:first')[0];
		
		var data = 'No=' + encodeURIComponent($('#prefix').text() + form.No.value);
		data += '&Name=' + encodeURIComponent(form.Name.value);
		data += '&Kind=' + form.Kind.value;
		data += '&Price=' + form.Price.value;
		data += '&TimeUnit=' + form.TimeUnit.value;
		data += '&Description=' + encodeURIComponent(CKEDITOR.instances[form.Description.id].getData());

		if (form.Kind.value == 'Service')
		{
			data += '&File=';
			data += '&InstanceID=';
		}
		else if (form.Kind.value == 'Instance')
		{
			data += '&File=';
			data += '&InstanceID=' + form.InstanceID.value;
		}
		else
		{
			__uploadFile = _uploader.NeedUpload('File');
			if (!__uploadFile)
				data += '&File=' + encodeURIComponent(form.File.value);
			data += '&InstanceID=';
		}
		
		var guid = __base.add({object:__object,data:data,silent:true});
		if (guid)
		{
			var id = __base.post({object:__object,operation:'GetInnerIDFromGuid',params:'ID=' + guid,silent:true});
			addAgentPrice(id, guid);
		}		
	};

	var modify_Send = function()
	{
		var form = $('form:first')[0];
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		if (form.No.value != $(form.No).data('old'))
		{
			var no = $('#prefix').text() + form.No.value;
			data += '&No=' + encodeURIComponent(no);
			$(form.No).data('old', no)
		}
		data += '&Kind=' + form.Kind.value;
		data += '&Price=' + form.Price.value;
		data += '&TimeUnit=' + form.TimeUnit.value;
		data += '&Description=' + encodeURIComponent(CKEDITOR.instances[form.Description.id].getData());

		if (form.Kind.value == 'Service')
		{
			data += '&File=';
			data += '&InstanceID=';
		}
		else if (form.Kind.value == 'Instance')
		{
			data += '&File=';
			data += '&InstanceID=' + form.InstanceID.value;
		}
		else
		{
			__uploadFile = _uploader.NeedUpload('File');
			if (!__uploadFile)
				data += '&File=' + encodeURIComponent(form.File.value);
			data += '&InstanceID=';
		}
		
		__base.modify({object:__object,data:data,silent:true});
		setAgentPrice(_id, _guid);
	};
	
	var addAgentPrice = function(id, guid)
	{
		if (_agentPriceIndex >= _agentPrices.length)
		{
			uploadFile(id);
			return;
		}
		
		//if (_agentPriceIndex == 0)
		//	_guid = data;
		
		var data = 'ProductID=' + guid;
		data += '&LevelID=' + _agentPrices[_agentPriceIndex].LevelID;
		data += '&Price=' + _agentPrices[_agentPriceIndex].Price;
		
		_agentPriceIndex++;
		
		__base.post({object:'Product.AgentPrice',operation:'Add',data:data,statusMessage:_lang_adding_agent_price,onSuccess:addAgentPrice});
	};
	
	var setAgentPrice = function(id, guid)
	{
		if (_agentPriceIndex >= _agentPrices.length)
		{
			for (var i = _agentPrices.length - 1; i >= 0; i--)
			{
				if (_agentPrices[i].Action == 'Delete')
					_agentPrices.splice(i, 1);
			}
			
			uploadFile(id);
			return;
		}
		
		var operation;
		var params = null;
		var data;
		if (_agentPrices[_agentPriceIndex].Action == null)
		{
			_agentPriceIndex++;
			setAgentPrice();
			return;
		}
		else if (_agentPrices[_agentPriceIndex].Action == 'Add')
		{
			operation = "Add";
			data = "ProductID=" + guid + "&LevelID=" + _agentPrices[_agentPriceIndex].LevelID + "&Price=" + _agentPrices[_agentPriceIndex].Price;
		}
		else if (_agentPrices[_agentPriceIndex].Action == "Modify")
		{
			operation = "Modify";
			params = "ProductID=" + guid + "&LevelID=" + _agentPrices[_agentPriceIndex].LevelID;
			data = "Price=" + _agentPrices[_agentPriceIndex].Price + "&Award=" + _agentPrices[_agentPriceIndex].Award;
		}
		else if (_agentPrices[_agentPriceIndex].Action == "Delete")
		{
			operation = "Delete";
			params = "ProductID=" + guid + "&LevelID=" + _agentPrices[_agentPriceIndex].LevelID;
			data = {};
		}
	
		_agentPriceIndex++;
		
		__base.post({object:"Product.AgentPrice",operation:operation,data:data,statusMessage:_lang_modifying_agent_price,onSuccess:setAgentPrice,params:params});
	};

	function uploadFile(id)
	{
		if (!__uploadFile)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
	
		_uploader.Init({Status:_lang_uploading_file,Params:'Lang=' + _lang + '&Object=' + __object + '&Operation=UploadFile&ID=' + id});
		_uploader.Upload('File', function()
		{
			if (arguments[0] != 0)
			{
				Alert(arguments[1]);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
			}
			else
			{
				$('#FileTextbox').val(arguments[1]);
				
				Alert(_lang_operation_success);
				SetStatusMessage();
				$(':submit')[0].disabled = false;
				return;
			}
		});
	}
	
	this.onKindChange = function()
	{
		if (this.value == 'File')
		{
			$('#instance').hide();
			$('#file').show();
		}
		else if (this.value == 'Instance')
		{
			$('#instance').show();
			$('#file').hide();
		}
		else
		{
			$('#file,#instance').hide();
		}
	};
}
//End : 产品
//-------------------------------------------------

//-------------------------------------------------
//Start : 套餐
function Combo()
{
	var __object = 'Combo',
		__base = new Base();

	this.add = function()
	{
		if (this.No.value == '')
		{
			Alert(_lang_no_empty, function(){this.No.select();}, this);
			return false;
		}
		
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		if (!this.Price.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_price_incorrect, function(){this.Price.select();}, this);
			return false;
		}

		
		var productsRows = $('#ProductTable tbody tr');
		if (productsRows.length == 0)
		{
			Alert(_lang_select_product);
			return false;
		}
		
		//产品列表
		_productIndex = 0;
		_products.length = 0;
		for (var i = 0; i < productsRows.length; i++)
		{
			_products.push({id:productsRows[i].id,amount:$('td:eq(3)', productsRows[i]).text()});
		}
		
		//代理价格
		_agentPriceIndex = 0;
		_agentPrices.length = 0;
		var rows = $('#AgentTable tbody tr');
		for (var i = 0; i < rows.length; i++)
		{
			var checkbox = rows.eq(i).find(':checkbox')[0];
			if (!checkbox.checked)
				continue;
	
			var inputs = rows.eq(i).find(':text');
	
			if (!inputs.eq(0).val().match(/^\d+(\.\d+)?%?$/))
			{
				Alert(_lang_agent_price_incorrect, function(){inputs[0].select();}, this);
				return false;
			}
	
			_agentPrices.push({LevelID:checkbox.value,Price:inputs.eq(0).val()});
		}
		
		checkNo(add_Send);
		
		return false;
	};
	
	this.modify = function()
	{
		if (this.No.value == '')
		{
			Alert(_lang_no_empty, function(){this.No.select();}, this);
			return false;
		}
		
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		if (!this.Price.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_price_incorrect, function(){this.Price.select();}, this);
			return false;
		}
		
		var productsRows = $('#ProductTable tbody tr');
		if (productsRows.length == 0)
		{
			Alert(_lang_select_product);
			return false;
		}
		
		//产品列表
		_productIndex = 0;
		var products = _products;
		_products = [];
		for (var i = 0; i < productsRows.length; i++)
		{
			var id = productsRows[i].id;
			
			var j = 0;
			for (; j < products.length; j++)
			{
				if (id == products[j].id)
					break;
			}
	
			if (j < products.length)
				_products.push({id:productsRows[i].id,amount:$('td:eq(3)', productsRows[i]).text(),action:null});
			else
				_products.push({id:productsRows[i].id,amount:$('td:eq(3)', productsRows[i]).text(),action:'Add'});
		}
	
		for (var i = 0; i < products.length; i++)
		{
			var rows = $('#ProductTable tbody tr[id=' + products[i].id + ']');
			if (rows.length == 0)
				_products.push({id:products[i].id,action:'Delete'});
		}
	
		//代理价格
		_agentPriceIndex = 0;
		var agentPrices = _agentPrices;
		_agentPrices = [];
		var rows = $('#AgentTable tbody tr');
		for (var i = 0; i < rows.length; i++)
		{
			var checkbox = rows.eq(i).find(':checkbox')[0];
			var inputs = rows.eq(i).find(':text');
			var levelID = checkbox.value;
			var price = inputs.eq(0).val();
	
			if (!price.match(/^\d+(\.\d+)?%?$/))
			{
				Alert(_lang_agent_price_incorrect, function(){inputs[0].select();}, this);
				return false;
			}
	
			if (checkbox.checked)
			{
				var j = 0;
				for (; j < agentPrices.length; j++)
				{
					if (levelID == agentPrices[j].LevelID)
						break;
				}
	
				if (j < agentPrices.length)
				{
					if (price != agentPrices[j].Price)
						_agentPrices.push({LevelID:levelID,Price:price,Action:"Modify"});
					else
						_agentPrices.push({LevelID:levelID,Price:price,Action:null});
				}
				else
				{
					_agentPrices.push({LevelID:levelID,Price:price,Action:"Add"});
				}
			}
			else
			{
				for (var j = 0; j < agentPrices.length; j++)
				{
					if (levelID == agentPrices[j].LevelID)
					{
						_agentPrices.push({LevelID:levelID,Price:price,Action:"Delete"});
						break;
					}
				}
			}
		}
		
		checkNo(modify_Send);
		
		return false;	
	};
	
	this.update = function(operation, id)
	{
		if (this.tagName == "BUTTON")
			operation = this.id;

		__base.update(__object, operation, id);
	};
	
	this.onNoChange = function()
	{
		var me = $(this);
		if (me.val() == "")
		{
			me.next("strong").html(_lang_no_empty);
		}
		else if (typeof(me.data("Old")) != "undefined" && me.val() == me.data("Old"))
		{
			me.next("strong").html("");
		}
		else
		{
			$.get(_webPath + "alicms.aspx?Object=" + __object + "&Operation=IsNoExist&No=" + encodeURIComponent(me.val()), function (data)
			{
				if (data.toLowerCase() == "true")
					me.next("strong").html(_lang_no_exist);
				else
					me.next("strong").html("");
			});
		}
	};
	
	var checkNo = function(nextCall)
	{
		var me = $("[name=No]");
		if (typeof(me.data("Old")) == "undefined" || me.val() != me.data("Old"))
		{
			$.get(_webPath + "alicms.aspx?Object=" + __object + "&Operation=IsNoExist&No=" + encodeURIComponent(me.val()), function (data)
			{
				if (data.toLowerCase() == "true")
				{
					Alert(_lang_no_exist, function(){me[0].select();}, this);
				}
				else
				{
					me.next("strong").html("");
					nextCall();
				}
			});
		}
		else
		{
			me.next("strong").html("");
			nextCall();
		}
	};
	
	var add_Send = function()
	{
		var form = $('form:first')[0];
		
		var data = 'No=' + $('#prefix').text() + encodeURIComponent(form.No.value);
		data += '&Name=' + encodeURIComponent(form.Name.value);
		data += '&Price=' + form.Price.value;
		data += '&TimeUnit=' + form.TimeUnit.value;
		data += '&AppID=' + form.AppID.value;
		data += '&Description=' + encodeURIComponent(CKEDITOR.instances[this.Description.id].getData());
		
		__base.add({object:__object,data:data,onSuccess:addAgentPrice});
	};

	var modify_Send = function()
	{
		var form = $('form:first')[0];
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		if (form.No.value != $(form.No).data('old'))
		{
			var no = encodeURIComponent($('#prefix').text() + form.No.value);
			data += '&No=' + no;
			$(form.No).data('old', no)
		}
		data += '&Price=' + form.Price.value;
		data += '&TimeUnit=' + form.TimeUnit.value;
		data += '&AppID=' + form.AppID.value;
		data += '&Description=' + encodeURIComponent(CKEDITOR.instances[this.Description.id].getData());
		
		__base.modify({object:__object,data:data,onSuccess:setAgentPrice});
	};
	
	var addAgentPrice = function(data)
	{
		if (_agentPriceIndex == 0)
			_guid = data;
		
		if (_agentPriceIndex >= _agentPrices.length)
		{
			addProduct();
			return;
		}
		
		var data = 'ComboID=' + _guid;
		data += '&LevelID=' + _agentPrices[_agentPriceIndex].LevelID;
		data += '&Price=' + _agentPrices[_agentPriceIndex].Price;
		
		_agentPriceIndex++;
		
		__base.post({object:'Combo.AgentPrice',operation:'Add',data:data,statusMessage:_lang_adding_agent_price,onSuccess:addAgentPrice});
	};
	
	var setAgentPrice = function()
	{
		if (_agentPriceIndex >= _agentPrices.length)
		{
			for (var i = _agentPrices.length - 1; i >= 0; i--)
			{
				if (_agentPrices[i].Action == 'Delete')
					_agentPrices.splice(i, 1);
			}
			
			setProduct();
			return;
		}
		
		var operation;
		var params = null;
		var data;
		if (_agentPrices[_agentPriceIndex].Action == null)
		{
			_agentPriceIndex++;
			setAgentPrice();
			return;
		}
		else if (_agentPrices[_agentPriceIndex].Action == 'Add')
		{
			operation = 'Add';
			data = 'ComboID=' + _guid + '&LevelID=' + _agentPrices[_agentPriceIndex].LevelID + '&Price=' + _agentPrices[_agentPriceIndex].Price;
		}
		else if (_agentPrices[_agentPriceIndex].Action == 'Modify')
		{
			operation = 'Modify';
			params = 'ComboID=' + _guid + '&LevelID=' + _agentPrices[_agentPriceIndex].LevelID;
			data = 'Price=' + _agentPrices[_agentPriceIndex].Price;
		}
		else if (_agentPrices[_agentPriceIndex].Action == 'Delete')
		{
			operation = 'Delete';
			params = 'ComboID=' + _guid + '&LevelID=' + _agentPrices[_agentPriceIndex].LevelID;
			data = {};
		}
	
		_agentPriceIndex++;
		
		__base.post({object:'Combo.AgentPrice',operation:operation,data:data,statusMessage:_lang_modifying_agent_price,onSuccess:setAgentPrice,params:params});
	};
	
	var addProduct = function()
	{
		if (_productIndex >= _products.length)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			
			return;
		}
		
		var data = 'ComboID=' + _guid;
		data += '&ProductID=' + _products[_productIndex].id;
		data += '&Amount=' + _products[_productIndex].amount;
		
		_productIndex++;
		
		__base.post({object:'Combo.Product',operation:'Add',data:data,statusMessage:_lang_adding_product,onSuccess:addProduct});
	};
	
	var setProduct = function()
	{
		if (_productIndex >= _products.length)
		{
			for (var i = _products.length - 1; i >= 0; i--)
			{
				if (_products[i].action == 'Delete')
					_products.splice(i, 1);
			}
			
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
		
		var operation;
		var params = null;
		var data;
		if (_products[_productIndex].action == null)
		{
			_productIndex++;
			setProduct();
			return;
		}
		else if (_products[_productIndex].action == 'Add')
		{
			operation = 'Add';
			data = 'ComboID=' + _guid + '&ProductID=' + _products[_productIndex].id + '&Amount=' + _products[_productIndex].amount;
		}
		else if (_products[_productIndex].action == 'Delete')
		{
			operation = 'Delete';
			params = 'ComboID=' + _guid + '&ProductID=' + _products[_productIndex].id;
			data = {};
		}
	
		_productIndex++;
		
		__base.post({object:'Combo.Product',operation:operation,data:data,statusMessage:_lang_modifying_product,onSuccess:setProduct,params:params});
	};
	
	var selectProductCallback = function()
	{
		var me = $(this);
		var row = me.closest('tr');
		var productTable = $('#ProductTable tbody');
		
		var rows = productTable.children('[id="' + row.attr('id') + '"]');
		if (rows.length > 0)
			return;

		var html = '<tr id="' + row.attr('id') + '" data-price="' + row.data('price') + '">';
		html += '<td class="' + _lang + 'Font">' + row.children(':eq(0)').text() + '</td>';
		html += '<td>' + row.children(':eq(1)').text() + '</td>';
		html += '<td>' + row.children(':eq(2)').text() + '</td>';
		html += '<td>' + row.find('input').val() + '</td>';
		html += '<td><button type="button">' + _lang_delete + '</button></td>';
		html += '</tr>';
		productTable.append(html);
		
		//计算价格
		calcPrice();
	};

	this.selectProduct = function()
	{
		__base.showDialog({url:"../product/select.aspx?Lang=" + _lang,callback:selectProductCallback});
	};
	
	this.deleteProduct = function()
	{
		$(this).closest("tr").remove();
		
		//计算价格
		calcPrice();
	};
	
	function calcPrice()
	{
		var price = 0;
		$('#ProductTable tbody tr').each(function()
		{
			price += parseFloat($(this).data('price')) * parseInt($('td:eq(3)', this).text());
		});
		$('[name=Price]').val(price);
	}
}
//End : 套餐
//-------------------------------------------------

//-------------------------------------------------
//Start : 特权
function Privilege()
{
	var __object = 'Privilege',
		__base = new Base();
	
	this.save = function()
	{
		_addIndex = 0;
		_addList.length = 0;
		_deleteIndex = 0;
		_deleteList.length = 0;
	
		$("[name=OperationID]").each(function()
		{
			var me = $(this);
			if (this.checked && me.attr("PrivilegeID") == "")
			{
				var data = "InstanceID=" + $("#InstanceID").val() + "&Lang=" + $("#CurrentLang").val() + "&ObjectID=" + me.attr("ObjectID") + "&OperationID=" + me.val() + "&ObjectName=" + me.attr("ObjectName") + "&OperationName=" + me.attr("OperationName");
				if (_type == "Role")
				{
					data += "&RoleID=" + _guid;
					data += "&RoleNo=" + _no;
				}
				else if (_type == "Product")
				{
					data += "&ProductID=" + _guid;
					data += "&ProductNo=" + _no;
				}
				else if (_type == "Combo")
				{
					data += "&ComboID=" + _guid;
					data += "&ComboNo=" + _no;
				}
	
				_addList[_addList.length] = new Object();
				_addList[_addList.length - 1].ID = this.id;
				_addList[_addList.length - 1].Data = data;
			}
			else if (!this.checked && me.attr("PrivilegeID") != "")
			{
				_deleteList[_deleteList.length] = new Object();
				_deleteList[_deleteList.length - 1].ID = this.id;
				_deleteList[_deleteList.length - 1].PrivilegeID = me.attr("PrivilegeID");
			}
		});
		
		if (_addList.length == 0 && _deleteList.length == 0)
		{
			Alert(_lang_no_changes);
			return;
		}
		
		$("#Save").attr("disabled", true);
		SetStatusMessage(_lang_working);
		del();
	};
	
	var del = function()
	{
		if (_deleteIndex > 0)
			$("#" + _deleteList[_deleteIndex - 1].ID).attr("PrivilegeID", "");

		if (_deleteIndex >= _deleteList.length)
		{
			add();
			return;
		}

		__base.post({object:__object,operation:"Delete",data:{},params:"ID=" + _deleteList[_deleteIndex++].PrivilegeID});
		del();
	};
	
	var add = function(data)
	{
		if (_addIndex > 0)
			$("#" + _addList[_addIndex - 1].ID).attr("PrivilegeID", data);
		
		if (_addIndex >= _addList.length)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$("#Save").attr("disabled", false);
			return;
		}
		
		__base.add({object:__object,data:_addList[_addIndex++].Data,onSuccess:getInnerIDFromGuid});
		add();
	};
	
	var getInnerIDFromGuid = function(guid)
	{
		__base.post({object:__object,operation:"GetInnerIDFromGuid",data:{},onSuccess:add,params:"ID=" + guid});
	};
}
//End : 特权
//-------------------------------------------------

//-------------------------------------------------
//Start : 订单
function Order()
{
	var __object = 'Order',
		__base = new Base();

	this.add = function()
	{		
		if (this.Title.value == '')
		{
			Alert(_lang_title_empty, function(){this.Title.select();}, this);
			return false;
		}
	
		if (this.User.value == '')
		{
			Alert(_lang_user_empty, function(){this.User.select();}, this);
			return false;
		}
	
		if (!this.PriceAdjustment.value.match(/^-?\d+(\.\d+)?$/))
		{
			Alert(_lang_price_adjustment_incorrect, function(){this.PriceAdjustment.select();}, this);
			return false;
		}
		
		//产品列表
		_productIndex = 0;
		_products.length = 0;
		var products = $('#ProductTable tbody tr');
		if (products.length == 0)
		{
			Alert(_lang_product_empty);
			return false;
		}
			
		for (var i = 0; i < products.length; i++)
		{
			var row = products.eq(i);
			
			var product = new Object();
			product.id = row.attr('id');
			product.name = row.children(':eq(0)').text();
			product.no = row.children(':eq(1)').text();
			product.price = row.data('price');
			product.agentPrice = row.data('agentPrice');
			product.instanceId = row.data('instanceId');
			product.subInstanceId = row.children(':eq(6)').text();
			_products.push(product);
		}
		
		var data = 'Title=' + encodeURIComponent(this.Title.value);
		data += '&No=' + (this.No.value == '' ? FormatDate(new Date(), 'YYYYMMDDhhmmssSSS') : this.No.value);
		data += '&UserID=' + this.User.id;
		data += '&UserName=' + encodeURIComponent(this.User.value);
		if (this.Agent.value != '')
		{
			data += '&AgentID=' + this.Agent.id;
			data += '&AgentName=' + encodeURIComponent(this.Agent.value);
		}
		data += '&IsAgentPay=' + $('#IsAgentPayYes').prop('checked');
		data += '&TimeUnit=' + this.TimeUnit.value;
		data += '&TimeAmount=' + this.TimeAmount.value;
		data += '&PriceAdjustment=' + this.PriceAdjustment.value;
		data += '&AdminMemo=' + encodeURIComponent(this.AdminMemo.value);
		if (this.Combo.value != '')
		{
			data += '&ComboID=' + encodeURIComponent(this.Combo.value);
			data += '&ComboNo=' + encodeURIComponent($(':selected', this.Combo).data('no'));
		}
		data += '&Price=' + $('#Price').text();
		data += '&AgentPrice=' + $('#AgentPrice').text();
		data += '&Sum=' + $('#Sum').text();
		
		__base.add({object:__object,data:data,onSuccess:addProduct});
		
		return false;
	};
	
	this.modify = function()
	{
		if (this.Title.value == '')
		{
			Alert(_lang_title_empty, function(){this.Title.select();}, this);
			return false;
		}
	
		if (this.User.value == '')
		{
			Alert(_lang_user_empty, function(){this.User.select();}, this);
			return false;
		}
	
		if (!this.PriceAdjustment.value.match(/^-?\d+(\.\d+)?$/))
		{
			Alert(_lang_price_adjustment_incorrect, function(){this.PriceAdjustment.select();}, this);
			return false;
		}
		
		//产品列表
		_productIndex = 0;
		var products = _products;
		_products = [];
		var productsRows = $('#ProductTable tbody tr');
		if (productsRows.length == 0)
		{
			Alert(_lang_product_empty);
			return false;
		}
			
		for (var i = 0; i < productsRows.length; i++)
		{
			var id = productsRows[i].id;
			
			var j = 0;
			for (; j < products.length; j++)
			{
				if (id == products[j].id)
					break;
			}
	
			var row = productsRows.eq(i);
			if (j < products.length)
				_products.push({id:id,action:null});
			else
				_products.push({id:id,name:row.children(':eq(0)').text(),no:row.children(':eq(1)').text(),price:row.data('price'),agentPrice:row.data('agentPrice'),instanceId:row.data('instanceId'),subInstanceId:row.children(':eq(6)').text(),action:'Add'});
		}
	
		for (var i = 0; i < products.length; i++)
		{
			var rows = $('#ProductTable tbody tr[id=' + products[i].id + ']');
			if (rows.length == 0)
				_products.push({id:products[i].id,action:'Delete'});
		}
		
		var data = 'Title=' + encodeURIComponent(this.Title.value);
		data += '&UserID=' + this.User.id;
		data += '&UserName=' + encodeURIComponent(this.User.value);
		if (this.Agent.value != '')
		{
			data += '&AgentID=' + this.Agent.id;
			data += '&AgentName=' + encodeURIComponent(this.Agent.value);
		}
		data += '&IsAgentPay=' + $('#IsAgentPayYes').prop('checked');
		data += '&PriceAdjustment=' + this.PriceAdjustment.value;
		data += '&AdminMemo=' + encodeURIComponent(this.AdminMemo.value);
		if (this.Combo.value != '')
		{
			data += '&ComboID=' + encodeURIComponent(this.Combo.value);
			data += '&ComboNo=' + encodeURIComponent($(':selected', this.Combo).data('no'));
		}
		else
		{
			data += '&ComboID=';
			data += '&ComboNo=';
		}
		data += '&Price=' + $('#Price').text();
		data += '&AgentPrice=' + $('#AgentPrice').text();
		data += '&Sum=' + $('#Sum').text();
		
		__base.modify({object:__object,data:data,onSuccess:setProduct});
		
		return false;
	};
	
	var addProduct = function(data)
	{
		if (_productIndex == 0)
			_guid = data;
		
		if (_productIndex >= _products.length)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			
			return;
		}
		
		var data = 'OrderID=' + _guid;
		data += '&ProductID=' + _products[_productIndex].id;
		data += '&ProductNo=' + encodeURIComponent(_products[_productIndex].no);
		data += '&Name=' + encodeURIComponent(_products[_productIndex].name);
		data += '&Price=' + _products[_productIndex].price;
		data += '&AgentPrice=' + _products[_productIndex].agentPrice;
		data += '&InstanceID=' + _products[_productIndex].instanceId;
		data += '&SubInstanceID=' + _products[_productIndex].subInstanceId;
		
		_productIndex++;
		
		__base.add({object:'Order.Detail',data:data,statusMessage:_lang_adding_product,onSuccess:addProduct});		
	};
	
	var setProduct = function()
	{
		if (_productIndex >= _products.length)
		{
			for (var i = _products.length - 1; i >= 0; i--)
			{
				if (_products[i].action == 'Delete')
					_products.splice(i, 1);
			}
			
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(':submit')[0].disabled = false;
			return;
		}
		
		var operation;
		var params = null;
		var data;
		if (_products[_productIndex].action == null)
		{
			_productIndex++;
			setProduct();
			return;
		}
		else if (_products[_productIndex].action == 'Add')
		{
			operation = _products[_productIndex].action;
			data = 'OrderID=' + _guid;
			data += '&ProductID=' + _products[_productIndex].id;
			data += '&ProductNo=' + encodeURIComponent(_products[_productIndex].no);
			data += '&Name=' + encodeURIComponent(_products[_productIndex].name);
			data += '&Price=' + _products[_productIndex].price;
			data += '&AgentPrice=' + _products[_productIndex].agentPrice;
			data += '&InstanceID=' + _products[_productIndex].instanceId;
			data += '&SubInstanceID=' + _products[_productIndex].subInstanceId;
		}
		else if (_products[_productIndex].action == 'Delete')
		{
			operation = _products[_productIndex].action;
			params = 'OrderID=' + _guid + '&ProductID=' + _products[_productIndex].id;
			data = {};
		}
	
		_productIndex++;
		
		__base.post({object:'Order.Detail',operation:operation,data:data,statusMessage:_lang_modifying_product,onSuccess:setProduct,params:params});
	};
	
	this.checkUser = function()
	{
		var button = $(this);
		button[0].disabled = true;
		var input = button.prev();
		
		if (input.val() == '')
			return;

		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url: '../user/ajax_get.aspx?Name=' + encodeURIComponent(input.val()),
			type: 'GET',
			error: function(request)
			{
				Alert(_lang_operation_fail);
				button[0].disabled = false;
				SetStatusMessage();
			},
			success: function(data)
			{
				var user = eval($.trim(data));
				if (user.length == 0)
				{
					Alert(_lang_user_not_exist);
				}
				else
				{
					var agent = input.prev();
					agent.val(user[0].Name).attr('id', user[0].ID);

					var agentLevelID = agent.data('agentLevelId');
					if (user[0].AgentLevelID != g_empty && user[0].AgentLevelID != agentLevelID)
						agent.data('agentLevelId', user[0].AgentLevelID);
					else
						agent.removeData('agentLevelId');
					getProductAgentPrice(0, true);
					getComboAgentPrice();
				}
				button[0].disabled = false;
				SetStatusMessage();
			}
		});
	};
	
	var getProductAgentPrice = function(index, isAll)
	{
		var products = $('#ProductTable tbody tr');
		if (index >= products.length)
			return;
		
		var product = products.eq(index);
		var productID = product.attr('id');
		var levelID = $('[name=Agent]').data('agentLevelId');
		if (typeof(levelID) == 'undefined')
		{
			product.data('agentPrice', product.data('price'));
			product.children(':eq(3)').text(product.children(':eq(2)').text());
			if (isAll)
				index++;

			compute();
			return;
		}
		
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url: '../user/ajax_get_agent_price.aspx?ProductID=' + productID + "&LevelID=" + levelID,
			type: 'GET',
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success: function(data)
			{
				var price = product.data('price');
				var agentPrice = $.trim(data);
				if (agentPrice == '')
					agentPrice = price;
				else if (agentPrice.substr(agentPrice.length - 1) == '%')
					agentPrice = parseFloat(price) * parseFloat(agentPrice.substr(0, agentPrice.length - 1)) / 100;
				product.data('agentPrice', agentPrice);
				product.children(':eq(3)').text(agentPrice + product.children(':eq(2)').text().replace(/\d+/g, ''));

				if (isAll)
					index++;
				
				compute();

				SetStatusMessage();
			}
		});
	};
	
	var getComboAgentPrice = function()
	{
		var combo = $('[name=Combo]');
		if (combo.val() == '')
			return;

		var option = $(combo).children(':selected');
		var levelID = $('[name=Agent]').data('agentLevelId');
		if (typeof(levelID) == 'undefined')
		{
			option.data('agentPrice', option.data('price'));
			compute();
			return;
		}

		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url: '../user/ajax_get_agent_price.aspx?ComboID=' + combo.val() + '&LevelID=' + levelID,
			type : 'GET',
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				var price = option.data('price');
				var agentPrice = $.trim(data);
				if (agentPrice == '')
					agentPrice = price;
				else if (agentPrice.substr(agentPrice.length - 1) == '%')
					agentPrice = parseFloat(price) * parseFloat(agentPrice.substr(0, agentPrice.length - 1)) / 100;
				option.data('agentPrice', agentPrice);
				
				compute();

				SetStatusMessage();
			}
		});
	};
	
	function loadComboProducts()
	{
		var combo = $('[name=Combo]');
		if (combo.val() == '')
			return;

		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url: '../combo/ajax_products.aspx?ComboID=' + combo.val(),
			type: 'GET',
			error: function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success: function(data)
			{
				var products = eval(data);
				if (products.length == 0)
					return;

				var productTable = $('#ProductTable tbody');
				for (var i = 0; i < products.length; i++)
				{
					var html = '<tr id="' + products[i].id + '" data-price="0" data-agent-price="0" data-instance-id="' + products[i].instanceId + '">';
					html += '<td class="' + _lang + 'Font">' + products[i].name + '</td>';
					html += '<td>' + products[i].no + '</td>';
					html += '<td>0</td>';
					html += '<td>0</td>';
					html += '<td>' + products[i].amount + '</td>';
					if (products[i].instanceId == g_empty)
					{
						html += '<td></td><td></td>';
					}
					else
					{
						html += '<td>' + products[i].instanceName + '</td>';
						html += '<td>' + products[i].subInstanceId + '</td>';
					}
					html += '<td></td>';
					html += '</tr>';
					productTable.append(html);
				}
				
				compute();

				SetStatusMessage();
			}
		});
	}
	
	this.onUnitChange = function()
	{
		$.ajax(
		{
			url: '../combo/ajax_json_list.aspx?TimeUnit=' + this.value,
			type: 'GET',
			error: function(request)
			{
				Alert(_lang_operation_fail);
			},
			success: function(data)
			{
				var combo = $('[name=Combo]');
				combo[0].length = 1;

				var list = eval($.trim(data));
				for (var i = 0; i < list.length; i++)
				{
					combo.append('<option value="' + list[i].ID + '" data-no="' + list[i].No + '" data-price="' + list[i].Price + '">' + list[i].Name + '</option>');
				}
				
				if (typeof(_comboID) != 'undefined' && _comboID != g_empty)
					combo.val(_comboID);
			}
		});
	};
	
	this.onIsAgentPayClick = function()
	{
		if(this.id == "IsAgentPayYes" && $("[name=Agent]").val() == "")
		{
			Alert(_lang_agent_empty);
			return false;
		}
		
		compute();
	};
	
	this.onAmountKeyDown = function(e)
	{
		if (e.which >= 48 && e.which <= 57 || e.which >= 96 && e.which <= 105 || e.which == 37 || e.which == 39 || e.which == 8 || e.which == 46)//数字，数字键盘，左右键， Backspace，删除
			return true;
		else
			return false;
	};
	
	this.onAmountKeyUp = function()
	{
		compute();
	};
	
	this.onAmountBlur = function()
	{
		if (!this.value.match(/^\d+$/))
			this.value = 1;

		compute();
	};
	
	this.onPriceAdjustmentKeyDown = function(e)
	{
		if (e.which >= 48 && e.which <= 57 || e.which >= 96 && e.which <= 105 || e.which == 37 || e.which == 39 || e.which == 8 || e.which == 46 || e.which == 110 || e.which == 190 || e.which == 229 || e.which == 173/*减号*/)//数字，数字键盘，左右键， Backspace，删除，点,减号
			return true;
		else
			return false;
	};
	
	this.onPriceAdjustmentKeyUp = function(e)
	{
		if (e.which == 110 || e.which == 190)
			return true;

		compute();
	};
	
	this.onPriceAdjustmentBlur = function(e)
	{
		if (!this.value.match(/^-?\d+(\.\d{1,3})?$/))
			this.value = 0;

		compute();
	};
	
	this.onComboChange = function()
	{
		if (this.value == '')
		{
			//删除套餐产品
			$('#ProductTable tbody tr').remove();
			
			//启用产品选择按钮
			$('#SelectProduct')[0].disabled = false;
			
			//时间单位可以选择
			$('[name=TimeUnit]')[0].disabled = false;
			
			//重新计算价格
			compute();
		}
		else
		{
			//删除已选产品
			$('#ProductTable tbody tr').remove();
			
			//禁用产品选择按钮
			$('#SelectProduct')[0].disabled = true;
			
			//时间单位不能选择
			$('[name=TimeUnit]')[0].disabled = true;
			
			//获取当前套餐的代理价格
			getComboAgentPrice();
			
			//加载套餐所属产品
			loadComboProducts();
		}
		
		updateTitle();
	};
	
	var selectProductCallback = function()
	{
		var me = $(this);
		var row = me.closest('tr');
		var productTable = $('#ProductTable tbody');
		
		var rows = productTable.children('[id="' + row.attr('id') + '"]');
		if (rows.length > 0)
			return;

		var html = '<tr id="' + row.attr('id') + '" data-price="' + row.data('price') + '" data-instance-id="' + row.data('instanceId') + '">';
		html += '<td class="' + _lang + 'Font">' + row.children('td:eq(0)').text() + '</td>';
		html += '<td>' + row.children('td:eq(1)').text() + '</td>';
		html += '<td>' + row.children('td:eq(2)').text() + '</td>';
		html += '<td>0</td>';
		html += '<td>' + row.find('input').val() + '</td>';
		if (row.data('instanceId') == g_empty)
		{
			html += '<td></td><td></td>';
		}
		else
		{
			html += '<td>' + row.data('instanceName') + '</td>';
			html += '<td>' + row.data('subInstanceId') + '</td>';
		}
		html += '<td><button type="button">' + _lang_delete + '</button></td>';
		html += '</tr>';
		productTable.append(html);
		
		getProductAgentPrice(productTable.children().length - 1);	
		
		$('[name=TimeUnit]')[0].disabled = true;
		updateTitle();
		window.close();
	};

	this.selectProduct = function()
	{
		__base.showDialog({url:'../product/select.aspx?Lang=' + _lang + '&TimeUnit=' + $('[name=TimeUnit]').val(),callback:selectProductCallback});
	};
	
	this.deleteProduct = function()
	{
		$(this).closest("tr").remove();
		if ($("#ProductTable tbody tr").length > 0)
			$("[name=TimeUnit]")[0].disabled = true;
		else
			$("[name=TimeUnit]")[0].disabled = false;
		compute();
		updateTitle();
	};
	
	var compute = function()
	{
		var combo = $('[name=Combo] :selected');
		if (combo.val() == '')
		{
			var productRows = $('#ProductTable tbody tr');
			if (productRows.length == 0)
			{
				$('#Price').text('0');
				$('#AgentPrice').text('0');
				$('#Sum').text('0');
				return;
			}
		}
		
		var priceAdjustment = $('[name=PriceAdjustment]').val();
		if (priceAdjustment.match(/^-?\d+(\.\d{1,3})?$/))
			priceAdjustment = parseFloat(priceAdjustment);
		else
			priceAdjustment = 0;
		
		var timeAmount = $('[name=TimeAmount]').val();
		if (timeAmount.match(/^\d+$/))
			timeAmount = parseInt(timeAmount);
		else
			timeAmount = 1;
		
		var price = 0;
		var agentPrice = 0;
		if (combo.val() == '')
		{
			for (var i = 0; i < productRows.length; i++)
			{
				var row = productRows.eq(i);
				var amount = parseInt(row.children(':eq(4)').text());
				price += parseFloat(row.data('price')) * amount;
				agentPrice += parseFloat(row.data('agentPrice')) * amount;
			}
		}
		else
		{
			price = parseFloat(combo.data('price'));
			if (typeof(combo.data('agentPrice')) != 'undefined')
				agentPrice = parseFloat(combo.data('agentPrice'));
		}
		var sum = ($('#IsAgentPayYes')[0].checked ? agentPrice : price) * timeAmount + priceAdjustment;
		
		$('#Price').text(price.toFixed(2));
		$('#AgentPrice').text(agentPrice.toFixed(2));
		$('#Sum').text(sum.toFixed(2));
	};
	
	var updateTitle = function()
	{
		var title = "";
		var combo = $("[name=Combo] :selected");

		if (combo.val() == "")
		{
			var products = $("#ProductTable tbody td:first-child");
			for (var i = 0; i < products.length; i++)
			{
				if (title != "")
					title += " , ";
		
				title += products.eq(i).text();
			}
		}
		else
		{
			title = combo.text();
		}
	
		$("[name=Title]").val(title);
	};
	
	this.onAcceptClick = function()
	{
		var id = $(this).closest("tr")[0].id;
		Confirm(_lang_confirm_accept, function(returnValue){if (returnValue)accept(id);}, this);
	};
	
	var accept = function(id)
	{
		__base.post({object:'Order',operation:'Accept',params:'ID=' + id,hasList:true});
	};
	
	this.onPayClick = function()
	{
		var id = $(this).closest('tr')[0].id;
		__base.showDialog({url:'pay.aspx?Lang=' + _lang + '&ID=' + id,width:600,height:400,callback:pay});
	};
	
	var pay = function()
	{
		var win = window;
		with (pay.prototype.dialog)
		{
			if (!this.Amount.value.match(/^\d+(\.\d+)?$/))
			{
				Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
				return false;
			}
			
			if (parseFloat(this.Amount.value) <= 0)
			{
				Alert(_lang_amount_less_than_zero, function(){this.Amount.select();}, this);
				return false;
			}
			
			if (parseFloat(this.Amount.value) > parseFloat($.trim($('#Money', this).text())))
			{
				Alert(_lang_amount_greater_than_money, function(){this.Amount.select();}, this);
				return false;
			}
			
			if (parseFloat(this.Amount.value) > parseFloat($.trim($('#NeedPay', this).text().replace(',', ''))))
			{
				Alert(_lang_amount_greater_than_sum, function(){this.Amount.select();}, this);
				return false;
			}
			
			var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
			if (!dateTime.test(this.PayTime.value))
			{
				Alert(_lang_time_incorrect, function(){this.PayTime.select();}, this);
				return false;
			}
			
			var data = 'Amount=' + this.Amount.value;
			data += '&PayTime=' + this.PayTime.value;
			data += '&PayMemo=' + encodeURIComponent(this.PayMemo.value);
			
			(new Base()).post({object:'Order',operation:'Pay',data:data,params:'&ID=' + _id,onSuccess:function()
			{
				Alert(_lang_operation_success, function(){close();}, this);
				win.Search();
			}});
		}

		return false;
	};
	
	this.onRefundClick = function()
	{
		var id = $(this).closest('tr')[0].id;
		__base.showDialog({url:'refund.aspx?Lang=' + _lang + '&ID=' + id,width:600,height:300,callback:refund});
	};
	
	var refund = function()
	{
		var win = window;
		with (refund.prototype.dialog)
		{
			if (!this.Amount.value.match(/^\d+(\.\d+)?$/))
			{
				Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
				return false;
			}
			
			if (parseFloat(this.Amount.value) <= 0)
			{
				Alert(_lang_amount_less_than_zero, function(){this.Amount.select();}, this);
				return false;
			}
			
			if (parseFloat(this.Amount.value) > parseFloat($.trim($('#HasPayed', this).text().replace(',', ''))))
			{
				Alert(_lang_amount_greater_than_sum, function(){this.Amount.select();}, this);
				return false;
			}
			
			var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
			if (!dateTime.test(this.RefundTime.value))
			{
				Alert(_lang_time_incorrect, function(){this.RefundTime.select();}, this);
				return false;
			}
			
			var data = 'Amount=' + this.Amount.value;
			data += '&RefundTime=' + this.RefundTime.value;
			data += '&RefundMemo=' + encodeURIComponent(this.RefundMemo.value);
			
			(new Base()).post({object:'Order',operation:'Refund',data:data,params:'&ID=' + _id,onSuccess:function()
			{
				Alert(_lang_operation_success, function(){close();}, this);
				win.Search();
			}});
		}

		return false;
	};
	
	this.onDeliverClick = function()
	{
		var id = $(this).closest('tr')[0].id;
		__base.showDialog({url:'deliver.aspx?Lang=' + _lang + '&ID=' + id,width:600,height:300,callback:deliver});
	};
	
	var deliver = function()
	{
		var win = window;
		with (deliver.prototype.dialog)
		{
			var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
			if (!dateTime.test(this.DeliverTime.value))
			{
				Alert(_lang_time_incorrect, function(){this.DeliverTime.select();}, this);
				return false;
			}
			
			var data = 'DeliverTime=' + this.DeliverTime.value;
			data += '&DeliverMemo=' + encodeURIComponent(this.DeliverMemo.value);
			
			(new Base()).post({object:'Order',operation:'Deliver',data:data,params:'&ID=' + _id,onSuccess:function()
			{
				Alert(_lang_operation_success, function(){close();}, this);
				win.Search();
			}});
		}

		return false;
	};
	
	this.onReturnClick = function()
	{
		var id = $(this).closest('tr')[0].id;
		__base.showDialog({url:'return.aspx?Lang=' + _lang + '&ID=' + id,width:600,height:300,callback:returnOrder});
	};
	
	var returnOrder = function()
	{
		var win = window;
		with (returnOrder.prototype.dialog)
		{
			var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
			if (!dateTime.test(this.ReturnTime.value))
			{
				Alert(_lang_time_incorrect, function(){this.ReturnTime.select();}, this);
				return false;
			}
			
			var data = 'ReturnTime=' + this.ReturnTime.value;
			data += '&ReturnMemo=' + encodeURIComponent(this.ReturnMemo.value);
			
			(new Base()).post({object:'Order',operation:'Return',data:data,params:'&ID=' + _id,onSuccess:function()
			{
				Alert(_lang_operation_success, function(){close();}, this);
				win.Search();
			}});
		}

		return false;
	};
	
	this.onRenewClick = function()
	{
		alert('TODO');
	};
	
	this.update = function(operation, id)
	{
		if (this.tagName == "BUTTON")
			operation = this.id;

		__base.update(__object, operation, id);
	};	
}
//End : 订单
//-------------------------------------------------

//-------------------------------------------------
//Start : 地区
function Region()
{
	var __object = 'Region',
		__base = new Base();

	this.add = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'ParentID=' + this.ParentID.value;
		data += '&Name=' + encodeURIComponent(this.Name.value);
		
		__base.add({object:__object,data:data});

		return false;
	};
	
	this.modify = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
		
		var id;
		var tr = $(this).parent('tr');
		if (tr.length == 0)
		{
			id = _id;
			data += '&ParentID=' + this.ParentID.value;
		}
		else
		{
			id = tr.attr('ItemID');
		}
		
		__base.modify({object:__object,data:data,id:id});
		
		return false;
	};
	
	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id, false);
		ClientDelete(id);
	};
	
	this.move = function(from, to)
	{
		__base.move(__object, g_action, from, to);
	};
}
//End : 地区
//-------------------------------------------------

(function()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "config_basic")
	{
		var instanceConfig = new InstanceConfig();
		
		$("form:first").submit(instanceConfig.setBasicSettings);
	}
	else if (_page == "agent_level_add")
	{
		var agentLevel = new AgentLevel();
		
		$("form:first").submit(agentLevel.add);
	}
	else if (_page == "agent_level_edit")
	{
		var agentLevel = new AgentLevel();
		
		$("form:first").submit(agentLevel.modify);
	}
	else if (_page == 'agent_level_list')
	{
		var agentLevel = new AgentLevel();
		
		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)agentLevel.update('Delete', id);}, this);
			return false;
		});
	}
	else if (_page == "role_add")
	{
		var role = new Role();
		
		$("form:first").submit(role.add);
		$("[name=No]").blur(role.onNoChange);
	}
	else if (_page == "role_edit")
	{
		var role = new Role();
		
		$("form:first").submit(role.modify);
		$("[name=No]").blur(role.onNoChange).data("Old", $("[name=No]").val());
	}
	else if (_page == "role_list")
	{
		var role = new Role();
		
		$("table").delegate("td:last-child a", "click", function()
		{
			var id = $(this).closest("tr").attr("id");
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)role.update("Delete", id);}, this);
			return false;
		});
	}
	else if (_page == 'user_add')
	{
		var user = new User();
		
		//上传绑定
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Head', 'HeadTextbox', 'HeadBrowse');
		
		//事件绑定
		$('form:first').submit(user.add);
		$('[name=Name]').blur(user.onNameChange);
		$('[name=Mobile]').blur(user.onMobileChange);
		$('[name=Email]').blur(user.onEmailChange);
		$('[name=Birthday]').focus(function(){new DatePicker(this);});
		
		//现居住地和籍贯联动
		$('#Residence').on('change', 'select', function(){linkage(this, 'ajax_region.aspx');}); 
		$('#Origin').on('change', 'select', function(){linkage(this, 'ajax_region.aspx');}); 
	}
	else if (_page == 'user_edit')
	{
		var user = new User();
		
		//上传绑定
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Head', 'HeadTextbox', 'HeadBrowse');
		
		//事件绑定
		$('form:first').submit(user.modify);
		$('[name=Mobile]').blur(user.onMobileChange).data('old', $('[name=Mobile]').val());
		$('[name=Email]').blur(user.onEmailChange).data('old', $('[name=Email]').val());
		$('[name=Birthday]').focus(function(){new DatePicker(this);});
		
		//现居住地和籍贯联动
		$('#Residence').on('change', 'select', function(){linkage(this, 'ajax_region.aspx', user.residenceCallback);}); 
		$('#Origin').on('change', 'select', function(){linkage(this, 'ajax_region.aspx', user.originCallback);}); 

		//初始化
		user.onEditInit();
	}
	else if (_page == 'user_list')
	{
		var user = new User();
		
		MakeButton();

		$('#IsRecycled,#IsChecked,#IsLocked,#Sort').change(Search);
		$('body').on('click', '#Recycle,#Delete,#Recover,#Check,#Lock,#UnLock', user.update);
		$('#Keyword').keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$('#Search').click(function(){Search(1);});
		$('#SelectAll').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = true;});});
		$('#ReverseSelect').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "user_money")
	{
		var userMoney = new UserMoney();
		
		$("form:first").submit(userMoney.add);
		$("[name=Time]").focus(function(){new DatePicker(this);});
	}
	else if (_page == 'app_add')
	{
		var app = new App();
		
		//上传绑定
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		
		$('form:first').submit(app.add);
	}
	else if (_page == 'app_edit')
	{
		var app = new App();
		
		//上传绑定
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('Logo', 'LogoTextbox', 'LogoBrowse');
		
		$('form:first').submit(app.modify);
	}
	else if (_page == "app_list")
	{
		var app = new App();
		
		MakeButton();

		$("#IsRecycled,#IsChecked,#Sort").change(Search);
		$("body").delegate("#Recycle,#Delete,#Recover,#Check,#UnCheck", "click", app.update);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == 'product_add')
	{
		var product = new Product();
		
		//上传绑定
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');

		//事件绑定		
		$('form:first').submit(product.add);
		$('[name=No]').blur(product.onNoChange);
		$('[name=Kind]').change(product.onKindChange);
	}
	else if (_page == "product_edit")
	{
		var product = new Product();
		
		//上传绑定
		_uploader.Init({WebPath:_webPath});
		_uploader.Add('File', 'FileTextbox', 'FileBrowse');
		
		//事件绑定
		$('form:first').submit(product.modify);		
		$('[name=No]').blur(product.onNoChange);
		$('[name=Kind]').change(product.onKindChange);
		
		//#region 初始化
		
		//编号
		var no = $('[name=No]');
		var old = no.data('old');
		if (old.indexOf('PRODUCT_') != -1)
		{
			$('#prefix').text('PRODUCT_');
			no.val(old.substr(8));
		}
		else if (old.indexOf('INNER_APP_') != -1)
		{
			$('#prefix').text('INNER_APP_');
			no.val(old.substr(10));
		}
		else if (old.indexOf('OUTER_APP_') != -1)
		{
			$('#prefix').text('OUTER_APP_');
			no.val(old.substr(10));
		}
		else
		{
			no.val(old);
		}
		
		//性质
		$('[name=Kind]').val(_kind).change();
		
		//单位
		$('[name=TimeUnit]').val(_timeUnit);

		//代理价
		$('#AgentTable tbody tr').each(function()
		{
			var checkbox = $(this).find(':checkbox');
			for (var i = 0; i < _agentPrices.length; i++)
			{
				if (checkbox.val() == _agentPrices[i].LevelID)
				{
					checkbox[0].checked = true;
					var inputs = $(this).find(':text');
					inputs.eq(0).val(_agentPrices[i].Price);
					break;
				}
			}
		});
		//#endregion
	}
	else if (_page == "product_list")
	{
		var product = new Product();
		
		MakeButton();

		$("#IsRecycled,#Sort").change(Search);
		$("body").delegate("#Recycle,#Delete,#Recover", "click", product.update);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "product_select")
	{		
		window.dialogArguments.prototype.dialog = window;

		var list = $('#List');
		list.on('click', 'button', window.dialogArguments);
		list.on('keydown', ':text', function(e)
		{
			//if (e.which >= 48 && e.which <= 57 || e.which >= 96 && e.which <= 105 || e.which == 37 || e.which == 39 || e.which == 8 || e.which == 46)//数字，数字键盘，左右键， Backspace，删除
			if (e.which >= 48 && e.which <= 57 || e.which >= 96 && e.which <= 105 || e.which == 37 || e.which == 39)//数字，数字键盘，左右键
				return true;
			else
				return false;
		});
		
		$('#Sort').change(Search);
		$('#Keyword').keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$('#Search').click(function(){Search(1);});
	}
	else if (_page == 'combo_add')
	{
		var combo = new Combo();
		
		$('form:first').submit(combo.add);
		$('[name=No]').blur(combo.onNoChange);
		$('#SelectProduct').click(combo.selectProduct);
		$('#ProductTable').on('click', 'button', combo.deleteProduct);
	}
	else if (_page == 'combo_edit')
	{
		var combo = new Combo();
		
		$('[name=TimeUnit] option[value=' + _timeUnit + ']').prop('selected', true);

		$('#ProductTable tbody tr').each(function()
		{
			_products.push({id:this.id,amount:$('td:eq(3)', this).text()});
		});

		$('#AgentTable tbody tr').each(function()
		{
			var checkbox = $(this).find(':checkbox');
			for (var i = 0; i < _agentPrices.length; i++)
			{
				if (checkbox.val() == _agentPrices[i].LevelID)
				{
					checkbox[0].checked = true;
					var inputs = $(this).find(':text');
					inputs.eq(0).val(_agentPrices[i].Price);
					break;
				}
			}
		});
		
		$('form:first').submit(combo.modify);
		$('#SelectProduct').click(combo.selectProduct);
		$('#ProductTable').on('click', 'button', combo.deleteProduct);
		
		var no = $('[name=No]');
		var old = no.data('old');
		if (old.indexOf('COMBO_') != -1)
		{
			$('#prefix').text('COMBO_');
			no.val(old.substr(6));
		}
		else
		{
			no.val(old);
		}
		no.blur(combo.onNoChange);
	}
	else if (_page == 'combo_list')
	{
		var combo = new Combo();
		
		MakeButton();

		$('#IsRecycled,#Sort').change(Search);
		$('body').on('click', '#Recycle,#Delete,#Recover', combo.update);
		$('#Keyword').keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$('#Search').click(function(){Search(1);});
		$('#SelectAll').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = true;});});
		$('#ReverseSelect').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = !this.checked;});});
	}
	else if (_page == 'privilege_list')
	{
		var privilege = new Privilege();
		
		var list = $('#List');

		list.on('click', '[name=ObjectID]', function(){$(this.parentNode.parentNode.cells[1]).find(':checkbox').attr('checked', this.checked);});

	    $('#Save').click(privilege.save);
	    $('#InstanceID,#CurrentLang').change(Search);
	    $('#CheckAll').click(function(){$('[name=OperationID]').prop('checked', true);});
	}
	else if(_page == 'order_add')
	{
		var order = new Order();
		
		$('form:first').submit(order.add);
		$('#CheckUser,#CheckAgent').click(order.checkUser);
		$('[name=TimeUnit]').change(order.onUnitChange).change();
		$('[name=IsAgentPay]').click(order.onIsAgentPayClick);
		$('[name=TimeAmount]').keydown(order.onAmountKeyDown).keyup(order.onAmountKeyUp).blur(order.onAmountBlur);
		$('[name=PriceAdjustment]').keydown(order.onPriceAdjustmentKeyDown).keyup(order.onPriceAdjustmentKeyUp).blur(order.onPriceAdjustmentBlur);
		$('[name=Combo]').change(order.onComboChange);
		$('#SelectProduct').click(order.selectProduct);
		$('#ProductTable').on('click', 'button', order.deleteProduct);
	}
	else if(_page == 'order_edit')
	{
		var order = new Order();
		
		if (_comboID != g_empty)
			$('#SelectProduct').prop('disabled', true);
		
		$('#ProductTable tbody tr').each(function()
		{
			var row = $(this);
			_products.push({id:this.id,name:row.children(':eq(0)').text(),no:row.children(':eq(1)').text(),price:row.data('price'),agentPrice:row.data('agentPrice'),instanceId:row.children(':eq(5)').text(),subInstanceId:row.children(':eq(6)').text()});
		});
		
		$('form:first').submit(order.modify);
		$('#CheckUser').click(order.checkUser);
		$('#CheckAgent').click(order.checkUser).click();
		$('[name=TimeUnit]').change(order.onUnitChange).val(_timeUnit).change();
		$('[name=IsAgentPay]').click(order.onIsAgentPayClick);
		$('[name=TimeAmount]').keydown(order.onAmountKeyDown).keyup(order.onAmountKeyUp).blur(order.onAmountBlur);
		$('[name=PriceAdjustment]').keydown(order.onPriceAdjustmentKeyDown).keyup(order.onPriceAdjustmentKeyUp).blur(order.onPriceAdjustmentBlur);
		$('[name=Combo]').change(order.onComboChange);
		$('#SelectProduct').click(order.selectProduct);
		$('#ProductTable').on('click', 'button', order.deleteProduct);
	}
	else if(_page == 'order_list')
	{
		var order = new Order();
		
		$('#IsAccepted,#IsPayed,#IsDelivered,#IsFinished,#Sort').change(Search);
		$('body').on('click', '#Finish,#Archive,#Cancel,#Delete', order.update);
		$('#Keyword').keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$('#Search').click(function(){Search(1);});
		$('#SelectAll').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = true;});});
		$('#ReverseSelect').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = !this.checked;});});

		var list = $('#List');
		list.on('click', '[data-action=Accept]', order.onAcceptClick);
		list.on('click', '[data-action=Pay]', order.onPayClick);
		list.on('click', '[data-action=Refund]', order.onRefundClick);
		list.on('click', '[data-action=Deliver]', order.onDeliverClick);
		list.on('click', '[data-action=Return]', order.onReturnClick);
		list.on('click', '[data-action=Renew]', order.onRenewClick)
	}
	else if (_page == 'order_pay')
	{
		window.dialogArguments.prototype.dialog = window;
		$('form').submit(window.dialogArguments);
	}
	else if (_page == 'order_refund')
	{
		window.dialogArguments.prototype.dialog = window;
		$('form').submit(window.dialogArguments);
	}
	else if (_page == 'order_deliver')
	{
		window.dialogArguments.prototype.dialog = window;
		$('form').submit(window.dialogArguments);
	}
	else if (_page == 'order_return')
	{
		window.dialogArguments.prototype.dialog = window;
		$('form').submit(window.dialogArguments);
	}
	else if (_page == 'region_list')
	{
		var region = new Region();
		
		$('form').submit(region.modify);
		$('td:last-child a').click(function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)region.update('Delete', id);}, this);
			return false;
		});
		
		InitMove(null, 'Move', null, region.move);
	}
	else if (_page == 'region_add')
	{
		var region = new Region();
		
		$('form').submit(region.add);
	}
	else if (_page == 'region_edit')
	{
		var region = new Region();
		
		$('form').submit(region.modify);
	}
})();