﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:List ID="ComboAgentPrice" Object="Combo.AgentPrice" Condition="LevelID=Request.QueryString['LevelID']" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();

	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(Alias.Combo.Name + " LIKE '%" + keyword + "%'");
	}
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Combo.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Combo.InnerID + " ASC";
			break;
		default:
			sort = Alias.Combo.InnerID + " DESC";
			break;
	}
	
	return sort;
}
protected object GetAgentPrice(object comboID, object price)
{
	
	DataRow[] rows = ComboAgentPrice.Select(Alias.Combo.AgentPrice.ComboID + "='" + comboID + "'");
	if (rows.Length > 0)
	{
		string p = rows[0][Alias.Combo.AgentPrice.Price].ToString();
		if (p.Substring(p.Length - 1) == "%")
			return Convert.ToDecimal(price) * Convert.ToDecimal(p.Substring(0, p.Length - 1)) / 100;
		else
			return p;
	}
	else
	{
		return price;
	}
}
protected object GetAgentAward(object comboID)
{
	
	DataRow[] rows = ComboAgentPrice.Select(Alias.Combo.AgentPrice.ComboID + "='" + comboID + "'");
	if (rows.Length > 0)
		return rows[0][Alias.Combo.AgentPrice.Award];
	else
		return 0;
}
protected string GetUnit(object unit)
{
	string returnValue = "";
	if(unit.ToString() == "1")
	{
		returnValue = "分钟";
	}
	else if(unit.ToString() == "2")
	{
		returnValue = "小时";
	}
	else if(unit.ToString() == "3")
	{
		returnValue = "天";
	}
	else if(unit.ToString() == "4")
	{
		returnValue = "星期";
	}
	else if(unit.ToString() == "5")
	{
		returnValue = "月";
	}
	else if(unit.ToString() == "6")
	{
		returnValue = "季";
	}
	else if(unit.ToString() == "7")
	{
		returnValue = "半年";
	}
	else if(unit.ToString() == "8")
	{
		returnValue = "年";
	}
	return returnValue;
}

</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>名称</th>
			<th>货号</th>
			<th>价格</th>
			<th>代理价格</th>
			<th>上级代理奖励</th>
			<th>数量</th>
			<th>操作</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Combo" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()">
			<ali:Record>
				<tr id="<%=ID%>" Unit="<%=Unit%>" Price="<%=Price%>" AgentPrice="<%=GetAgentPrice(ID,Price)%>" Type="<%=Type%>">
					<td class="<%=ContentLang%>Font"><%=Name%></td>
					<td><%=Number%></td>
					<td class="Price"><%=Price%>元/<%=GetUnit(Unit)%></td>
					<td class="AgentPrice"><%=GetAgentPrice(ID,Price)%>元/<%=GetUnit(Unit)%></td>
					<td><%=GetAgentAward(ID)%>元</td>
					<td><input type="text" value="1" size="4" maxlength="4" /></td>
					<td><button>添加</button></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>