﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ali:List ID="ComboAgentPrice" Object="Combo.AgentPrice" Condition="LevelID=Request.QueryString['LevelID']" />
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>选择套餐</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();

	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(Alias.Combo.Name + " LIKE '%" + keyword + "%'");
	}
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Combo.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Combo.InnerID + " ASC";
			break;
		default:
			sort = Alias.Combo.InnerID + " DESC";
			break;
	}
	
	return sort;
}
protected object GetAgentPrice(object comboID, object price)
{
	
	DataRow[] rows = ComboAgentPrice.Select(Alias.Combo.AgentPrice.ComboID + "='" + comboID + "'");
	if (rows.Length > 0)
	{
		string p = rows[0][Alias.Combo.AgentPrice.Price].ToString();
		if (p.Substring(p.Length - 1) == "%")
			return Convert.ToDecimal(price) * Convert.ToDecimal(p.Substring(0, p.Length - 1)) / 100;
		else
			return p;
	}
	else
	{
		return price;
	}
}
protected object GetAgentAward(object comboID)
{
	
	DataRow[] rows = ComboAgentPrice.Select(Alias.Combo.AgentPrice.ComboID + "='" + comboID + "'");
	if (rows.Length > 0)
		return rows[0][Alias.Combo.AgentPrice.Award];
	else
		return 0;
}
protected string GetUnit(object unit)
{
	string returnValue = "";
	if(unit.ToString() == "1")
	{
		returnValue = "分钟";
	}
	else if(unit.ToString() == "2")
	{
		returnValue = "小时";
	}
	else if(unit.ToString() == "3")
	{
		returnValue = "天";
	}
	else if(unit.ToString() == "4")
	{
		returnValue = "星期";
	}
	else if(unit.ToString() == "5")
	{
		returnValue = "月";
	}
	else if(unit.ToString() == "6")
	{
		returnValue = "季";
	}
	else if(unit.ToString() == "7")
	{
		returnValue = "半年";
	}
	else if(unit.ToString() == "8")
	{
		returnValue = "年";
	}
	return returnValue;
}

</script>
<script type="text/javascript">
var _page = "combo_select";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_amount_incorrect = "数量不正确！";
var _lang_delete = "删除";
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">选择代理</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">编号↓</option>
			<option value="2">编号↑</option>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Name">名称</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>名称</th>
					<th>货号</th>
					<th>价格</th>
					<th>代理价格</th>
					<th>上级代理奖励</th>
					<th>数量</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Combo" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()">
					<ali:Record>
						<tr id="<%=ID%>" Unit="<%=Unit%>" Price="<%=Price%>" AgentPrice="<%=GetAgentPrice(ID,Price)%>" Type="<%=Type%>">
							<td class="<%=ContentLang%>Font"><%=Name%></td>
							<td><%=Number%></td>
							<td class="Price"><%=Price%>元/<%=GetUnit(Unit)%></td>
							<td class="AgentPrice"><%=GetAgentPrice(ID,Price)%>元/<%=GetUnit(Unit)%></td>
							<td><%=GetAgentAward(ID)%>元</td>
							<td><input type="text" value="1" size="4" maxlength="4" /></td>
							<td><button>添加</button></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>