﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否受理
	string isAccepted = Request.QueryString["IsAccepted"];
	if (!String.IsNullOrEmpty(isAccepted))
		condition.Append(and + Alias.Order.IsAccepted + "=" + isAccepted);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否付款
	string isPayed = Request.QueryString["IsPayed"];
	if (!String.IsNullOrEmpty(isPayed))
		condition.Append(and + Alias.Order.IsPayed + "=" + isPayed);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否发货
	string isDelivered = Request.QueryString["IsDelivered"];
	if (!String.IsNullOrEmpty(isDelivered))
		condition.Append(and + Alias.Order.IsDelivered + "=" + isDelivered);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否完成
	string isFinished = Request.QueryString["IsFinished"];
	if (!String.IsNullOrEmpty(isFinished))
		condition.Append(and + Alias.Order.IsFinished + "=" + isFinished);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "No")
			condition.Append(and + Alias.Order.No + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "UserName")
			condition.Append(and + Alias.Order.UserName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "AgentName")
			condition.Append(and + Alias.Order.AgentName + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Order.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.Order.CreateTime + " ASC";
			break;
		case "3":
			sort = Alias.Order.Sum + " DESC";
			break;
		case "4":
			sort = Alias.Order.Sum + " ASC";
			break;
		default:
			sort = Alias.Order.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>订单编号</th>
			<th>订单标题</th>
			<th>下单日期</th>
			<th>订单总价</th>
			<th>用户名称</th>
			<th>代理名称</th>
			<th>订单状态</th>
			<th>订单操作</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Order" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ali:Record>
				<tr id="<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td>
						<%If Convert.ToBoolean(IsAccepted)%>
							<a href="../order/view.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=No%></a>
						<%Else%>
							<a href="../order/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=No%></a>
						<%EndIf%>
					</td>
					<td class="<%=ContentLang%>Font">
						<%If Convert.ToBoolean(IsAccepted)%>
							<a href="../order/view.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=Title%></a>
						<%Else%>
							<a href="../order/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=Title%></a>
						<%EndIf%>
					</td>
					<td><%=CreateTime%></td>
					<td><%=Sum%></td>
					<td class="<%=ContentLang%>Font"><%=UserName%></td>
					<td class="<%=ContentLang%>Font"><%=AgentName%></td>
					<td>
						<%If !Convert.ToBoolean(IsAccepted)%>
							未受理
						<%ElseIf Int32.Equals(IsFinished, 1)%>
							<%If Convert.IsDBNull(ExpiredTime)%>
								交易完成
							<%Else%>
								<%If DateTime.Now > Convert.ToDateTime(ExpiredTime)%>
									<span class="red">已过期 <%=DateTime.Now.Subtract(Convert.ToDateTime(ExpiredTime)).TotalDays.ToString("0")%> 天</span>
								<%Else%>
									<span class="green"><%=Convert.ToDateTime(ExpiredTime).Subtract(DateTime.Now).TotalDays.ToString("0")%> 天后过期</span>
								<%EndIf%>
								<input type="button" value="续费" data-action="Renew" />
							<%EndIf%>
						<%ElseIf Int32.Equals(IsFinished, 2)%>
							已作废
						<%ElseIf Int32.Equals(IsFinished, 3)%>
							已归档
						<%Else%>
							<%If Int32.Equals(IsPayed, 0)%>
								未付款
							<%ElseIf Int32.Equals(IsPayed, 1)%>
								部分付款
							<%ElseIf Int32.Equals(IsPayed, 2)%>
								已付款
							<%ElseIf Int32.Equals(IsPayed, 3)%>
								部分退款
							<%ElseIf Int32.Equals(IsPayed, 4)%>
								已退款
							<%EndIf%>
							，
							<%If Int32.Equals(IsDelivered, 0)%>
								未发货
							<%ElseIf Int32.Equals(IsDelivered, 1)%>
								部分发货
							<%ElseIf Int32.Equals(IsDelivered, 2)%>
								已发货
							<%ElseIf Int32.Equals(IsDelivered, 3)%>
								已收货
							<%ElseIf Int32.Equals(IsDelivered, 4)%>
								部分退货
							<%ElseIf Int32.Equals(IsDelivered, 5)%>
								已退货
							<%EndIf%>
						<%EndIf%>
					</td>
					<td>
						<%If !Convert.ToBoolean(IsAccepted)%>
							<input type="button" value="受理" data-action="Accept" />
						<%ElseIf Int32.Equals(IsFinished, 0) || Int32.Equals(IsFinished, 1)%>
							<%If Int32.Equals(IsPayed, 0)%>
								<input type="button" value="付款" data-action="Pay" />
							<%ElseIf Int32.Equals(IsPayed, 1)%>
								<input type="button" value="付款" data-action="Pay" />
								<input type="button" value="退款" data-action="Refund" />
							<%ElseIf Int32.Equals(IsPayed, 2)%>
								<input type="button" value="退款" data-action="Refund" />
							<%ElseIf Int32.Equals(IsPayed, 3)%>
								<input type="button" value="付款" data-action="Pay" />
								<input type="button" value="退款" data-action="Refund" />
							<%EndIf%>
							
							<%If Int32.Equals(IsDelivered, 0) || Int32.Equals(IsDelivered, 1)%>
								<input type="button" value="发货" data-action="Deliver" />
							<%ElseIf Int32.Equals(IsDelivered, 2) || Int32.Equals(IsDelivered, 3)%>
								<input type="button" value="退货" data-action="Return" />
							<%ElseIf Int32.Equals(IsDelivered, 4)%>
								<input type="button" value="发货" data-action="Deliver" />
								<input type="button" value="退货" data-action="Return" />
							<%EndIf%>
						<%EndIf%>
					</td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>
