﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ali:Get ID="Order" Object="Order" InnerID="Request.QueryString['ID']" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>查看</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
TD TABLE{background:#FFF}
TD TABLE TH{width:100px}
#ProductTable THEAD TH,#ProductTable TBODY TD{width:auto;text-align:center}
</style>
<script language="c#" runat="server">
protected string GetUnit(object unit)
{
	string returnValue = "";
	if(unit.ToString() == "1")
	{
		returnValue = "分钟";
	}
	else if(unit.ToString() == "2")
	{
		returnValue = "小时";
	}
	else if(unit.ToString() == "3")
	{
		returnValue = "天";
	}
	else if(unit.ToString() == "4")
	{
		returnValue = "星期";
	}
	else if(unit.ToString() == "5")
	{
		returnValue = "月";
	}
	else if(unit.ToString() == "6")
	{
		returnValue = "季";
	}
	else if(unit.ToString() == "7")
	{
		returnValue = "半年";
	}
	else if(unit.ToString() == "8")
	{
		returnValue = "年";
	}
	return returnValue;
}

protected string GetInstanceName(object id)
{
	if (Guid.Equals(id, Guid.Empty))
		return "";

	return Manager.Instances.Select(AliCMS.SystemModule.Alias.Instance.ID + "='" + id + "'")[0][AliCMS.SystemModule.Alias.Instance.Name + PageLang].ToString();
}
</script>
<script type="text/javascript">
var _page = "order_view";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title"><a href="../order/list.aspx?Lang=<%=ContentLang%>">订单列表</a> → <span class="<%=ContentLang%>Font"><%=Order[Title]%></span></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">查看</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form>
		<table border="0" cellpadding="4" cellspacing="1">
			<tfoot>
				<tr><td colspan="2"><input type="submit" value="编辑" /></td></tr>
			</tfoot>
			<tbody>
				<tr>
					<th width="120">标题：</th>
					<td><%=Order[Title]%></td>
				</tr>
				<tr>
					<th>订单号：</th>
					<td><%=Order[No]%></td>
				</tr>
				<tr>
					<th>用户：</th>
					<td><%=Order[UserName]%></td>
				</tr>
				<tr>
					<th>代理：</th>
					<td><%=Order[AgentName]%></td>
				</tr>
				<tr>
					<th>是否代理支付：</th>
					<td>
						<%If Convert.ToBoolean(Order[IsAgentPay])%>
							是
						<%Else%>
							否
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>时间单位：</th>
					<td><%=GetUnit(Order[TimeUnit])%></td>
				</tr>
				<tr>
					<th>时间数量：</th>
					<td><%=Order[TimeAmount]%></td>
				</tr>
				<tr>
					<th>折扣或涨价：</th>
					<td><%=Convert.ToDecimal(Order[PriceAdjustment]).ToString("N")%></td>
				</tr>
				<tr>
					<th>管理员备注：</th>
					<td><%=Order[AdminMemo]%></td>
				</tr>
				<tr>
					<th>用户备注：</th>
					<td><%=Order[UserMemo]%></td>
				</tr>
				<tr>
					<th>套餐：</th>
					<td><%=Order[ComboNo]%></td>
				</tr>
				<tr>
					<td colspan="2">
						<table id="ProductTable" border="0" cellpadding="4" cellspacing="1">
							<thead>
								<tr>
									<th>产品名称</th>

									<th>产品编号</th>
									<th>市场价格</th>
									<th>代理价格</th>
									<th>数量</th>
									<th>内部应用</th>
									<th>子应用ID</th>
								</tr>
							</thead>
							<tbody>
								<ali:List Object="Order.Detail" Condition="OrderID=Order[ID]">
									<ali:Record>
										<tr id="<%=ProductID%>">
											<td class="<%=ContentLang%>Font"><%=Name%></td>
											<td><%=ProductNo%></td>
											<td><%=Price%></td>
											<td><%=AgentPrice%></td>
											<td><%=Amount%></td>
											<td><%=GetInstanceName(InstanceID)%></td>
											<td>
												<%If !Guid.Equals(InstanceID, Guid.Empty)%>
													<%=SubInstanceID%>
												<%EndIf%>
											</td>
										</tr>
									</ali:Record>
								</ali:List>
							</tbody>
						</table>
					</td>
				</tr>
				<tr>
					<th>产品总价：</th>
					<td><%=Order[Price]%></td>
				</tr>
				<tr>
					<th>代理总价：</th>
					<td><%=Order[AgentPrice]%></td>
				</tr>
				<tr>
					<th>订单总价：</th>
					<td><%=Order[Sum]%></td>
				</tr>
				<tr>
					<th>是否付款：</th>
					<td>
						<%If Int32.Equals(Order[IsPayed], 0)%>
							未付款
						<%ElseIf Int32.Equals(Order[IsPayed], 1)%>
							部分付款
						<%ElseIf Int32.Equals(Order[IsPayed], 2)%>
							已付款
						<%ElseIf Int32.Equals(Order[IsPayed], 3)%>
							部分退款
						<%ElseIf Int32.Equals(Order[IsPayed], 4)%>
							已退款
						<%EndIf%>
						
						<br /><br />付款时间：<%=Order[PayTime]%><br />付款备注：<%=Order[PayMemo]%>
						<br /><br />退款时间：<%=Order[RefundTime]%><br />退款备注：<%=Order[RefundMemo]%>
					</td>
				</tr>
				<tr>
					<th>是否发货：</th>
					<td>
						<%If Int32.Equals(Order[IsDelivered], 0)%>
							未发货
						<%ElseIf Int32.Equals(Order[IsDelivered], 1)%>
							部分发货
						<%ElseIf Int32.Equals(Order[IsDelivered], 2)%>
							已发货
						<%ElseIf Int32.Equals(Order[IsDelivered], 3)%>
							已收货
						<%ElseIf Int32.Equals(Order[IsDelivered], 4)%>
							部分退货
						<%ElseIf Int32.Equals(Order[IsDelivered], 5)%>
							已退货
						<%EndIf%>
						
						<br /><br />发货时间：<%=Order[DeliverTime]%><br />发货备注：<%=Order[DeliverMemo]%>
						<br /><br />退货时间：<%=Order[ReturnTime]%><br />退货备注：<%=Order[ReturnMemo]%>
					</td>
				</tr>
				<tr>
					<th>是否完成：</th>
					<td>
						<%If Int32.Equals(Order[IsFinished], 0)%>
							未完成
						<%ElseIf Int32.Equals(Order[IsFinished], 1)%>
							<%If Convert.IsDBNull(Order[ExpiredTime])%>
								交易完成
							<%Else%>
								开始时间：<%=Order[StartTime]%><br />
								过期时间：<%=Order[ExpiredTime]%>
								（
									<%If DateTime.Now > Convert.ToDateTime(Order[ExpiredTime])%>
										<span class="red">已过期 <%=DateTime.Now.Subtract(Convert.ToDateTime(Order[ExpiredTime])).TotalDays.ToString("0")%> 天</span>
									<%Else%>
										<span class="green"><%=Convert.ToDateTime(Order[ExpiredTime]).Subtract(DateTime.Now).TotalDays.ToString("0")%> 天后过期</span>
									<%EndIf%>
								）
							<%EndIf%>
						<%ElseIf Int32.Equals(Order[IsFinished], 2)%>
							已作废
						<%ElseIf Int32.Equals(Order[IsFinished], 3)%>
							已归档
						<%EndIf%>
					</td>
				</tr>
			</tbody>
		</table>
	</form>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>