﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:Get ID="Role" Object="Role" Guid="Request.QueryString['ID']" />
<ali:Get ID="Product" Object="Product" Guid="Request.QueryString['ID']" />
<ali:Get ID="Combo" Object="Combo" Guid="Request.QueryString['ID']" />
<script language="c#" runat="server">
protected override void OnLoad(EventArgs e)
{
	DataRow instance = Manager.Instances.Select(AliCMS.SystemModule.Alias.Instance.ID + "='" + CurrentInstanceID + "'")[0];

	#region ObjectTable
	using (AliCMS.SystemModule.Module.IObject bll = (AliCMS.SystemModule.Module.IObject)Manager.CreateObject("Module.Object", 0, ContentLang, false))
	{
		Dictionary<string, object> condition = new Dictionary<string, object>();
		condition[AliCMS.SystemModule.Alias.Module.Object.Namespace] = instance[AliCMS.SystemModule.Alias.Module.Namespace];
		_objectTable = bll.List(-1, -1, condition, null);
	}
	_objectTable.Columns.Add("FullName", typeof(string));

	foreach (DataRow row in _objectTable.Rows)
	{
		string name = row[AliCMS.SystemModule.Alias.Module.Object.Name].ToString();
		DataRow parent = row;
		while (!Guid.Equals(parent[AliCMS.SystemModule.Alias.Module.Object.ParentID], Guid.Empty))
		{
			parent = _objectTable.Select(AliCMS.SystemModule.Alias.Module.Object.ID + "='" + parent[AliCMS.SystemModule.Alias.Module.Object.ParentID] + "'")[0];
			name = parent[AliCMS.SystemModule.Alias.Module.Object.Name] + "." + name;
		}
		row["FullName"] = name;
	}
	#endregion

	#region PrivilegeTable
	using (IDbObject bll = (IDbObject)Manager.CreateObject("Privilege", InstanceID, ContentLang))
	{
		StringBuilder condition = new StringBuilder();
		condition.Append(Alias.Privilege.InstanceID + "=" + CurrentInstanceID);
		condition.Append(" AND " + Alias.Privilege.Lang + "='" + CurrentLang + "'");
		if (Request.QueryString["Type"] == "Role")
			condition.Append(" AND " + Alias.Privilege.RoleID + "=" + Role[Alias.Role.ID]);

		_privilegeTable = bll.List(-1, -1, condition.ToString(), null);
	}
	#endregion
}

protected bool HasPrivilege(DataRow record)
{
	DataRow[] rows = _privilegeTable.Select(Alias.Privilege.ObjectID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ObjectID] + "' AND " + Alias.Privilege.OperationID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ID] + "'");
	if (rows.Length == 0)
		return false;
	else
		return true;
}
protected string GetPrivilegeID(DataRow record)
{
	DataRow[] rows = _privilegeTable.Select(Alias.Privilege.ObjectID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ObjectID] + "' AND " + Alias.Privilege.OperationID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ID] + "'");
	if (rows.Length == 0)
		return String.Empty;
	else
		return rows[0][Alias.Privilege.InnerID].ToString();
}

#region Properties
protected DataTable ObjectTable
{
	get { return _objectTable; }
}
protected Guid CurrentInstanceID
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["InstanceID"]))
			return (Guid)Instance[AliCMS.SystemModule.Alias.Instance.ID];
		else
			return new Guid(Request.QueryString["InstanceID"]);
	}
}
protected string CurrentLang
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["CurrentLang"]))
			return ContentLang;
		else
			return Request.QueryString["CurrentLang"];
	}
}
#endregion

#region Fields
private DataTable _objectTable;
private DataTable _privilegeTable;
#endregion

</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>对象</th>
			<th>特权</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="ObjectTableID" Mark="System" Object="Module.Object" Source="ObjectTable">
			<ali:Record>
				<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>">
					<td style="white-space:nowrap">
						<input type="checkbox" name="ObjectID" id="Ob<%=InnerID%>" /><label for="Ob<%=InnerID%>" class="<%=ContentLang%>Font"><%=Label%></label>
					</td>
					<td>
						<ali:List Mark="System" Object="Module.Object.Operation" Condition="ObjectID=ID">
							<ali:Record>
								<%If HasPrivilege(Record)%>
									<input type="checkbox" name="OperationID" id="Op<%=ObjectTableID[InnerID]%>_<%=Index%>" value="<%=ID%>" checked="checked" PrivilegeID="<%=GetPrivilegeID(Record)%>" ObjectID="<%=ObjectTableID[ID]%>" ObjectName="<%=ObjectTableID["FullName"]%>" OperationName="<%=Name%>" />
								<%Else%>
									<input type="checkbox" name="OperationID" id="Op<%=ObjectTableID[InnerID]%>_<%=Index%>" value="<%=ID%>" PrivilegeID="" ObjectID="<%=ObjectTableID[ID]%>" ObjectName="<%=ObjectTableID["FullName"]%>" OperationName="<%=Name%>" />
								<%EndIf%>
								<label for="Op<%=ObjectTableID[InnerID]%>_<%=Index%>" class="<%=ContentLang%>Font"><%=Label%></label>
							</ali:Record>
						</ali:List>
					</td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
