﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ali:Get ID="Role" Object="Role" InnerID="Request.QueryString['ID']" />
<ali:Get ID="Product" Object="Product" InnerID="Request.QueryString['ID']" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>特权</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="false" Eot="true" runat="server" />
<script language="c#" runat="server">
protected override void OnLoad(EventArgs e)
{
	DataRow instance = Manager.Instances.Select(AliCMS.SystemModule.Alias.Instance.ID + "='" + CurrentInstanceID + "'")[0];

	#region ObjectTable
	using (AliCMS.SystemModule.Module.IObject bll = (AliCMS.SystemModule.Module.IObject)Manager.CreateObject("Module.Object", 0, ContentLang, false))
	{
		Dictionary<string, object> condition = new Dictionary<string, object>();
		condition[AliCMS.SystemModule.Alias.Module.Object.Namespace] = instance[AliCMS.SystemModule.Alias.Module.Namespace];
		_objectTable = bll.List(-1, -1, condition, null);
	}
	_objectTable.Columns.Add("FullName", typeof(string));

	foreach (DataRow row in _objectTable.Rows)
	{
		string name = row[AliCMS.SystemModule.Alias.Module.Object.Name].ToString();
		DataRow parent = row;
		while (!Guid.Equals(parent[AliCMS.SystemModule.Alias.Module.Object.ParentID], Guid.Empty))
		{
			parent = _objectTable.Select(AliCMS.SystemModule.Alias.Module.Object.ID + "='" + parent[AliCMS.SystemModule.Alias.Module.Object.ParentID] + "'")[0];
			name = parent[AliCMS.SystemModule.Alias.Module.Object.Name] + "." + name;
		}
		row["FullName"] = name;
	}
	#endregion

	#region PrivilegeTable
	using (IDbObject bll = (IDbObject)Manager.CreateObject("Privilege", InstanceID, ContentLang))
	{
		StringBuilder condition = new StringBuilder();
		condition.Append(Alias.Privilege.InstanceID + "=" + CurrentInstanceID);
		condition.Append(" AND " + Alias.Privilege.Lang + "='" + CurrentLang + "'");
		if (Request.QueryString["Type"] == "Role")
			condition.Append(" AND " + Alias.Privilege.RoleID + "=" + Role[Alias.Role.ID]);
		else if (Request.QueryString["Type"] == "Product")
			condition.Append(" AND " + Alias.Privilege.ProductID + "=" + Product[Alias.Product.ID]);

		_privilegeTable = bll.List(-1, -1, condition.ToString(), null);
	}
	#endregion
}

protected bool HasPrivilege(DataRow record)
{
	DataRow[] rows = _privilegeTable.Select(Alias.Privilege.ObjectID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ObjectID] + "' AND " + Alias.Privilege.OperationID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ID] + "'");
	if (rows.Length == 0)
		return false;
	else
		return true;
}
protected string GetPrivilegeID(DataRow record)
{
	DataRow[] rows = _privilegeTable.Select(Alias.Privilege.ObjectID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ObjectID] + "' AND " + Alias.Privilege.OperationID + "='" + record[AliCMS.SystemModule.Alias.Module.Object.Operation.ID] + "'");
	if (rows.Length == 0)
		return String.Empty;
	else
		return rows[0][Alias.Privilege.InnerID].ToString();
}

#region Properties
protected DataTable ObjectTable
{
	get { return _objectTable; }
}
protected Guid CurrentInstanceID
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["InstanceID"]))
			return (Guid)Instance[AliCMS.SystemModule.Alias.Instance.ID];
		else
			return new Guid(Request.QueryString["InstanceID"]);
	}
}
protected string CurrentLang
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["CurrentLang"]))
			return ContentLang;
		else
			return Request.QueryString["CurrentLang"];
	}
}
#endregion

#region Fields
private DataTable _objectTable;
private DataTable _privilegeTable;
#endregion

</script>
<script type="text/javascript">
var _page = "privilege_list";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _type = "<%=Request.QueryString["Type"]%>";
<%If Request.QueryString["Type"] == "Role"%>
	var _no = '<%=Role[No]%>';
	var _guid = "<%=Role[ID]%>";
<%ElseIf Request.QueryString["Type"] == "Product"%>
	var _no = '<%=Product[No]%>';
	var _guid = "<%=Product[ID]%>";
<%EndIf%>
var _addIndex = 0;
var _addList = new Array();
var _deleteIndex = 0;
var _deleteList = new Array();
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_no_changes = "没有任何变化！无需保存！";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<%If Request.QueryString["Type"] == "Role"%>
		<div class="Title"><a href="../role/list.aspx?Lang=<%=ContentLang%>">角色列表</a> → <span class="<%=ContentLang%>Font"><%=Role[Name]%></span></div>
	<%ElseIf Request.QueryString["Type"] == "Product"%>
		<div class="Title"><a href="../product/list.aspx?Lang=<%=ContentLang%>">产品列表</a> → <span class="<%=ContentLang%>Font"><%=Product[Name]%></span></div>
	<%EndIf%>
	<div class="LanguageFilter"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<%If Request.QueryString["Type"] == "Role"%>
			<li class="Middle"><a href="../role/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">编辑</a></li>
		<%ElseIf Request.QueryString["Type"] == "Product"%>
			<li class="Middle"><a href="../product/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">编辑</a></li>
		<%EndIf%>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">特权</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		实例：
			<select id="InstanceID" class="Text <%=ContentLang%>Font">
				<ali:List Mark="System" Object="Instance" Condition="ID<>SystemChannel[AliCMS.SystemModule.Alias.Instance.ID]">
					<ali:Record>
						<%If Guid.Equals(ID, CurrentInstanceID)%>
							<option value="<%=ID%>" ModuleID="<%=ModuleID%>" selected="selected"><%=Name%></option>
						<%Else%>
							<option value="<%=ID%>" ModuleID="<%=ModuleID%>"><%=Name%></option>
						<%EndIf%>
					</ali:Record>
				</ali:List>
			</select>
		语言：
			<select id="CurrentLang" class="Text <%=ContentLang%>Font">
				<ali:List Mark="System" Object="Language">
					<ali:Record>
						<%If Guid.Equals(ID, CurrentLang)%>
							<option value="<%=Ab%>" selected="selected"><%=Name%></option>
						<%Else%>
							<option value="<%=Ab%>"><%=Name%></option>
						<%EndIf%>
					</ali:Record>
				</ali:List>
			</select>
			<input type="button" id="CheckAll" value="全选" />
			<input id="Save" type="button" value="保存" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>对象</th>
					<th>特权</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="ObjectTableID" Mark="System" Object="Module.Object" Source="ObjectTable">
					<ali:Record>
						<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>">
							<td style="white-space:nowrap">
								<input type="checkbox" name="ObjectID" id="Ob<%=InnerID%>" /><label for="Ob<%=InnerID%>" class="<%=ContentLang%>Font"><%=Label%></label>
							</td>
							<td>
								<ali:List Mark="System" Object="Module.Object.Operation" Condition="ObjectID=ID">
									<ali:Record>
										<%If HasPrivilege(Record)%>
											<input type="checkbox" name="OperationID" id="Op<%=ObjectTableID[InnerID]%>_<%=Index%>" value="<%=ID%>" checked="checked" PrivilegeID="<%=GetPrivilegeID(Record)%>" ObjectID="<%=ObjectTableID[ID]%>" ObjectName="<%=ObjectTableID["FullName"]%>" OperationName="<%=Name%>" />
										<%Else%>
											<input type="checkbox" name="OperationID" id="Op<%=ObjectTableID[InnerID]%>_<%=Index%>" value="<%=ID%>" PrivilegeID="" ObjectID="<%=ObjectTableID[ID]%>" ObjectName="<%=ObjectTableID["FullName"]%>" OperationName="<%=Name%>" />
										<%EndIf%>
										<label for="Op<%=ObjectTableID[InnerID]%>_<%=Index%>" class="<%=ContentLang%>Font"><%=Label%></label>
									</ali:Record>
								</ali:List>
							</td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
	</div>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>