﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Product.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Product.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Product.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Product.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Product.InnerID + " ASC";
			break;
		default:
			sort = Alias.Product.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>名称</th>
			<th width="100">编号</th>
			<th width="70">价格</th>
			<th width="70">时间单位</th>
			<th width="90">内部应用？</th>
			<th width="90">外部应用？</th>
			<th width="70">特权</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Product"  Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ali:Record>
				<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td class="<%=ContentLang%>Font"><a href="../product/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=Name%></a></td>
					<td><%=No%></td>
					<td><%=Convert.ToDecimal(Price).ToString("N")%></td>
					<td>
						<%If Convert.ToString(TimeUnit) == "Minute"%>
							分钟
						<%ElseIf Convert.ToString(TimeUnit) == "Hour"%>
							小时
						<%ElseIf Convert.ToString(TimeUnit) == "Day"%>
							天
						<%ElseIf Convert.ToString(TimeUnit) == "Week"%>
							星期
						<%ElseIf Convert.ToString(TimeUnit) == "Month"%>
							月
						<%ElseIf Convert.ToString(TimeUnit) == "Season"%>
							季
						<%ElseIf Convert.ToString(TimeUnit) == "HafeYear"%>
							半年
						<%ElseIf Convert.ToString(TimeUnit) == "Year"%>
							年
						<%Else%>
							永久
						<%EndIf%>
					</td>
					<td>
						<%If Guid.Equals(InstanceID, Guid.Empty)%>
							非内部应用
						<%Else%>
							内部应用
						<%EndIf%>
					</td>
					<td>
						<%If Guid.Equals(AppID, Guid.Empty)%>
							非外部应用
						<%Else%>
							外部应用
						<%EndIf%>
					</td>
					<td><a href="../privilege/list.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>&Type=Product">特权</a></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>
