﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:List ID="ProductAgentPrice" Object="Product.AgentPrice" Condition="LevelID=Request.QueryString['LevelID']" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Product.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Product.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 单位
	if (!String.IsNullOrEmpty(Request.QueryString["TimeUnit"]))
		condition.Append(and + Alias.Product.TimeUnit + "=" + Request.QueryString["TimeUnit"]);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Product.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Product.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Product.InnerID + " ASC";
			break;
		default:
			sort = Alias.Product.InnerID + " DESC";
			break;
	}
	
	return sort;
}
protected string GetUnit(object unit)
{
	string returnValue = "";
	if(unit.ToString() == "1")
	{
		returnValue = "分钟";
	}
	else if(unit.ToString() == "2")
	{
		returnValue = "小时";
	}
	else if(unit.ToString() == "3")
	{
		returnValue = "天";
	}
	else if(unit.ToString() == "4")
	{
		returnValue = "星期";
	}
	else if(unit.ToString() == "5")
	{
		returnValue = "月";
	}
	else if(unit.ToString() == "6")
	{
		returnValue = "季";
	}
	else if(unit.ToString() == "7")
	{
		returnValue = "半年";
	}
	else if(unit.ToString() == "8")
	{
		returnValue = "年";
	}
	return returnValue;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>名称</th>
			<th>编号</th>
			<th>价格</th>
			<th>数量</th>
			<th>操作</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Product" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()">
			<ali:Record>
				<tr id="<%=ID%>" data-price="<%=Price%>" data-instance-id="<%=InstanceID%>" data-sub-instance-id="<%=Guid.NewGuid()%>">
					<td class="<%=ContentLang%>Font"><%=Name%></td>
					<td><%=No%></td>
					<td><%=Convert.ToDecimal(Price).ToString("N")%>元/<%=GetUnit(TimeUnit)%></td>
					<td><input type="text" value="1" size="4" /></td>
					<td><button>添加</button></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>
<ali:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>
