﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ali:Get ID="Product" Object="Product" InnerID="Request.QueryString['ID']" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>编辑产品</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
#MemberTable,#AgentTable{width:600px;background:#FFF}
#MemberTable THEAD TH,#MemberTable TD,#AgentTable THEAD TH,#AgentTable TD{text-align:center}
</style>
<script type="text/javascript">
var _page = "product_edit";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _id = "<%=Request.QueryString["ID"]%>";
var _guid = "<%=Product[ID]%>";
var _kind = '<%=Product[Kind]%>';
var _timeUnit = "<%=Product[TimeUnit]%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_no_empty = "编号不能空！";
var _lang_no_exist = "编号已经存在！";
var _lang_typeid_empty = "请选择类型！";
var _lang_name_empty = "名称不能空！";
var _lang_price_incorrect = "价格格式不正确！";
var _lang_agent_price_incorrect = "代理价格格式不正确！";
var _lang_modifying_agent_price = "代理价格修改中...";
var _lang_instance_id_empty = '请选择实例！';
var _lang_uploading_file = '正在上传文件...';

var _agentPriceIndex = 0;
var _agentPrices = [];
<ali:List Object="Product.AgentPrice" Condition="ProductID=Product[ID]">
	<ali:Record>
		_agentPrices.push({LevelID:"<%=LevelID%>",Price:"<%=Price%>"});
	</ali:Record>
</ali:List>
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title"><a href="../product/list.aspx?Lang=<%=ContentLang%>">产品列表</a> → <span class="<%=ContentLang%>Font"><%=Product[Name]%></span></div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">编辑</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../privilege/list.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>&amp;Type=Product">特权</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form>
		<table border="0" cellpadding="4" cellspacing="1">
			<tfoot>
				<tr><td colspan="2"><input type="submit" value="编辑" /></td></tr>
			</tfoot>
			<tbody>
				<tr>
					<th width="120">编号：</th>
					<td><span id="prefix">PRODUCT_</span><input type="text" name="No" size="40" maxlength="50" class="Text" data-old="<%=Product[No]%>" /><strong style="color:#F00"></strong>全部大写，词与词之间用下划线隔开</td>
				</tr>
				<tr>
					<th>名称：</th>
					<td><input type="text" name="Name" value="<%=Product[Name]%>" size="50" maxlength="255" class="Text <%=ContentLang%>Font" /></td>
				</tr>
				<tr>
					<th>性质：</th>
					<td>
						<select name="Kind">
							<option value="Service">服务</option>
							<option value="Instance">实例</option>
							<option value="File">数字文件</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>价格：</th>
					<td><input type="text" name="Price" value="<%=Convert.ToDecimal(Product[Price]).ToString("0.00")%>" size="10" maxlength="10" class="Text" />元</td>
				</tr>
				<tr>
					<th>单位：</th>
					<td>
						<select name="TimeUnit">
							<option value="Minute">分钟</option>
							<option value="Hour">小时</option>
							<option value="Day">天</option>
							<option value="Week">星期</option>
							<option value="Month">月</option>
							<option value="Season">季</option>
							<option value="HafeYear">半年</option>
							<option value="Year">年</option>
							<option value="Infinite">永久</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>代理价格：</th>
					<td>
						<table id="AgentTable" border="0" cellpadding="4" cellspacing="1">
							<thead>
								<tr>
									<th>选择</th>
									<th>代理等级</th>
									<th>价格</th>
								</tr>
							</thead>
							<tbody>
								<ali:List Object="AgentLevel">
									<ali:Record>
										<tr>
											<td><input type="checkbox" value="<%=ID%>" /></td>
											<td class="<%=ContentLang%>Font"><%=Name%></td>
											<td><input type="text" size="10" maxlength="10"  value="0.00" class="Text" />可以固定价格，也可以百分比（格式：数字%）</td>
										</tr>
									</ali:Record>
								</ali:List>
							</tbody>
						</table>
					</td>
				</tr>
				<tr id="file" style="display:none">
					<th>文件：</th>
					<td><input id="FileTextbox" type="text" name="File" value="<%=Product[File]%>" size="60" class="Text" /><input id="FileBrowse" type="button" value="浏览..." /></td>
				</tr>
				<tr id="instance" style="display:none">
					<th>绑定实例：</th>
					<td>
						<select name="InstanceID" class="<%=ContentLang%>Font">
							<option value="">未指定</option>
							<ali:List Mark="System" Object="Instance" Condition="IsMultiUser=true">
								<ali:Record>
									<%If Guid.Equals(ID, Product[InstanceID])%>
										<option value="<%=ID%>" selected="selected"><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>"><%=Name%></option>
									<%EndIf%>
								</ali:Record>
							</ali:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>描述：</th>
					<td>
						<textarea name="Description" data-lang="<%=PageLang%>" data-content-lang="<%=ContentLang%>" data-browse-url="<%=AdminBrowserURL%>?Root=<%=InstanceID%>" class="editor"><%=HttpUtility.HtmlEncode(Product[Description].ToString())%></textarea>
					</td>
				</tr>
			</tbody>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>uploader.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>