﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ali:List ID="ProductAgentPrice" Object="Product.AgentPrice" Condition="LevelID=Request.QueryString['LevelID']" />
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>选择产品</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Product.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Product.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 单位
	if (!String.IsNullOrEmpty(Request.QueryString["TimeUnit"]))
		condition.Append(and + Alias.Product.TimeUnit + "=" + Request.QueryString["TimeUnit"]);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Product.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Product.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Product.InnerID + " ASC";
			break;
		default:
			sort = Alias.Product.InnerID + " DESC";
			break;
	}
	
	return sort;
}
protected string GetUnit(object unit)
{
	string returnValue = "";
	if(unit.ToString() == "1")
	{
		returnValue = "分钟";
	}
	else if(unit.ToString() == "2")
	{
		returnValue = "小时";
	}
	else if(unit.ToString() == "3")
	{
		returnValue = "天";
	}
	else if(unit.ToString() == "4")
	{
		returnValue = "星期";
	}
	else if(unit.ToString() == "5")
	{
		returnValue = "月";
	}
	else if(unit.ToString() == "6")
	{
		returnValue = "季";
	}
	else if(unit.ToString() == "7")
	{
		returnValue = "半年";
	}
	else if(unit.ToString() == "8")
	{
		returnValue = "年";
	}
	return returnValue;
}

protected string GetInstanceName(object id)
{
	if (Guid.Equals(id, Guid.Empty))
		return "";

	return Manager.Instances.Select(AliCMS.SystemModule.Alias.Instance.ID + "='" + id + "'")[0][AliCMS.SystemModule.Alias.Instance.Name + PageLang].ToString();
}
</script>
<script type="text/javascript">
var _page = "product_select";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">选择产品</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">编号↓</option>
			<option value="2">编号↑</option>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Name">名称</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>名称</th>
					<th>编号</th>
					<th>价格</th>
					<th>数量</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Product" Page="PageNumber" PageSize="10" Condition="Condition()" Sort="Sort()">
					<ali:Record>
						<tr id="<%=ID%>" data-price="<%=Price%>" data-instance-name="<%=GetInstanceName(InstanceID)%>" data-instance-id="<%=InstanceID%>" data-sub-instance-id="<%=Guid.NewGuid()%>">
							<td class="<%=ContentLang%>Font"><%=Name%></td>
							<td><%=No%></td>
							<td><%=Convert.ToDecimal(Price).ToString("N")%>元/<%=GetUnit(TimeUnit)%></td>
							<td><input type="text" value="1" size="4" /></td>
							<td><button>添加</button></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="10" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>