﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.User.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.User.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.User.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.User.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否锁定
	string isLocked = Request.QueryString["IsLocked"];
	if (!String.IsNullOrEmpty(isLocked))
		condition.Append(and + Alias.User.IsLocked + "=" + isLocked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.User.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.User.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.User.CreateTime + " ASC";
			break;
		default:
			sort = Alias.User.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>用户名</th>
			<th>注册日期</th>
			<th>最后登录</th>
			<th>登陆次数</th>
			<th width="50">资金</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="User" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ali:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<%If Manager.HasUyghurText(Name)%>
						<td class="UYGFont"><a href="../user/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=Name%></a></td>
					<%Else%>
						<td><a href="../user/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=Name%></a></td>
					<%EndIf%>
					<td><%=CreateTime%></td>
					<td><%=LastLoginTime%></td>
					<td><%=LoginTimes%></td>
					<td><a href="../user/money/list.aspx?Lang=<%=ContentLang%>&UserID=<%=InnerID%>">资金</a></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>		
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>
