﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ali:Get ID="User" Object="User" InnerID="Request.QueryString['ID']" Validate="True" />
<ali:List ID="UserRole" Object="User.Role" Condition="UserID=User[ID] and SubUserID IS NULL" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>编辑用户</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected bool HasRole(DataRow record)
{
	DataRow[] rows = UserRole.Select(Alias.User.Role.RoleID + "='" + record[Alias.Role.ID] + "'");
	if (rows.Length == 0)
		return false;
	else
		return true;
}
</script>
<script type="text/javascript">
var _page = 'user_edit',
	_lang = '<%=ContentLang%>',
	_webPath = '<%=WebPath%>',
	_imagePath = '<%=ImagePath%>',
	_id = '<%=Request.QueryString["ID"]%>',
	_guid = '<%=User[ID]%>',
	_sex = '<%=User[Sex]%>';
	_residenceLinkageData = {element:'#Residence select:first',index:1,id:'<%=User[Residence]%>',parentChain:null,parentChainPage:'ajax_region_parent_chain.aspx?ID=<%=User[Residence]%>'},
	_originLinkageData = {element:'#Origin select:first',index:1,id:'<%=User[Origin]%>',parentChain:null,parentChainPage:'ajax_region_parent_chain.aspx?ID=<%=User[Origin]%>'},
	_lang_working = '正在操作...',
	_lang_operation_fail = '操作失败！',
	_lang_operation_success = '操作成功！',
	_lang_mobile_incorrect = '手机号码格式不正确！',
	_lang_mobile_exist = '手机号码已被别人使用！',
	_lang_email_incorrect = '电子邮件格式不正确！',
	_lang_email_exist = '电子邮件已被别人使用！',
	_lang_not_set = '-- 未指定 --',
	_lang_uploading_head = '正在上传头像...';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title"><a href="../user/list.aspx?Lang=<%=ContentLang%>">用户列表</a> → <span class="<%=ContentLang%>Font"><%=User[Name]%></span></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">编辑</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../user/money/list.aspx?Lang=<%=ContentLang%>&amp;UserID=<%=Request.QueryString["ID"]%>">资金</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form>
		<table border="0" cellpadding="4" cellspacing="1">
			<tfoot>
				<tr>
					<td colspan="3"><input type="submit" value="编辑" /></td>
				</tr>
			</tfoot>
			<tbody>
				<tr>
					<th width="120">用户名：</th>
					<td><%=User[Name]%></td>
				</tr>
				<tr>
					<th>密码：</th>
					<td><input type="password" name="Password" maxlength="30" class="Text" />若不修改，则留空</td>
				</tr>
				<tr>
					<th>手机号码：</th>
					<td><input type="text" name="Mobile" value="<%=User[Mobile]%>" size="15" maxlength="11" class="Text" data-old="<%=User[Mobile]%>" /><strong style="color:#F00"></strong></td>
				</tr>
				<tr>
					<th>电子邮件：</th>
					<td><input type="text" name="Email" value="<%=User[Email]%>" size="50" maxlength="50" class="Text" data-old="<%=User[Email]%>" /><strong style="color:#F00"></strong></td>
				</tr>
				<tr>
					<th>真实姓名：</th>
					<td><input type="text" name="RealName" value="<%=User[RealName]%>" size="40" maxlength="50" class="Text <%=ContentLang%>Font" /></td>
				</tr>
				<tr>
					<th>性别：</th>
					<td>
						<select name="Sex">
							<option value="">未指定</option>
							<option value="0">女</option>
							<option value="1">男</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>生日：</th>
					<td><input type="text" name="Birthday" value="<%=(Convert.IsDBNull(User[Birthday])) ? "" : Convert.ToDateTime(User[Birthday]).ToString("yyyy-MM-dd")%>" class="Wdate" /></td>
				</tr>
				<tr>
					<th>QQ：</th>
					<td><input type="text" name="QQ" value="<%=User[QQ]%>" size="15" maxlength="15" class="Text" /></td>
				</tr>
				<tr>
					<th>头像：</th>
					<td><input id="HeadTextbox" type="text" name="Head" value="<%=User[Head]%>" size="60" class="Text" /><input id="HeadBrowse" type="button" value="浏览..." /></td>
				</tr>
				<tr>
					<th>现居住地：</th>
					<td id="Residence">
						<select name="Residence" class="<%=ContentLang%>Font">
							<option value="">-- 未指定 --</option>
							<ali:List ID="Region" Object="Region" Condition="ParentID IS NULL">
								<ali:Record>
									<option value="<%=ID%>" data-inner-id="<%=InnerID%>"><%=Name%></option>
								</ali:Record>
							</ali:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>籍贯：</th>
					<td id="Origin">
						<select name="Origin" class="<%=ContentLang%>Font">
							<option value="">-- 未指定 --</option>
							<ali:List Object="Region" Source="Region">
								<ali:Record>
									<option value="<%=ID%>" data-inner-id="<%=InnerID%>"><%=Name%></option>
								</ali:Record>
							</ali:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>代理等级：</th>
					<td>
						<select name="AgentLevelID" class="<%=ContentLang%>Font">
							<option value="">非代理</option>
								<ali:List Object="AgentLevel">
									<ali:Record>
										<%If Guid.Equals(ID, User[AgentLevelID])%>
											<option value="<%=ID%>" selected="selected"><%=Name%></option>
										<%Else%>
											<option value="<%=ID%>"><%=Name%></option>
										<%EndIf%>
									</ali:Record>
								</ali:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>角色：</th>
					<td>
						<ali:List Object="Role" Condition="IsDefault=false and UserID IS NULL">
							<ali:Record>
								<%If HasRole(Record)%>
									<label class="<%=ContentLang%>Font"><input type="checkbox" name="Role" value="<%=ID%>" checked="checked" /><%=Name%></label>
								<%Else%>
									<label class="<%=ContentLang%>Font"><input type="checkbox" name="Role" value="<%=ID%>" /><%=Name%></label>
								<%EndIf%>
							</ali:Record>
						</ali:List>
					</td>
				</tr>
				<tr>
					<th>描述：</th>
					<td><textarea name="Profile" cols="60" rows="10" class="Text <%=ContentLang%>Font"><%=HttpUtility.HtmlEncode(User[Profile].ToString())%></textarea></td>
				</tr>
				<tr>
					<th>注册日期：</th>
					<td><%=User[CreateTime]%></td>
				</tr>
				<tr>
					<th>创建人：</th>
					<td><%=User[Creator]%></td>
				</tr>
				<tr>
					<th>手机是否验证：</th>
					<td>
						<%If Convert.ToBoolean(User[IsMobileValidated])%>
							是
						<%Else%>
							否
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>电子邮件是否验证：</th>
					<td>
						<%If Convert.ToBoolean(User[IsEmailValidated])%>
							是
						<%Else%>
							否
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>指标：</th>
					<td>
						最后登录时间：<%=User[LastLoginTime]%><br />
						最后登录IP：<%=User[LastLoginIP]%><br />
						登陆次数：<%=User[LoginTimes]%><br />
					</td>
				</tr>
			</tbody>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>uploader.js"></script>
<script type="text/javascript" src="<%=CommonPath%>date_picker/date_picker.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>