﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:Get ID="ThisUser" Object="User" InnerID="Request.QueryString['UserID']" />
<ali:Get ID="Balance" Object="User.Money" Operation="GetAllBalance((Guid)ThisUser[ID])" />
<script language="c#" runat="server">
private decimal _balance = -1;
protected string GetBalance(object amount)
{
	if (_balance == -1)
		_balance = Balance;
	
	decimal result = _balance;
	_balance -= Convert.ToDecimal(amount);
	return result.ToString("0.00");
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th>交易时间</th>
			<th>业务摘要</th>
			<th>转入金额</th>
			<th>转出金额</th>
			<th>当前余额</th>
			<th>支付方式</th>
			<th>支付账号</th>
			<th>状态</th>
			<th>备 注</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="User.Money" Condition="UserID=ThisUser[ID]" Sort="CreateTime DESC" Validate="True">
			<ali:Record>
				<tr>
					<td><%=CreateTime%></td>
					<td class="<%=ContentLang%>Font"><%=Title%></td>
					<%If Convert.ToDecimal(Amount) > 0%>
						<td><%=Convert.ToDecimal(Amount).ToString("0.00")%></td>
						<td>--</td>
					<%Else%>
						<td>--</td>
						<td><%=(-1 * Convert.ToDecimal(Amount)).ToString("0.00")%></td>
					<%EndIf%>
					<td>
						<%If Convert.ToBoolean(Frozen)%>
							--
						<%Else%>
							<%=GetBalance(Amount)%>
						<%EndIf%>
					</td>
					<td class="<%=ContentLang%>Font"><%=PaymentName%></td>
					<td><%=PaymentAccount%></td>
					<td>
						<%If Convert.ToString(PaymentType) == "Alipay"%>
							<%If Convert.ToString(TradeStatus) == "TRADE_FINISHED" || Convert.ToString(TradeStatus) == "TRADE_SUCCESS"%>
								交易成功
							<%ElseIf Convert.ToString(TradeStatus) == "TRADE_CLOSED"%>
								交易中途关闭
							<%ElseIf Convert.ToString(TradeStatus) == "WAIT_BUYER_PAY"%>
								等待买家付款
							<%ElseIf Convert.ToString(TradeStatus) == "WAIT_SELLER_SEND_GOODS"%>
								买家已付款，等待卖家发货
							<%ElseIf Convert.ToString(TradeStatus) == "WAIT_BUYER_CONFIRM_GOODS"%>
								卖家已发货，等待买家确认
							<%Else%>
								<%=TradeStatus%>
							<%EndIf%>
						<%ElseIf Convert.ToString(PaymentType) == "ChinaBank"%>
							<%If Convert.ToString(TradeStatus) == "TRADE_SUCCESS"%>
								交易成功
							<%ElseIf Convert.ToString(TradeStatus) == "WAIT_BUYER_PAY"%>
								等待买家付款
							<%Else%>
								<%=TradeStatus%>
							<%EndIf%>
						<%Else%>
							<%If Convert.ToBoolean(Frozen)%>
								冻结
							<%Else%>
								正常
							<%EndIf%>
						<%EndIf%>
					</td>
					<td class="<%=ContentLang%>Font AlignLeft" style="white-space:pre"><%=Memo%></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>		
