﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Goods.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Goods.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否发布
	string isReleased = Request.QueryString["IsReleased"];
	if (isReleased == null)
		condition.Append(and + Alias.Goods.IsReleased + "=true");
	else if (isReleased != String.Empty)
		condition.Append(and + Alias.Goods.IsReleased + "=" + isReleased);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Goods.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Goods.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Goods.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Goods.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Goods.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Goods.Name + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "No")
			condition.Append(and + "(" + Alias.Goods.No + " LIKE '%" + keyword + "%' OR " + Alias.Goods.Spec + " LIKE '%" + keyword + "%')");
		else if (Request.QueryString["KeywordType"] == "BarCode")
			condition.Append(and + "(" + Alias.Goods.BarCode + " LIKE '%" + keyword + "%' OR " + Alias.Goods.Spec + " LIKE '%" + keyword + "%')");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Goods.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Goods.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Goods.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Goods.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Goods.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Goods.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Goods.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Goods.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Goods.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Goods.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Goods.Up + " DESC";
			break;
		case "12":
			sort = Alias.Goods.Up + " ASC";
			break;
		case "13":
			sort = Alias.Goods.Down + " DESC";
			break;
		case "14":
			sort = Alias.Goods.Down + " ASC";
			break;
		default:
			sort = Alias.Goods.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected bool Move
{
	get
	{
		if (Request.QueryString["Sort"] == "5" || Request.QueryString["Sort"] == "6")
			return Request.QueryString["IsRecommended"] == "true";
		else if (Request.QueryString["Sort"] == "7" || Request.QueryString["Sort"] == "8")
			return Request.QueryString["IsHeld"] == "true";
		else
			return false;
	}
}

protected bool ListByPicture
{
	get
	{
		if (Request.QueryString["ListByPicture"] != null)
			return Convert.ToBoolean(Request.QueryString["ListByPicture"]);
		else if (Request.Cookies["ListByPicture"] != null)
			return Convert.ToBoolean(Request.Cookies["ListByPicture"].Value);
		else
			return false;
	}
}
</script>
<ali:List ID="List" Object="Goods" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" />
<%If ListByPicture%>
	<ali:List Object="Goods" Source="List">
		<ali:Row MaxCol="4">
			<ul>
				<ali:Col MaxRecord="1">
					<ali:Record>
						<li>
							<a href="../goods/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><img src="<%=Thumbnail%>" /></a>
							<div class="<%=ContentLang%>Font"><a href="../goods/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=Name%></a><input type="checkbox" name="Sel" value="<%=InnerID%>" /></div>
						</li>
					</ali:Record>
				</ali:Col>
			</ul>
		</ali:Row>
	</ali:List>
<%Else%>
	<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
		<thead>
			<tr>
				<th width="40">选择</th>
				<%If Move%>
					<th width="60">
						<%If Request.QueryString["IsRecommended"] == "true"%>
							移动推荐
						<%Else%>
							移动置顶
						<%EndIf%>
					</th>
				<%EndIf%>
				<th>名称</th>
				<th width="120">创建时间</th>
				<th width="40">人气</th>
				<th width="40">顶</th>
				<th width="40">踩</th>
			</tr>
		</thead>
		<tbody>
			<ali:List Object="Goods" Source="List">
				<ali:Record>
					<tr>
						<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
						<%If Move%>
							<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
						<%EndIf%>
						<td class="<%=ContentLang%>Font"><a href="../goods/edit.aspx?Lang=<%=ContentLang%>&ID=<%=InnerID%>"><%=Name%></a></td>
						<td><%=CreateTime%></td>
						<td><%=HitCount%></td>
						<td><%=Up%></td>
						<td><%=Down%></td>
					</tr>
				</ali:Record>
			</ali:List>
		</tbody>
	</table>
<%EndIf%>
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>
