﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>类别列表</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否显示
	string isDisplay = Request.QueryString["IsDisplay"];
	if (isDisplay == null)
		condition.Append(Alias.GoodsCategory.IsDisplay + "=true");
	else if (isDisplay != String.Empty)
		condition.Append(Alias.GoodsCategory.IsDisplay + "=" + isDisplay);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.GoodsCategory.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.GoodsCategory.IsHeld + "=" + isHeld);
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.GoodsCategory.Sort + " ASC";
			break;
		case "2":
			sort = Alias.GoodsCategory.Recommend + " DESC";
			break;
		case "3":
			sort = Alias.GoodsCategory.Recommend + " ASC";
			break;
		case "4":
			sort = Alias.GoodsCategory.Hold + " DESC";
			break;
		case "5":
			sort = Alias.GoodsCategory.Hold + " ASC";
			break;
		default:
			sort = Alias.GoodsCategory.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = 'goods_category_list',
	_lang = '<%=ContentLang%>',
	_webPath = '<%=WebPath%>',
	_imagePath = '<%=ImagePath%>',
	_lang_working = '正在操作...',
	_lang_operation_fail = '操作失败！',
	_lang_operation_success = '操作成功！',
	_lang_name_empty = '名称不能空！',
	_lang_confirm_delete = '要删除此项吗？',
	_lang_display = '显示',
	_lang_undisplay = '取消显示',
	_lang_recommend = '推荐',
	_lang_unrecommend = '取消推荐',
	_lang_hold = '置顶',
	_lang_unhold = '取消置顶',
	_lang_selection_empty = '没有选择任何对象！';
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">类别列表</div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">类别列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../goods_category/add.aspx?Lang=<%=ContentLang%>">添加类别</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsDisplay">
			<option value="">是否显示</option>
			<option value="false">未显示</option>
			<option value="true" selected="selected">已显示</option>
		</select>
		<select id="IsRecommended">
			<option value="">是否推荐</option>
			<option value="false">未推荐</option>
			<option value="true">已推荐</option>
		</select>
		<select id="IsHeld">
			<option value="">是否置顶</option>
			<option value="false">未置顶</option>
			<option value="true">已置顶</option>
		</select>
		<select id="Sort">
			<option value="1" selected="selected">手动排序</option>
			<option value="2">推荐↓</option>
			<option value="3">推荐↑</option>
			<option value="4">置顶↓</option>
			<option value="5">置顶↑</option>
		</select>
		<input id="SelectAll" type="button" value="全选" class="Button" />
		<input id="ReverseSelect" type="button" value="反选" class="Button" />
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="TreeTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th width="40">移动</th>
					<th>名称及层次</th>
					<th width="40">修改</th>
					<th width="80">浏览商品</th>
					<th width="80">添加子类别</th>
					<th width="40">编辑</th>
					<th width="40">删除</th>
				</tr>
			</thead>
			<tbody>
				<ali:Tree Object="GoodsCategory" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Control>
						<ali:Space><span style="margin-left:20px"></span></ali:Space>
						<ali:Line><img src="<%=ImagePath%>tree/line.gif" /></ali:Line>
						<ali:TopOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/top_open_flipCHS.gif" class="ShowHide" /></ali:TopOpen>
						<ali:Top><img src="<%=ImagePath%>tree/top_flipCHS.gif" /></ali:Top>
						<ali:MiddleOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/middle_open_flipCHS.gif" class="ShowHide" /></ali:MiddleOpen>
						<ali:Middle><img src="<%=ImagePath%>tree/middle_flipCHS.gif" /></ali:Middle>
						<ali:BottomOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/bottom_open_flipCHS.gif" class="ShowHide" /></ali:BottomOpen>
						<ali:Bottom><img src="<%=ImagePath%>tree/bottom_flipCHS.gif" /></ali:Bottom>
					</ali:Control>
					<ali:Record>
						<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="<%=ParentInnerID%>">
							<form>
                                <td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
								<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
								<th><span id="Control<%=InnerID%>"><%=Control%></span><input type="text" name="Name" value="<%=Name%>" size="50" class="<%=ContentLang%>Font"></th>
								<td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
								<td><a href="../goods/list.aspx?Lang=<%=ContentLang%>&amp;CategoryID=<%=ID%>">浏览商品</a></td>
								<td><a href="../goods_category/add.aspx?Lang=<%=ContentLang%>&amp;ParentID=<%=ID%>">添加子类别</a></td>
								<td><a href="../goods_category/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">编辑</a></td>
								<td><a href="">删除</a></td>
							</form>
						</tr>
						<%=ChildRecords%>
					</ali:Record>
				</ali:Tree>
			</tbody>
		</table>
	</div>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>move.js"></script>
<script type="text/javascript" src="<%=JsPath%>tree_handler.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>