﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<%@ Register TagPrefix="alicmsUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="alicmsUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>订单列表</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ali:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<alicmsUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
.green{color:green}
.red{color:red}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否受理
	string isAccepted = Request.QueryString["IsAccepted"];
	if (!String.IsNullOrEmpty(isAccepted))
		condition.Append(and + Alias.Order.IsAccepted + "=" + isAccepted);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否付款
	string isPayed = Request.QueryString["IsPayed"];
	if (!String.IsNullOrEmpty(isPayed))
		condition.Append(and + Alias.Order.IsPayed + "=" + isPayed);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否发货
	string isDelivered = Request.QueryString["IsDelivered"];
	if (!String.IsNullOrEmpty(isDelivered))
		condition.Append(and + Alias.Order.IsDelivered + "=" + isDelivered);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否完成
	string isFinished = Request.QueryString["IsFinished"];
	if (!String.IsNullOrEmpty(isFinished))
		condition.Append(and + Alias.Order.IsFinished + "=" + isFinished);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "No")
			condition.Append(and + Alias.Order.No + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "UserName")
			condition.Append(and + Alias.Order.UserName + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Order.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.Order.CreateTime + " ASC";
			break;
		case "3":
			sort = Alias.Order.Sum + " DESC";
			break;
		case "4":
			sort = Alias.Order.Sum + " ASC";
			break;
		default:
			sort = Alias.Order.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = 'order_list',
	_lang = '<%=ContentLang%>',
	_webPath = '<%=WebPath%>',
	_imagePath = '<%=ImagePath%>',
	_lang_working = '正在操作...',
	_lang_operation_fail = '操作失败！',
	_lang_operation_success = '操作成功！',
	_lang_confirm_accept = '要受理此项吗？',
	_lang_confirm_cancel = '要作废此项吗？',
	_lang_confirm_archive = '要归档此项吗？',
	_lang_confirm_delete = '要删除此项吗？',
	_lang_selection_empty = '没有选择任何对象！',
	_lang_finish = '完成',
	_lang_archive = '归档',
	_lang_cancel = '作废',
	_lang_delete = "删除";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">订单列表</div>
	<div class="Right">
		<alicmsUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">订单列表</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsAccepted">
			<option value="">是否受理</option>
			<option value="false">未受理</option>
			<option value="true">已受理</option>
		</select>
		<select id="IsPayed">
			<option value="">是否付款</option>
			<option value="0">未付款</option>
			<option value="1">部分付款</option>
			<option value="2">已付款</option>
			<option value="3">部分退款</option>
			<option value="4">已退款</option>
		</select>
		<select id="IsDelivered">
			<option value="">是否发货</option>
			<option value="0">未发货</option>
			<option value="1">部分发货</option>
			<option value="2">已发货</option>
			<option value="3">已收货</option>
			<option value="4">部分退货</option>
			<option value="5">已退货</option>
		</select>
		<select id="IsFinished">
			<option value="">是否完成</option>
			<option value="0">未完成</option>
			<option value="1">已完成</option>
			<option value="2">已作废</option>
			<option value="3">已归档</option>
		</select>
	</div>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">下单日期↓</option>
			<option value="2">下单日期↑</option>
			<option value="3">订单总价↓</option>
			<option value="4">订单总价↑</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="UserName">用户名称</option>
			<option value="No">订单编号</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
		<input id="SelectAll" type="button" value="全选" class="Button" />
		<input id="ReverseSelect" type="button" value="反选" class="Button" />
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th>订单编号</th>
					<th>订单标题</th>
					<th>下单日期</th>
					<th>订单总价（元）</th>
					<th>用户名称</th>
					<th>订单状态</th>
					<th>订单操作</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Order" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr id="<%=InnerID%>">
							<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td>
								<%If Convert.ToBoolean(IsAccepted)%>
									<a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=No%></a>
								<%Else%>
									<a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=No%></a>
								<%EndIf%>
							</td>
							<td class="<%=ContentLang%>Font">
								<%If Convert.ToBoolean(IsAccepted)%>
									<a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Title%></a>
								<%Else%>
									<a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Title%></a>
								<%EndIf%>
							</td>
							<td><%=CreateTime%></td>
							<td><%=Convert.ToDecimal(Sum).ToString("0.00")%></td>
							<td class="<%=ContentLang%>Font"><%=UserName%></td>
							<td>
								<%If !Convert.ToBoolean(IsAccepted)%>
									未受理
								<%ElseIf Int32.Equals(IsFinished, 1)%>
									已完成
								<%ElseIf Int32.Equals(IsFinished, 2)%>
									已作废
								<%ElseIf Int32.Equals(IsFinished, 3)%>
									已归档
								<%Else%>
									<%If Int32.Equals(IsPayed, 0)%>
										未付款
									<%ElseIf Int32.Equals(IsPayed, 1)%>
										部分付款
									<%ElseIf Int32.Equals(IsPayed, 2)%>
										已付款
									<%ElseIf Int32.Equals(IsPayed, 3)%>
										部分退款
									<%ElseIf Int32.Equals(IsPayed, 4)%>
										已退款
									<%EndIf%>
									，
									<%If Int32.Equals(IsDelivered, 0)%>
										未发货
									<%ElseIf Int32.Equals(IsDelivered, 1)%>
										部分发货
									<%ElseIf Int32.Equals(IsDelivered, 2)%>
										已发货
									<%ElseIf Int32.Equals(IsDelivered, 3)%>
										已收货
									<%ElseIf Int32.Equals(IsDelivered, 4)%>
										部分退货
									<%ElseIf Int32.Equals(IsDelivered, 5)%>
										已退货
									<%EndIf%>
								<%EndIf%>
							</td>
							<td>
								<%If !Convert.ToBoolean(IsAccepted)%>
									<input type="button" value="受理" data-action="Accept" />
								<%ElseIf Int32.Equals(IsFinished, 0) || Int32.Equals(IsFinished, 1)%>
									<%If Int32.Equals(IsPayed, 0)%>
										<input type="button" value="付款" data-action="Pay" />
									<%ElseIf Int32.Equals(IsPayed, 1)%>
										<input type="button" value="付款" data-action="Pay" />
										<input type="button" value="退款" data-action="Refund" />
									<%ElseIf Int32.Equals(IsPayed, 2)%>
										<input type="button" value="退款" data-action="Refund" />
									<%ElseIf Int32.Equals(IsPayed, 3)%>
										<input type="button" value="付款" data-action="Pay" />
										<input type="button" value="退款" data-action="Refund" />
									<%EndIf%>
									
									<%If Int32.Equals(IsDelivered, 0) || Int32.Equals(IsDelivered, 1)%>
										<input type="button" value="发货" data-action="Deliver" />
									<%ElseIf Int32.Equals(IsDelivered, 2) || Int32.Equals(IsDelivered, 3)%>
										<input type="button" value="退货" data-action="Return" />
									<%ElseIf Int32.Equals(IsDelivered, 4)%>
										<input type="button" value="发货" data-action="Deliver" />
										<input type="button" value="退货" data-action="Return" />
									<%EndIf%>
								<%EndIf%>
							</td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ali:FirstPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<span class="Current"><%=Index%></span>						
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ali:Yes>
						<ali:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ali:No>
					</ali:LastPage>
				</div>
			</div>
		</ali:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=ModuleJsPath%>module.js"></script>
</body>
</html>