﻿function BuildHeader()
{
	if (_page == 'user_select')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&Keyword=' + encodeURIComponent($('#Keyword').val()) + '&KeywordType=' + $('#KeywordType').val() + '&Page=' + _pageNumber;
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != 'object')
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url: BuildHeader(),
		data: {},
		type: 'POST',
		error: function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success: function(data)
		{
			var list = $('#List');

			list.html(HandleFake404(data, 'text'));
			SetStatusMessage();

			if (typeof(SetupIme) == 'function')
				SetupIme();
				
			MakeButton();
		}
	});
}

function MakeButton()
{
	var buttons = '';
	var button;
	
	//回收
	button = $('#IsRecycled');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
	    {
		    buttons += '<button class="Button" id="Recycle">' + _lang_recycle + '</button>';
	    }
	    else if (button[0].selectedIndex == 2)
	    {
		    buttons += '<button class="Button" id="Delete">' + _lang_delete + '</button>';
		    buttons += '<button class="Button" id="Recover">' + _lang_recover + '</button>';
	    }
	}

	$('#ExtraButton').html(buttons);
}

//-------------------------------------------------
//Start: 角色
function Role()
{
	var __object = 'Role',
		__base = new Base();

	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&No=' + encodeURIComponent(form.No.value);
		
		return data;
	}

	this.add = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
		
		__base.add({object:__object,data:data});

		return false;
	};

	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});

		return false;
	};

	this.del = function(id)
	{
		__base.update(__object, 'Delete', id, false);
		$('#Row' + id).remove();
	};
}
//End: 角色
//-------------------------------------------------

//-------------------------------------------------
//Start: 操作员
function Operator()
{
	var __object = 'Operator',
		__base = new Base();

	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		if (form.User.value == '')
		{
			Alert(_lang_user_empty, function(){form.User.select();}, this);
			return null;
		}
		
		if (form.RoleID.selectedIndex == -1)
		{
			Alert(_lang_role_empty);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Mobile=' + encodeURIComponent(form.Mobile.value);
		data += '&QQ=' + encodeURIComponent(form.QQ.value);
		data += '&UserName=' + encodeURIComponent(form.User.value);
		data += '&UserID=' + encodeURIComponent($(form.User).data('id'));
		data += '&RoleID=' + encodeURIComponent(form.RoleID.value);
		
		return data;
	}

	this.add = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
		
		__base.add({object:__object,data:data});

		return false;
	};

	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});

		return false;
	};

	this.del = function(id)
	{
		__base.update(__object, 'Delete', id, false);
		$('[data-id=' + id + ']').remove();
	};

	this.onUserSelectClick = function()
	{
		__base.showDialog({url:'select_user.aspx?Lang=' + _lang,callback:selectUser});
	};
	
	function selectUser()
	{
		$('[name=User]').val($(this).text()).data('id', $(this).data('id'));
		selectUser.prototype.dialog.close();
		return false;
	}
}
//End: 操作员
//-------------------------------------------------

(function()
{
	if (typeof(_page) == 'undefined')
		return;
	
	if (_page == 'role_add')
	{
		var role = new Role();
		
		$('form:first').submit(role.add);
	}
	else if (_page == 'role_edit')
	{
		var role = new Role();
	
		$('form:first').submit(role.modify);
	}
	else if (_page == 'role_list')
	{
		var role = new Role();

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').data('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)role.del(id);}, this);
			return false;
		});
	}
	else if (_page == 'operator_add')
	{
		var operator = new Operator();
		
		$('form:first').submit(operator.add);
		$('#UserSelect').click(operator.onUserSelectClick);
		$('#ClearUser').click(function(){$('[name=User]').val('').data('id', '');});
	}
	else if (_page == 'operator_edit')
	{
		var operator = new Operator();
	
		$('form:first').submit(operator.modify);
		$('#UserSelect').click(operator.onUserSelectClick);
		$('#ClearUser').click(function(){$('[name=User]').val('').data('id', '');});
	}
	else if (_page == 'operator_list')
	{
		var operator = new Operator();

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').data('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)operator.del(id);}, this);
			return false;
		});
	}
	else if (_page == 'user_select')
	{
		window.dialogArguments.prototype.dialog = window;
		$('#List').on('click', 'td a', window.dialogArguments);
		
		$('#Keyword').keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$('#Search').click(function(){Search(1);});
	}
})();