﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.SystemPageBase" %>
<ali:List ID="Regions" Mark="Goods" Object="Region" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Shop.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Shop.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Shop.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Shop.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Shop.UpdateTime + " ASC";
			break;
		default:
			sort = Alias.Shop.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected string BuildRegion(object regionId)
{
	StringBuilder result = new StringBuilder();

	DataRow[] regions = Regions.Select(AliShop.GoodsModule.Alias.Region.ID + "='" + regionId + "'");
	while (regions.Length != 0)
	{
		result.Insert(0, regions[0][AliShop.GoodsModule.Alias.Region.Name]);
		regions = Regions.Select(AliShop.GoodsModule.Alias.Region.ID + "='" + regions[0][AliShop.GoodsModule.Alias.Region.ParentID] + "'");
	}
	
	return result.ToString();
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>名称</th>
			<th>店铺地址</th>
			<th width="120">座机号码</th>
			<th width="120">手机号码</th>
			<th width="120">开业日期</th>
		</tr>
	</thead>
	<tbody>
		<ali:List ID="List" Object="Shop" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ali:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td class="<%=ContentLang%>Font"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<td><%=BuildRegion(RegionID)%><%=Address%></td>
					<td><%=Phone%></td>
					<td><%=Mobile%></td>
					<td><%=OpeningDate%></td>
				</tr>
			</ali:Record>
		</ali:List>
	</tbody>
</table>		
<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ali:FirstPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ali:No>
			</ali:FirstPage>
			<ali:CurrentPage Range="5">
				<ali:Yes>
					<span class="Current"><%=Index%></span>						
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ali:No>
			</ali:CurrentPage>
			<ali:LastPage>
				<ali:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ali:Yes>
				<ali:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ali:No>
			</ali:LastPage>
		</div>
	</div>
</ali:Pagination>
