﻿function BuildHeader()
{
	if (_page == 'staff_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&IsRecycled=' + $('#IsRecycled').val() + '&IsReleased=' + $('#IsReleased').val() + '&IsHeld=' + $('#IsHeld').val() + '&IsRecommended=' + $('#IsRecommended').val() + '&CategoryID=' + $('#CategoryID').val() + '&IncludeSubCategory=' + $('#IncludeSubCategory')[0].checked + '&Sort=' + $('#Sort').val() + '&Keyword=' + encodeURIComponent($('#Keyword').val()) + '&KeywordType=' + $('#KeywordType').val() + '&ListByPicture=' + $('#ListByPicture')[0].checked + '&Page=' + _pageNumber;
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != 'object')
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url: BuildHeader(),
		data: {},
		type: 'POST',
		error: function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success: function(data)
		{
			var list = $('#List');

			list.html(HandleFake404(data, 'text'));
			SetStatusMessage();

			if (typeof(SetupIme) == 'function')
				SetupIme();
				
			MakeButton();
		}
	});
}

function MakeButton()
{
	var buttons = '';
	var button;
	
	//回收
	button = $('#IsRecycled');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
	    {
		    buttons += '<button class="Button" id="Recycle">' + _lang_recycle + '</button>';
	    }
	    else if (button[0].selectedIndex == 2)
	    {
		    buttons += '<button class="Button" id="Delete">' + _lang_delete + '</button>';
		    buttons += '<button class="Button" id="Recover">' + _lang_recover + '</button>';
	    }
	}

	$('#ExtraButton').html(buttons);
}

//-------------------------------------------------
//Start: 民族
function Nation()
{
	var __object = 'Nation',
		__base = new Base();

	this.add = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
	
		__base.add({object:__object,data:data});
		
		return false;
	};

	this.modify = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
	
		__base.modify({object:__object,data:data});
		
		return false;
	};

	this.del = function(id)
	{
		__base.update(__object, 'Delete', id, false);
		$('#Row' + id).remove();
	};
	
	this.move = function(from, to)
	{
		__base.move(__object, 'Move', from, to);
	};	
}
//End: 民族
//-------------------------------------------------

//-------------------------------------------------
//Start: 党派
function Party()
{
	var __object = 'Party',
		__base = new Base();

	this.add = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
	
		__base.add({object:__object,data:data});
		
		return false;
	};

	this.modify = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
	
		__base.modify({object:__object,data:data});
		
		return false;
	};

	this.del = function(id)
	{
		__base.update(__object, 'Delete', id, false);
		$('#Row' + id).remove();
	};
	
	this.move = function(from, to)
	{
		__base.move(__object, 'Move', from, to);
	};	
}
//End: 党派
//-------------------------------------------------

//-------------------------------------------------
//Start: 学历
function Degree()
{
	var __object = 'Degree',
		__base = new Base();

	this.add = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
	
		__base.add({object:__object,data:data});
		
		return false;
	};

	this.modify = function()
	{
		if (this.Name.value == '')
		{
			Alert(_lang_name_empty, function(){this.Name.select();}, this);
			return false;
		}
		
		var data = 'Name=' + encodeURIComponent(this.Name.value);
	
		__base.modify({object:__object,data:data});
		
		return false;
	};

	this.del = function(id)
	{
		__base.update(__object, 'Delete', id, false);
		$('#Row' + id).remove();
	};
	
	this.move = function(from, to)
	{
		__base.move(__object, 'Move', from, to);
	};	
}
//End: 学历
//-------------------------------------------------

(function()
{
	if (typeof(_page) == 'undefined')
		return;
	
	if (_page == 'nation_add')
	{
		var nation = new Nation();
		
		$('form:first').submit(nation.add);
	}
	else if (_page == 'nation_edit')
	{
		var nation = new Nation();
	
		$('form:first').submit(nation.modify);
	}
	else if (_page == 'nation_list')
	{
		var nation = new Nation();

		InitMove(null, 'Move', null, nation.move);

		$('[sort]').mouseover(function(){this.className += ' Move_MouseOver';}).mouseout(function(){this.className='Move';});

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)nation.del(id);}, this);
			return false;
		});
	}
	else if (_page == 'party_add')
	{
		var party = new Party();
		
		$('form:first').submit(party.add);
	}
	else if (_page == 'party_edit')
	{
		var party = new Party();
	
		$('form:first').submit(party.modify);
	}
	else if (_page == 'party_list')
	{
		var party = new Party();

		InitMove(null, 'Move', null, party.move);

		$('[sort]').mouseover(function(){this.className += ' Move_MouseOver';}).mouseout(function(){this.className='Move';});

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)party.del(id);}, this);
			return false;
		});
	}
	else if (_page == 'degree_add')
	{
		var degree = new Degree();
		
		$('form:first').submit(degree.add);
	}
	else if (_page == 'degree_edit')
	{
		var degree = new Degree();
	
		$('form:first').submit(degree.modify);
	}
	else if (_page == 'degree_list')
	{
		var degree = new Degree();

		InitMove(null, 'Move', null, degree.move);

		$('[sort]').mouseover(function(){this.className += ' Move_MouseOver';}).mouseout(function(){this.className='Move';});

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').attr('ItemID');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)degree.del(id);}, this);
			return false;
		});
	}
})();