﻿function BuildHeader()
{
	if (_page == 'warehouse_list')
		return BuildAjaxPath(true) + '?Lang=' + _lang + '&IsRecycled=' + $('#IsRecycled').val() + '&Sort=' + $('#Sort').val() + '&Keyword=' + encodeURIComponent($('#Keyword').val()) + '&KeywordType=' + $('#KeywordType').val() + '&Page=' + _pageNumber;
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != 'object')
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url: BuildHeader(),
		data: {},
		type: 'POST',
		error: function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success: function(data)
		{
			var list = $('#List');

			list.html(HandleFake404(data, 'text'));
			SetStatusMessage();

			if (typeof(SetupIme) == 'function')
				SetupIme();
				
			MakeButton();
		}
	});
}

function MakeButton()
{
	var buttons = '';
	var button;
	
	//回收
	button = $('#IsRecycled');
	if (button.length == 1)
	{
	    if (button[0].selectedIndex == 1)
	    {
		    buttons += '<button class="Button" id="Recycle">' + _lang_recycle + '</button>';
	    }
	    else if (button[0].selectedIndex == 2)
	    {
		    buttons += '<button class="Button" id="Delete">' + _lang_delete + '</button>';
		    buttons += '<button class="Button" id="Recover">' + _lang_recover + '</button>';
	    }
	}

	$('#ExtraButton').html(buttons);
}

//联动
function linkage(element, page, callback)
{
	var me = $(element);
	me.nextAll('select').remove();
	if (me.val() == '' || me.val() == '0')
	{
		//if (callback != null)
		//	callback();
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url: page + '?Lang=' + _lang + '&ParentID=' + encodeURIComponent(element.value),
		type: 'GET',
		error: function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			SetStatusMessage();
				
			var items = eval(data);
			if (items.length == 0)
			{
				if (callback != null)
					callback();
				return;
			}

			var html = '<option value="">' + _lang_not_set + '</option>';
			for (var i = 0; i < items.length; i++)
				html += '<option value="' + items[i].id + '" data-inner-id="' + items[i].innerId + '">' + items[i].name + '</option>';

			var next = me.next('select');
			if (next.length == 0)
			{
				html = '<select class="' + _lang + 'Font">' + html + '</select>';
				me.after(html);	
			}
			else
			{
				next.empty().append(html);			
			}

			if (callback != null)
				callback();
		}
	});	
}

function linkageSelect(data)
{
	if (data.parentChain == null)
	{
		$.get(data.parentChainPage, function(result)
		{
			data.parentChain = result;
			data.parents = result.split('.');
			linkageSelect(data)
		});

		return;
	}

	data.element = $(data.element);
	if (data.parents.length == 1)
	{
		data.element.find('[value=' + data.id + ']').attr('selected', true);
	}
	else
	{
		data.element.find('[data-inner-id=' + data.parents[data.index++] + ']').attr('selected', true);
		data.element.change();
	}
}

//-------------------------------------------------
//#region 仓库
function Warehouse()
{
	var __object = 'Warehouse',
		__base = new Base();

	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'No=' + encodeURIComponent(form.No.value);
		data += '&Name=' + encodeURIComponent(form.Name.value);
		data += '&Phone=' + encodeURIComponent(form.Phone.value);
		data += '&Mobile=' + encodeURIComponent(form.Mobile.value);
		data += '&Address=' + encodeURIComponent(form.Address.value);
		data += '&OpeningDate=' + encodeURIComponent(form.OpeningDate.value);
		data += '&Zip=' + encodeURIComponent(form.Zip.value);
		data += '&Description=' + encodeURIComponent(form.Description.value);

		var region = $('#region [value!=""]:selected:last');
		if (region.length)
			data += '&RegionID=' + region.val();
		
		return data;
	}

	this.add = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
		
		__base.add({object:__object,data:data});

		return false;
	};

	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});

		return false;
	};
	
	this.update = function(operation, id)
	{
		if (this.tagName == 'BUTTON')
			operation = this.id;

		__base.update(__object, operation, id);
	};
	
	this.regionCallback = function()
	{
		if (_regionLinkageData == null)
			return;

		var last = $('#region select:last');
		if (_regionLinkageData.index < _regionLinkageData.parents.length)
		{
			last.find('[data-inner-id=' + _regionLinkageData.parents[_regionLinkageData.index++] + ']').attr('selected', true);
			last.change();
		}
		else if (_regionLinkageData != null)
		{
			last.find('[value=' + _regionLinkageData.id + ']').attr('selected', true);
			last.change();
			_regionLinkageData = null;
		}
	};
}
//#endregion 仓库
//-------------------------------------------------

//-------------------------------------------------
//#region 角色
function Role()
{
	var __object = 'Role',
		__base = new Base();

	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&No=' + encodeURIComponent(form.No.value);
		
		return data;
	}

	this.add = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
		
		__base.add({object:__object,data:data});

		return false;
	};

	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});

		return false;
	};

	this.del = function(id)
	{
		__base.update(__object, 'Delete', id, false);
		$('#Row' + id).remove();
	};
}
//#endregion 角色
//-------------------------------------------------

//-------------------------------------------------
//#region 操作员
function Operator()
{
	var __object = 'Operator',
		__base = new Base();

	function prepareData(form)
	{
		if (form.Name.value == '')
		{
			Alert(_lang_name_empty, function(){form.Name.select();}, this);
			return null;
		}
		
		if (form.User.value == '')
		{
			Alert(_lang_user_empty, function(){form.User.select();}, this);
			return null;
		}
		
		if (form.RoleID.selectedIndex == -1)
		{
			Alert(_lang_role_empty);
			return null;
		}
		
		var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&Mobile=' + encodeURIComponent(form.Mobile.value);
		data += '&QQ=' + encodeURIComponent(form.QQ.value);
		data += '&UserName=' + encodeURIComponent(form.User.value);
		data += '&UserID=' + encodeURIComponent($(form.User).data('id'));
		data += '&RoleID=' + encodeURIComponent(form.RoleID.value);
		data += '&WarehouseID=' + encodeURIComponent(form.WarehouseID.value);
		
		return data;
	}

	this.add = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
		
		__base.add({object:__object,data:data});

		return false;
	};

	this.modify = function()
	{
		var data = prepareData(this);
		if (!data)
			return false;
	
		__base.modify({object:__object,data:data});

		return false;
	};

	this.del = function(id)
	{
		__base.update(__object, 'Delete', id, false);
		$('[data-id=' + id + ']').remove();
	};

	this.onUserSelectClick = function()
	{
		__base.showDialog({url:'select_user.aspx?Lang=' + _lang,callback:selectUser});
	};
	
	function selectUser()
	{
		$('[name=User]').val($(this).text()).data('id', $(this).data('id'));
		selectUser.prototype.dialog.close();
		return false;
	}
}
//#endregion 操作员
//-------------------------------------------------

(function()
{
	if (typeof(_page) == 'undefined')
		return;
	
	if (_page == 'warehouse_add')
	{
		var warehouse = new Warehouse();
		
		ali.calendar('[name=OpeningDate]');

		$('form:first').submit(warehouse.add);
		
		//所属地区联动
		$('#region').on('change', 'select', function(){linkage(this, 'ajax_region.aspx');}); 
	}
	else if (_page == 'warehouse_edit')
	{
		var warehouse = new Warehouse();
	
		$('form:first').submit(warehouse.modify);
		
		//所属地区联动
		$('#region').on('change', 'select', function(){linkage(this, 'ajax_region.aspx', warehouse.regionCallback);}); 
		if (_regionLinkageData.id != '')
			linkageSelect(_regionLinkageData);		
	}
	else if (_page == 'warehouse_list')
	{
		var warehouse = new Warehouse();

		MakeButton();

		$('#IsRecycled,#Sort').change(Search);
		$('body').on('click', '#Recycle,#Delete,#Recover', warehouse.update);
		$('#Keyword').keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$('#Search').click(function(){Search(1);});
		$('#SelectAll').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = true;});});
		$('#ReverseSelect').click(function(){$(':checkbox[name=Sel]').each(function(){this.checked = !this.checked;});});
	}
	else if (_page == 'role_add')
	{
		var role = new Role();
		
		$('form:first').submit(role.add);
	}
	else if (_page == 'role_edit')
	{
		var role = new Role();
	
		$('form:first').submit(role.modify);
	}
	else if (_page == 'role_list')
	{
		var role = new Role();

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').data('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)role.del(id);}, this);
			return false;
		});
	}
	else if (_page == 'operator_add')
	{
		var operator = new Operator();
		
		$('form:first').submit(operator.add);
		$('#UserSelect').click(operator.onUserSelectClick);
		$('#ClearUser').click(function(){$('[name=User]').val('').data('id', '');});
	}
	else if (_page == 'operator_edit')
	{
		var operator = new Operator();
	
		$('form:first').submit(operator.modify);
		$('#UserSelect').click(operator.onUserSelectClick);
		$('#ClearUser').click(function(){$('[name=User]').val('').data('id', '');});
	}
	else if (_page == 'operator_list')
	{
		var operator = new Operator();

		$('#List').on('click', 'td:last-child a', function()
		{
			var id = $(this).closest('tr').data('id');
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)operator.del(id);}, this);
			return false;
		});
	}
	else if (_page == 'user_select')
	{
		window.dialogArguments.prototype.dialog = window;
			
		$('#List').on('click', 'td a', window.dialogArguments);
		
		$('#Keyword').keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$('#Search').click(function(){Search(1);});
	}
})();