﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:Get ID="Contract" Object="Contract" InnerID="Request.QueryString['ID']" Validate="True" />
<ali:Get ID="Supplier" Object="Supplier" Guid="Contract[SupplierID]" />
<section data-page="contract_edit" data-title="编辑合同" data-id="<%=Contract[InnerID]%>" data-guid="<%=Contract[ID]%>" data-deliver-freight-type="<%=Contract[DeliverFreightType]%>" data-return-freight-type="<%=Contract[ReturnFreightType]%>">
	<div class="path1"><span>您的位置：</span><a href="list.aspx" target="ali-navtab">合同列表</a> → <b class="<%=ContentLang%>Font"><%=Contract[Name]%></b></div>
	<form action="" class="post">
		<div class="post-body">
			<table class="post-table">
				<tr>
					<th width="140">合同编号：</th>
					<td><input type="text" name="No" value="<%=Contract[No]%>" size="40" maxlength="150" class="ali-input ali-input-required"></td>
				</tr>
				<tr>
					<th>供应商：</th>
					<td><input type="text" name="SupplierName" value="<%=Supplier[Name]%>" size="40" maxlength="50" disabled class="ali-input ali-input-required <%=ContentLang%>Font"><input type="hidden" name="SupplierID" value="<%=Contract[SupplierID]%>"> <a class="ali-button" data-operation="SelectSupplier">选择</a></td>
				</tr>
				<tr>
					<th>名称：</th>
					<td><input type="text" name="Name" value="<%=Contract[Name]%>" size="40" maxlength="150" class="ali-input ali-input-required <%=ContentLang%>Font"></td>
				</tr>
				<tr>
					<th>合同扫描件：</th>
					<td><input type="text" name="File" value="<%=Contract[File]%>" size="55" class="ali-input"><a class="ali-button ali-uploader">浏览...</a></td>
				</tr>
				<tr>
					<th>签订日期：</th>
					<td><input type="text" name="SigningDate" value="<%=(Convert.IsDBNull(Contract[SigningDate])) ? "" : Convert.ToDateTime(Contract[SigningDate]).ToString("yyyy-MM-dd")%>" size="18" maxlength="255" class="ali-input" readonly data-ali-widget="calendar"></td>
				</tr>
				<tr>
					<th>到期日期：</th>
					<td><input type="text" name="ExpirationDate" value="<%=(Convert.IsDBNull(Contract[ExpirationDate])) ? "" : Convert.ToDateTime(Contract[ExpirationDate]).ToString("yyyy-MM-dd")%>" size="18" maxlength="255" class="ali-input" readonly data-ali-widget="calendar"></td>
				</tr>
				<tr>
					<th>发货运费类型：</th>
					<td>
						<select name="DeliverFreightType" data-ali-widget="combo">
							<option value="Seller">卖家承担</option>
							<option value="Collect">运费到付</option>
							<option value="Prepaid">运费预付</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>退货运费类型：</th>
					<td>
						<select name="ReturnFreightType" data-ali-widget="combo">
							<option value="Buyer">买家承担</option>
							<option value="Collect">运费到付</option>
							<option value="Prepaid">运费预付</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>税率：</th>
					<td><input type="text" name="TaxRate" value="<%=Contract[TaxRate]%>" value="0" size="10" maxlength="10" class="ali-input">%</td>
				</tr>
			</table>

			<div class="ali-panel margin3" data-height-style="content">
				<div class="ali-panel-header">商品列表</div>
				<div class="ali-panel-body">
					<a class="ali-button" data-operation="SelectGoods">选择商品</a>
					<table data-ali-widget="grid" class="grid1">
						<thead>
							<tr>
								<th data-name="GoodsName">商品名称</th>
								<th data-name="GoodsSpec">商品规格</th>
								<th width="100" data-name="PurchasePrice">进货价</th>
								<th width="100" data-name="ReturnPrice">退货价</th>
								<th data-name="Memo">备注</th>
								<th width="100" data-name="Operation">删除</th>
							</tr>
						</thead>
						<tbody>
							<ali:List Object="Contract.Goods" Condition="ContractID=Contract[ID]">
								<ali:Record>
									<tr data-id="<%=ID%>" data-goods-no="<%=GoodsNo%>" data-goods-bar-code="<%=GoodsBarCode%>">
										<td><%=GoodsName%></td>
										<td><%=GoodsSpec%></td>
										<td><%=PurchasePrice%></td>
										<td><%=ReturnPrice%></td>
										<td><%=Memo%></td>
										<td><a href="" class="ali-button">删除</a></td>
									</tr>
								</ali:Record>
							</ali:List>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="post-footer"><button type="submit" class="ali-button">保 存</button></div>
	</form>
</section>