﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(AliShop.GoodsModule.Alias.Goods.IsDeleted + "=false");
	string and = "";

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + AliShop.GoodsModule.Alias.Goods.Name + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "No")
			condition.Append(and + "(" + AliShop.GoodsModule.Alias.Goods.No + " LIKE '%" + keyword + "%' OR " + AliShop.GoodsModule.Alias.Goods.Spec + " LIKE '%" + keyword + "%'" + ")");
		else if (Request.QueryString["KeywordType"] == "BarCode")
			condition.Append(and + "(" + AliShop.GoodsModule.Alias.Goods.BarCode + " LIKE '%" + keyword + "%' OR " + AliShop.GoodsModule.Alias.Goods.Spec + " LIKE '%" + keyword + "%'" + ")");
	}
	#endregion
	
	return condition.ToString();
}

protected string GetSpec(object property, object spec)
{
	return "";
}

protected string GetProperty(object property)
{
	return "";
}

protected DataTable SpecList(object spec)
{
	DataTable result = new DataTable();
	result.Columns.Add("NewSpec", typeof(string));

	DataRow row = result.NewRow();
	row["NewSpec"] = "ooo";
	result.Rows.Add(row);
	
	return result;
}
</script>
<section data-page="goods_select" data-title="选择商品">
	<form action="" class="search2">
		<input name="Keyword" class="ali-input ali-input-required <%=ContentLang%>Font">
		<select name="KeywordType" data-ali-widget="combo">
			<option value="Name">商品名称</option>
			<option value="No">商品编码</option>
			<option value="BarCode">商品条码</option>
		</select>
		<button type="submit" class="ali-button">搜索</button>
	</form>
	<div class="content">
		<table data-ali-widget="grid" class="grid1">
			<thead>
				<tr>
					<th data-name="GoodsName">商品名称</th>
					<th data-name="GoodsNo">商品编码</th>
					<th data-name="GoodsBarCode">商品条码</th>
					<th data-name="GoodsSpec">商品规格</th>
					<th data-name="SalePrice">商品价格</th>
					<th data-name="PurchasePrice">进货价格</th>
					<th data-name="ReturnPrice">退货价格</th>
					<th>添加商品</th>
				</tr>
			</thead>
			<tbody>
				<%If !String.IsNullOrEmpty(Request.QueryString["Keyword"])%>
					<ali:List ID="List" Mark="Goods" Object="Goods" Page="PageNumber" PageSize="12" Condition="Condition()">
						<ali:Record>
							<%If Convert.ToString(Spec) == "[]"%>
								<tr>
									<td><%=Name%></td>
									<td><%=No%></td>
									<td><%=BarCode%></td>
									<td><%=GetProperty(Property)%></td>
									<td><%=Convert.ToDecimal(SalePrice).ToString("0.00")%></td>
									<td><input type="text" value="0.00" size="5" class="ali-input"></td>
									<td><input type="text" value="0.00" size="5" class="ali-input"></td>
									<td><a class="ali-button">添加商品</a></td>
								</tr>
							<%Else%>
								<ali:List Source="SpecList(Spec)">
									<ali:Record>
										<tr>
											<td><%=Name%></td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td><input type="text" value="0.00" size="5" class="ali-input"></td>
											<td><input type="text" value="0.00" size="5" class="ali-input"></td>
											<td><a class="ali-button">添加商品</a></td>
										</tr>
									</ali:Record>
								</ali:List>
							<%EndIf%>
						</ali:Record>
					</ali:List>
				<%EndIf%>
			</tbody>
		</table>
		<%If !String.IsNullOrEmpty(Request.QueryString["Keyword"])%>
			<ali:Pagination Page="PageNumber" PageSize="12" RecordCount="List[RecordCount]">
				<div class="pagination1" data-page-number="<%=PageNumber%>" data-page-count="<%=PageCount%>" data-page-size="<%=PageSize%>">
					<ul class="pagination1-right">
						<ali:FirstPage>
							<ali:Yes>
								<li><span><span class="first disabled">首页</span></span></li>
								<li><span><span class="prev disabled">上一页</span></span></li>
							</ali:Yes>
							<ali:No>
								<li><a href="1"><span class="first">首页</span></a></li>
								<li><a href="<%=PageNumber - 1%>"><span class="prev">上一页</span></a></li>
							</ali:No>
						</ali:FirstPage>
						<ali:CurrentPage Range="5">
							<ali:Yes>
								<li class="active"><span><%=Index%></span></li>
							</ali:Yes>
							<ali:No>
								<li><a href="<%=Index%>"><%=Index%></a></li>
							</ali:No>
						</ali:CurrentPage>
						<ali:LastPage>
							<ali:Yes>
								<li><span><span class="next disabled">下一页</span></span></li>
								<li><span><span class="last disabled">末页</span></span></li>
							</ali:Yes>
							<ali:No>
								<li><a href="<%=PageNumber + 1%>"><span class="next">下一页</span></a></li>
								<li><a href="<%=PageCount%>"><span class="last">末页</span></a></li>
							</ali:No>
						</ali:LastPage>
					</ul>
				</div>
			</ali:Pagination>
		<%EndIf%>
	</div>
</section>