﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:List ID="Supplier" Object="Supplier" Condition="BuildConditon()" />
<script language="c#" runat="server">
protected string SupplierName;
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 供应商
	if (!String.IsNullOrEmpty(Request.QueryString["SupplierID"]))
	{
		condition.Append(Alias.Contract.SupplierID + "=" + Request.QueryString["SupplierID"]);
		
		if (Supplier.Rows.Count > 0)
			SupplierName = Supplier.Rows[0][Alias.Supplier.Name].ToString();
	}
	else if (Request.QueryString["KeywordType"] == "SupplierName")
	{
		string ids = "";
		foreach (DataRow row in Supplier.Rows)
		{
			if (!String.IsNullOrEmpty(ids))
				ids = " OR ";

			ids += Alias.Contract.SupplierID + "=" + row[Alias.Supplier.ID];
		}
		
		if (!String.IsNullOrEmpty(ids))
			condition.Append("(" + ids + ")");
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Contract.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Contract.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Contract.UpdateTime + " ASC";
			break;
		default:
			sort = Alias.Contract.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected string BuildConditon()
{
	if (!String.IsNullOrEmpty(Request.QueryString["SupplierID"]))
		return Alias.Supplier.ID + "='" + Request.QueryString["SupplierID"] + "'";
	else// if (Request.QueryString["KeywordType"] == "SupplierName")
		return Alias.Supplier.Name + " LIKE '%" + Request.QueryString["Keyword"] + "%'";
}
</script>
<section data-page="contract_list" data-title="合同列表">
	<div class="path1"><span>您的位置：</span>合同列表</div>
	<form action="" class="search1">
		<select name="Sort" data-ali-widget="combo">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
		</select>
		<input name="Keyword" value="<%=SupplierName%>" class="ali-input <%=ContentLang%>Font">
		<select name="KeywordType" data-ali-widget="combo">
			<option value="Name">合同名称</option>
			<option value="SupplierName">供应商名称</option>
		</select>
		<button type="submit" class="ali-button">搜索</button>
	</form>
	<div class="content">
		<table data-ali-widget="grid" class="grid1">
			<thead>
				<tr>
					<th width="120">合同编号</th>
					<th>合同名称</th>
					<th>供应商名称</th>
					<th width="100">签订日期</th>
					<th width="100">到期日期</th>
					<th width="100">删除</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Contract" Page="PageNumber" PageSize="PageSizeValue" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr data-id="<%=InnerID%>">
							<td><a href="edit.aspx?ID=<%=InnerID%>" target="ali-navtab"><%=No%></a></td>
							<td><a href="edit.aspx?ID=<%=InnerID%>" target="ali-navtab"><%=Name%></a></td>
							<td><%=SupplierName%></td>
							<td>
								<%If !Convert.IsDBNull(SigningDate)%>
									<%=Convert.ToDateTime(SigningDate).ToString("yyyy-MM-dd")%>
								<%EndIf%>
							</td>
							<td>
								<%If !Convert.IsDBNull(ExpirationDate)%>
									<%=Convert.ToDateTime(ExpirationDate).ToString("yyyy-MM-dd")%>
								<%EndIf%>
							</td>
							<td><a class="ali-button" data-operation="Delete">删除</a></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="PageSizeValue" RecordCount="List[RecordCount]">
			<div class="pagination1" data-page-number="<%=PageNumber%>" data-page-count="<%=PageCount%>" data-page-size="<%=PageSize%>">
				<div class="pagination1-left">
					共<b><%=PageCount%></b>页，每页显示
						<select name="PageSize" data-ali-widget="combo">
							<option value="20">20</option>
							<option value="50">50</option>
							<option value="100">100</option>
							<option value="200">200</option>
						</select>条，共<b><%=RecordCount%></b>条记录
				</div>
				<ul class="pagination1-right">
					<ali:FirstPage>
						<ali:Yes>
							<li><span><span class="first disabled">首页</span></span></li>
							<li><span><span class="prev disabled">上一页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="1"><span class="first">首页</span></a></li>
							<li><a href="<%=PageNumber - 1%>"><span class="prev">上一页</span></a></li>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<li class="active"><span><%=Index%></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=Index%>"><%=Index%></a></li>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<li><span><span class="next disabled">下一页</span></span></li>
							<li><span><span class="last disabled">末页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=PageNumber + 1%>"><span class="next">下一页</span></a></li>
							<li><a href="<%=PageCount%>"><span class="last">末页</span></a></li>
						</ali:No>
					</ali:LastPage>

					<li class="go">
						<input type="text" name="PageNumber" value="1" size="4"><button></button>
					</li>
				</ul>
			</div>
		</ali:Pagination>
	</div>
</section>