﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否接单
	string isAccepted = Request.QueryString["IsAccepted"];
	if (!String.IsNullOrEmpty(isAccepted))
		condition.Append(and + Alias.Purchase.IsAccepted + "=" + isAccepted);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否付款
	string isPayed = Request.QueryString["IsPayed"];
	if (!String.IsNullOrEmpty(isPayed))
		condition.Append(and + Alias.Purchase.IsPayed + "=" + isPayed);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否发货
	string isDelivered = Request.QueryString["IsDelivered"];
	if (!String.IsNullOrEmpty(isDelivered))
		condition.Append(and + Alias.Purchase.IsDelivered + "=" + isDelivered);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否完成
	string isFinished = Request.QueryString["IsFinished"];
	if (!String.IsNullOrEmpty(isFinished))
		condition.Append(and + Alias.Purchase.IsFinished + "=" + isFinished);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "No")
			condition.Append(and + Alias.Purchase.No + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "SupplierName")
			condition.Append(and + Alias.Purchase.SupplierName + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Purchase.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.Purchase.CreateTime + " ASC";
			break;
		default:
			sort = Alias.Purchase.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<section data-page="purchase_list" data-title="采购单列表">
	<div class="path1"><span>您的位置：</span>采购单列表</div>
	<form action="" class="search1">
		<select name="IsAccepted" data-ali-widget="combo">
			<option value="">是否接单</option>
			<option value="0">未接单</option>
			<option value="1">已接单</option>
			<option value="2">已拒绝</option>
		</select>
		<select name="IsPayed" data-ali-widget="combo">
			<option value="">是否付款</option>
			<option value="0">未付款</option>
			<option value="2">已付款</option>
			<option value="3">部分退款</option>
			<option value="4">已退款</option>
		</select>
		<select name="IsDelivered" data-ali-widget="combo">
			<option value="">是否发货</option>
			<option value="0">未发货</option>
			<option value="2">已发货</option>
			<option value="3">已收货</option>
			<option value="4">部分退货</option>
			<option value="5">已退货</option>
		</select>
		<select name="IsFinished" data-ali-widget="combo">
			<option value="">是否完成</option>
			<option value="0">未完成</option>
			<option value="1">已完成</option>
			<option value="2">已作废</option>
			<option value="3">已归档</option>
		</select>
		<select name="Sort" data-ali-widget="combo">
			<option value="1">发单日期↓</option>
			<option value="2">发单日期↑</option>
		</select>
		<input name="Keyword" class="ali-input <%=ContentLang%>Font">
		<select name="KeywordType" data-ali-widget="combo">
			<option value="No">采购单号</option>
			<option value="SupplierName">供应商名称</option>
		</select>
		<button type="submit" class="ali-button">搜索</button>
	</form>
	<div class="content">
		<table data-ali-widget="grid" class="grid1">
			<thead>
				<tr>
					<th width="150">采购单号</th>
					<th>供应商</th>
					<th width="150">发单日期</th>
					<th width="100">订单总价</th>
					<th width="200">订单状态</th>
					<th width="200">订单操作</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Purchase" Page="PageNumber" PageSize="PageSizeValue" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr data-id="<%=InnerID%>">
							<td>
								<%If Convert.ToBoolean(IsAccepted)%>
									<a href="view.aspx?ID=<%=InnerID%>" target="ali-navtab"><%=No%></a>
								<%Else%>
									<a href="edit.aspx?ID=<%=InnerID%>" target="ali-navtab"><%=No%></a>
								<%EndIf%>
							</td>
							<td><%=SupplierName%></td>
							<td><%=Convert.ToDateTime(CreateTime).ToString("yyyy-MM-dd")%></td>
							<td><%=Convert.ToDecimal(Sum).ToString("0.00")%></td>
							<td>
								<%If !Convert.ToBoolean(IsAccepted)%>
									未接单
								<%ElseIf Int32.Equals(IsFinished, 1)%>
									已完成
								<%ElseIf Int32.Equals(IsFinished, 2)%>
									已作废
								<%ElseIf Int32.Equals(IsFinished, 3)%>
									已归档
								<%Else%>
									<%If Int32.Equals(IsPayed, 0)%>
										未付款
									<%ElseIf Int32.Equals(IsPayed, 1)%>
										部分付款
									<%ElseIf Int32.Equals(IsPayed, 2)%>
										已付款
									<%ElseIf Int32.Equals(IsPayed, 3)%>
										部分退款
									<%ElseIf Int32.Equals(IsPayed, 4)%>
										已退款
									<%EndIf%>
									，
									<%If Int32.Equals(IsDelivered, 0)%>
										未发货
									<%ElseIf Int32.Equals(IsDelivered, 1)%>
										部分发货
									<%ElseIf Int32.Equals(IsDelivered, 2)%>
										已发货
									<%ElseIf Int32.Equals(IsDelivered, 3)%>
										已收货
									<%ElseIf Int32.Equals(IsDelivered, 4)%>
										部分退货
									<%ElseIf Int32.Equals(IsDelivered, 5)%>
										已退货
									<%EndIf%>
								<%EndIf%>
							</td>
							<td>
								<%If !Convert.ToBoolean(IsAccepted)%>
									<%If !Convert.ToBoolean(IsOnline)%>
										<a data-operation="Accept" class="ali-button">接单</a>
										<a data-operation="ExportToExcel" class="ali-button">导出</a>
									<%EndIf%>
								<%ElseIf Int32.Equals(IsFinished, 0) || Int32.Equals(IsFinished, 1)%>
									<%If Int32.Equals(IsPayed, 0)%>
										<a data-operation="Pay" class="ali-button">付款</a>
									<%ElseIf Int32.Equals(IsPayed, 1)%>
										<!--
										<a data-operation="Pay" class="ali-button">付款</a>
										<a data-operation="Refund" class="ali-button">退款</a>
										-->
									<%ElseIf Int32.Equals(IsPayed, 2)%>
										<a data-operation="Refund" class="ali-button">退款</a>
									<%ElseIf Int32.Equals(IsPayed, 3)%>
										<!--
										<a data-operation="Pay" class="ali-button">付款</a>
										<a data-operation="Refund" class="ali-button">退款</a>
										-->
									<%EndIf%>
									
									<%If Int32.Equals(IsDelivered, 0)%>
										<%If !Convert.ToBoolean(IsOnline)%>
											<a data-operation="Deliver" class="ali-button">发货</a>
										<%EndIf%>
									<%ElseIf Int32.Equals(IsDelivered, 2) || Int32.Equals(IsDelivered, 3)%>
										<!--
										<a data-operation="Return" class="ali-button">退货</a>
										-->
									<%ElseIf Int32.Equals(IsDelivered, 4)%>
										<!--
										<a data-operation="Deliver" class="ali-button">发货</a>
										<a data-operation="Return" class="ali-button">退货</a>
										-->
									<%EndIf%>
								<%EndIf%>
							</td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="PageSizeValue" RecordCount="List[RecordCount]">
			<div class="pagination1" data-page-number="<%=PageNumber%>" data-page-count="<%=PageCount%>" data-page-size="<%=PageSize%>">
				<div class="pagination1-left">
					共<b><%=PageCount%></b>页，每页显示
						<select name="PageSize" data-ali-widget="combo">
							<option value="20">20</option>
							<option value="50">50</option>
							<option value="100">100</option>
							<option value="200">200</option>
						</select>条，共<b><%=RecordCount%></b>条记录
				</div>
				<ul class="pagination1-right">
					<ali:FirstPage>
						<ali:Yes>
							<li><span><span class="first disabled">首页</span></span></li>
							<li><span><span class="prev disabled">上一页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="1"><span class="first">首页</span></a></li>
							<li><a href="<%=PageNumber - 1%>"><span class="prev">上一页</span></a></li>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<li class="active"><span><%=Index%></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=Index%>"><%=Index%></a></li>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<li><span><span class="next disabled">下一页</span></span></li>
							<li><span><span class="last disabled">末页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=PageNumber + 1%>"><span class="next">下一页</span></a></li>
							<li><a href="<%=PageCount%>"><span class="last">末页</span></a></li>
						</ali:No>
					</ali:LastPage>

					<li class="go">
						<input type="text" name="PageNumber" value="1" size="4"><button></button>
					</li>
				</ul>
			</div>
		</ali:Pagination>
	</div>
</section>