﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:Get ID="Purchase" Object="Purchase" InnerID="Request.QueryString['ID']" Validate="True" />
<ali:Get ID="Contract" Object="Contract" Guid="Purchase[ContractID]" />
<ali:Get ID="Replenishment" Object="Replenishment" Guid="Purchase[ReplenishmentID]" />
<section data-page="purchase_view" data-title="查看采购单">
	<div class="path1"><span>您的位置：</span><a href="list.aspx" target="ali-navtab">采购单列表</a> → <b class="<%=ContentLang%>Font"><%=Purchase[No]%></b></div>
	<form action="" class="post">
		<div class="post-body">
			<table class="post-table">
				<tr>
					<th width="140">采购单号：</th>
					<td><%=Purchase[No]%></td>
				</tr>
				<tr>
					<th>供应商：</th>
					<td><%=Purchase[SupplierName]%></td>
				</tr>
				<tr>
					<th>合同：</th>
					<td><%=Contract[Name]%></td>
				</tr>
				<tr>
					<th>仓库：</th>
					<td><%=Purchase[WarehouseName]%></td>
				</tr>
				<tr>
					<th>补货单：</th>
					<td><%=Replenishment[No]%></td>
				</tr>
				<tr>
					<th>流程类型：</th>
					<td>
						<%If Convert.ToBoolean(Purchase[IsOnline])%>
							线上流程
						<%Else%>
							线下流程
						<%EndIf%>
					</td>
				</tr>
			</table>
	
			<div class="ali-panel margin3" data-height-style="content">
				<div class="ali-panel-header">采购单</div>
				<div class="ali-panel-body">
					<table class="purchase-bill">
						<tr>
							<th>供应商：</th><td colspan="5"><%=Purchase[SupplierName]%></td>
						</tr>
						<tr>
							<td colspan="6">
								<table data-ali-widget="grid" class="grid1">
									<thead>
										<tr>
											<th data-name="GoodsName">商品名称</th>
											<th data-name="GoodsSpec">商品规格</th>
											<th data-name="Price" width="60">价格</th>
											<th data-name="Amount" width="60">数量</th>
											<th data-name="Memo" width="120">备注</th>
										</tr>
									</thead>
									<tbody>
										<ali:List Object="Purchase.Detail" Condition="PurchaseID=Purchase[ID]">
											<ali:Record>
												<tr>
													<td><%=GoodsName%>（<%=GoodsNo%>）</td>
													<td><%=GoodsSpec%></td>
													<td><%=Price%></td>
													<td><%=Amount%></td>
													<td><%=Memo%></td>
												</tr>
											</ali:Record>
										</ali:List>
									</tbody>
								</table>
							</td>
						</tr>
						<tr>
							<th width="11%">是否开发票：</th><td width="22%">
								<%If Convert.ToBoolean(Purchase[NeedInvoice])%>
									是
								<%Else%>
									否
								<%EndIf%>
							</td>
							<th width="11%">税率：</th><td width="22%"><%=Purchase[TaxRate]%>%</td>
							<th width="11%">发票抬头：</th><td width="23%"><%=Purchase[InvoiceRise]%></td>
						</tr>
						<tr>
							<td colspan="6">
								<table width="100%">
									<tr>
										<th width="15%">收货人名称：</th><td width="35%"><%=Purchase[ReceiverName]%></td>
										<th width="15%">收货人地址：</th><td width="35%"><%=Purchase[ReceiverAddress]%></td>
									</tr>
									<tr>
										<th>收货人电话：</th><td><%=Purchase[ReceiverPhone]%></td>
										<th>邮政编码：</th><td><%=Purchase[ReceiverZip]%></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<th>运费支付类型：</th>
							<td colspan="2">
								<%If Convert.ToString(Purchase[FreightType]) == "Collect"%>
									运费到付
								<%ElseIf Convert.ToString(Purchase[FreightType]) == "Prepaid"%>
									运费预付
								<%Else%>
									卖家承担
								<%EndIf%>
							</td>
							<th>运费：</th>
							<td colspan="2"><%=Purchase[Freight]%>元</td>
						</tr>
						<tr>
							<th>折扣或涨价：</th><td><%=Purchase[PriceAdjustment]%>元</td>
							<th>订单总价：</th>
							<td colspan="3">
								<%=Convert.ToDecimal(Purchase[Sum]).ToString("0.00")%>
								<%If Convert.ToInt32(Purchase[IsPayed]) >= 3%>
									（已退款金额：<%=Purchase[RefundAmount]%>）
								<%EndIf%>
							</td>
						</tr>
						<tr>
							<th>备注：</th>
							<td colspan="5"><%=Purchase[Memo]%></td>
						</tr>
						<tr>
							<td colspan="6">
								<table width="100%">
									<tr>
										<th width="11%">填单时间：</th><td width="22%"><%=Purchase[CreateTime]%></td>
										<th width="11%">填单人：</th><td width="22%"><%=Purchase[Creator]%></td>
										<th width="11%">审核人：</th><td width="23%"><%=Purchase[Auditor]%></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</div>
			</div>
	
			<div class="ali-panel margin3 margin4" data-height-style="content">
				<div class="ali-panel-header">付款单</div>
				<div class="ali-panel-body">
					<table class="post-table">
						<tr>
							<th>付款状态：</th>
							<td>
								<%If Convert.ToInt32(Purchase[IsPayed]) == 0%>
									未付款
								<%ElseIf Convert.ToInt32(Purchase[IsPayed]) == 1%>
									部分付款
								<%Else%>
									已付款
								<%EndIf%>
							</td>
						</tr>
						<tr>
							<th>付款时间：</th>
							<td><%=Purchase[PayTime]%></td>
						</tr>
						<tr>
							<th>付款备注：</th>
							<td><%=Purchase[PayMemo]%></td>
						</tr>
					</table>
				</div>
			</div>
	
			<div class="ali-panel margin3 margin4" data-height-style="content">
				<div class="ali-panel-header">退款单</div>
				<div class="ali-panel-body">
					<table class="post-table">
						<tr>
							<th>退款状态：</th>
							<td>
								<%If Convert.ToInt32(Purchase[IsPayed]) == 3%>
									部分退款
								<%ElseIf Convert.ToInt32(Purchase[IsPayed]) == 4%>
									已退款
								<%Else%>
									未退款
								<%EndIf%>
							</td>
						</tr>
						<tr>
							<th>退款时间：</th>
							<td><%=Purchase[RefundTime]%></td>
						</tr>
						<tr>
							<th>退款金额：</th>
							<td><%=Purchase[RefundAmount]%></td>
						</tr>
						<tr>
							<th>退款备注：</th>
							<td><%=Purchase[RefundMemo]%></td>
						</tr>
					</table>
				</div>
			</div>
	
			<div class="ali-panel margin3 margin4" data-height-style="content">
				<div class="ali-panel-header">发货单</div>
				<div class="ali-panel-body">
					待做
				</div>
			</div>
	
			<div class="ali-panel margin3 margin4" data-height-style="content">
				<div class="ali-panel-header">退货单</div>
				<div class="ali-panel-body">
					待做
				</div>
			</div>
		</div>
	</form>
</section>