﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:Get ID="Supplier" Object="Supplier" InnerID="Request.QueryString['ID']" Validate="True" />
<section data-page="supplier_edit" data-title="编辑供应商" data-id="<%=Supplier[InnerID]%>" data-region-linkage="({element:'[data-id=region] select:first',index:1,id:'<%=Supplier[RegionID]%>',parentChain:null,parentChainPage:'ajax_parent_chain.aspx?RegionID=<%=Supplier[RegionID]%>'})">
	<div class="path1"><span>您的位置：</span><a href="list.aspx" target="ali-navtab">供应商列表</a> → <b class="<%=ContentLang%>Font"><%=Supplier[Name]%></b></div>
	<form action="" class="post">
		<div class="post-body">
			<div class="ali-tabs margin2" data-event="click">
				<div class="ali-tabs-header">
					<div class="ali-tabs-nav-container">
						<ul>
							<li><a>编辑</a></li>
							<li><a href="addresses/add.aspx?SupplierID=<%=Supplier[ID]%>" target="ali-navtab">添加收货地址</a></li>
							<li><a href="addresses/list.aspx?SupplierID=<%=Supplier[ID]%>" target="ali-navtab">浏览收货地址</a></li>
							<li><a href="payment/add.aspx?SupplierID=<%=Supplier[ID]%>" target="ali-navtab">添加收款账号</a></li>
							<li><a href="payment/list.aspx?SupplierID=<%=Supplier[ID]%>" target="ali-navtab">浏览收款账号</a></li>
						</ul>				
					</div>
				</div>
				<div class="ali-tabs-body">
					<div class="ali-tabs-panel">
						<table class="post-table margin2">
							<tr>
								<th>名称：</th>
								<td><input type="text" name="Name" value="<%=Supplier[Name]%>" size="40" maxlength="255" class="ali-input ali-input-required <%=ContentLang%>Font"></td>
							</tr>
							<tr>
								<th>所属地区：</th>
								<td data-id="region">
									<select class="<%=ContentLang%>Font">
										<option value="" data-inner-id="" data-parent-chain="">-- 未指定 --</option>
										<ali:List Mark="Goods" Object="Region" Condition="ParentID IS NULL">
											<ali:Record>
												<option value="<%=ID%>" data-inner-id="<%=InnerID%>" data-parent-chain="<%=ParentChain%>"><%=Name%></option>
											</ali:Record>
										</ali:List>
									</select>
								</td>
							</tr>
							<tr>
								<th>公司地址：</th>
								<td><input type="text" name="Address" value="<%=Supplier[Address]%>" size="40" maxlength="150" class="ali-input <%=ContentLang%>Font"></td>
							</tr>
							<tr>
								<th>联系电话：</th>
								<td><input type="text" name="Phone" value="<%=Supplier[Phone]%>" size="30" maxlength="50" class="ali-input"></td>
							</tr>
							<tr>
								<th>营业执照：</th>
								<td><input type="text" name="LicenseNumber" value="<%=Supplier[LicenseNumber]%>" size="30" maxlength="20" class="ali-input"></td>
							</tr>
							<tr>
								<th>创立日期：</th>
								<td><input type="text" name="FoundedDate" value="<%=Supplier[FoundedDate]%>" size="18" maxlength="255" class="ali-input" readonly data-ali-widget="calendar"></td>
							</tr>
							<tr>
								<th>公司法人：</th>
								<td><input type="text" name="Owner" value="<%=Supplier[Owner]%>" size="30" maxlength="30" class="ali-input <%=ContentLang%>Font"></td>
							</tr>
							<tr>
								<th>注册资金：</th>
								<td><input type="text" name="RegisteredCapital" value="<%=Supplier[RegisteredCapital]%>" size="10" maxlength="10" class="ali-input"></td>
							</tr>
							<tr>
								<th>主营业务：</th>
								<td><input type="text" name="BusinessScope" value="<%=Supplier[BusinessScope]%>" size="60" maxlength="255" class="ali-input <%=ContentLang%>Font"></td>
							</tr>
							<tr>
								<th>网站地址：</th>
								<td><input type="text" name="Homepage" value="<%=Supplier[Homepage]%>" size="40" maxlength="150" class="ali-input"></td>
							</tr>
							<tr>
								<th>描述：</th>
								<td>
									<textarea name="Description" data-lang="<%=ContentLang%>" data-instance-id="<%=InstanceID%>" class="editor"><%=HttpUtility.HtmlEncode(Supplier[Description].ToString())%></textarea>
								</td>
							</tr>
							<tr>
								<th>绑定用户：</th>
								<td><input type="text" name="UserName" value="<%=Supplier[UserName]%>" size="40" maxlength="50" readonly class="ali-input <%=ContentLang%>Font"><input type="hidden" name="UserID" value="<%=Supplier[UserID]%>"> <a class="ali-button" data-operation="SelectUser">选择</a></td>
							</tr>
						</table>
					</div>
				</div>
				<div class="ali-tabs-bottom"><b></b></div>
			</div>
		</div>
		<div class="post-footer"><button type="submit" class="ali-button">保 存</button></div>
	</form>
</section>