﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:List ID="Regions" Mark="Goods" Object="Region" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Supplier.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Supplier.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Supplier.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Supplier.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Supplier.UpdateTime + " ASC";
			break;
		default:
			sort = Alias.Supplier.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected string BuildRegion(object regionId)
{
	StringBuilder result = new StringBuilder();

	DataRow[] regions = Regions.Select(AliShop.GoodsModule.Alias.Region.ID + "='" + regionId + "'");
	while (regions.Length != 0)
	{
		result.Insert(0, regions[0][AliShop.GoodsModule.Alias.Region.Name]);
		regions = Regions.Select(AliShop.GoodsModule.Alias.Region.ID + "='" + regions[0][AliShop.GoodsModule.Alias.Region.ParentID] + "'");
	}
	
	return result.ToString();
}
</script>
<section data-page="supplier_list" data-title="供应商列表">
	<div class="path1"><span>您的位置：</span>供应商列表</div>
	<form action="" class="search1">
		<select name="IsRecycled" data-ali-widget="combo">
			<option value="">是否回收</option>
			<option value="false" selected="selected">未回收</option>
			<option value="true">已回收</option>
		</select>
		<select name="Sort" data-ali-widget="combo">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
		</select>
		<input name="Keyword" class="ali-input <%=ContentLang%>Font">
		<select name="KeywordType" data-ali-widget="combo">
			<option value="Name">名称</option>
		</select>
		<button type="submit" class="ali-button">搜索</button>
	</form>
	<ul class="toolbar1">
		<li class="select-all"><a><span>全选</span></a></li>
		<li class="select-reverse"><a><span>反选</span></a></li>

		<%If Manager.HasRight(null, InstanceID, ContentLang, "Supplier", "Recycle")%>
			<li class="recycle" data-operation="Recycle"><a><span>回收</span></a></li>
		<%EndIf%>
		<%If Manager.HasRight(null, InstanceID, ContentLang, "Supplier", "Recover")%>
			<li class="recover" data-operation="Recover"><a><span>还原</span></a></li>
		<%EndIf%>
		<%If Manager.HasRight(null, InstanceID, ContentLang, "Supplier", "Delete")%>
			<li class="delete" data-operation="Delete"><a><span>删除</span></a></li>
		<%EndIf%>
	</ul>
	<div class="content">
		<table data-ali-widget="grid" class="grid1">
			<thead>
				<tr>
					<th>名称</th>
					<th width="120">联系电话</th>
					<th>公司地址</th>
					<th>主营业务</th>
					<th width="100">添加收货地址</th>
					<th width="100">浏览收货地址</th>
					<th width="100">添加收款账号</th>
					<th width="100">浏览收款账号</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Supplier" Page="PageNumber" PageSize="PageSizeValue" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr data-id="<%=InnerID%>">
							<td><a href="edit.aspx?ID=<%=InnerID%>" target="ali-navtab"><%=Name%></a></td>
							<td><%=Phone%></td>
							<td><%=BuildRegion(RegionID)%><%=Address%></td>
							<td><%=BusinessScope%></td>
							<td><a href="addresses/add.aspx?SupplierID=<%=ID%>" target="ali-navtab">添加收货地址</a></td>
							<td><a href="addresses/list.aspx?SupplierID=<%=ID%>" target="ali-navtab">浏览收货地址</a></td>
							<td><a href="payment/add.aspx?SupplierID=<%=ID%>" target="ali-navtab">添加收款账号</a></td>
							<td><a href="payment/list.aspx?SupplierID=<%=ID%>" target="ali-navtab">浏览收款账号</a></td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="PageSizeValue" RecordCount="List[RecordCount]">
			<div class="pagination1" data-page-number="<%=PageNumber%>" data-page-count="<%=PageCount%>" data-page-size="<%=PageSize%>">
				<div class="pagination1-left">
					共<b><%=PageCount%></b>页，每页显示
						<select name="PageSize" data-ali-widget="combo">
							<option value="20">20</option>
							<option value="50">50</option>
							<option value="100">100</option>
							<option value="200">200</option>
						</select>条，共<b><%=RecordCount%></b>条记录
				</div>
				<ul class="pagination1-right">
					<ali:FirstPage>
						<ali:Yes>
							<li><span><span class="first disabled">首页</span></span></li>
							<li><span><span class="prev disabled">上一页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="1"><span class="first">首页</span></a></li>
							<li><a href="<%=PageNumber - 1%>"><span class="prev">上一页</span></a></li>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<li class="active"><span><%=Index%></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=Index%>"><%=Index%></a></li>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<li><span><span class="next disabled">下一页</span></span></li>
							<li><span><span class="last disabled">末页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=PageNumber + 1%>"><span class="next">下一页</span></a></li>
							<li><a href="<%=PageCount%>"><span class="last">末页</span></a></li>
						</ali:No>
					</ali:LastPage>

					<li class="go">
						<input type="text" name="PageNumber" value="1" size="4"><button></button>
					</li>
				</ul>
			</div>
		</ali:Pagination>
	</div>
</section>