﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<section data-page="supplier_select" data-title="选择供应商">
	<form action="" class="search2">
		<input name="Keyword" class="ali-input ali-input-required <%=ContentLang%>Font">
		<select name="KeywordType" data-ali-widget="combo">
			<option value="Name">名称</option>
		</select>
		<button type="submit" class="ali-button">搜索</button>
	</form>
	<div class="content">
		<table data-ali-widget="grid" class="grid1">
			<thead>
				<tr>
					<th>名称</th>
				</tr>
			</thead>
			<tbody>
				<%If !String.IsNullOrEmpty(Request.QueryString["Keyword"])%>
					<ali:List ID="List" Object="Supplier" Page="PageNumber" PageSize="3" Condition="Name LIKE '%' + Request.QueryString['Keyword'] + '%'">
						<ali:Record>
							<tr>
								<td><a href="" data-id="<%=ID%>"><%=Name%></a></td>
							</tr>
						</ali:Record>
					</ali:List>
				<%EndIf%>
			</tbody>
		</table>
		<%If !String.IsNullOrEmpty(Request.QueryString["Keyword"])%>
			<ali:Pagination Page="PageNumber" PageSize="3" RecordCount="List[RecordCount]">
				<div class="pagination1" data-page-number="<%=PageNumber%>" data-page-count="<%=PageCount%>" data-page-size="<%=PageSize%>">
					<ul class="pagination1-right">
						<ali:FirstPage>
							<ali:Yes>
								<li><span><span class="first disabled">首页</span></span></li>
								<li><span><span class="prev disabled">上一页</span></span></li>
							</ali:Yes>
							<ali:No>
								<li><a href="1"><span class="first">首页</span></a></li>
								<li><a href="<%=PageNumber - 1%>"><span class="prev">上一页</span></a></li>
							</ali:No>
						</ali:FirstPage>
						<ali:CurrentPage Range="5">
							<ali:Yes>
								<li class="active"><span><%=Index%></span></li>
							</ali:Yes>
							<ali:No>
								<li><a href="<%=Index%>"><%=Index%></a></li>
							</ali:No>
						</ali:CurrentPage>
						<ali:LastPage>
							<ali:Yes>
								<li><span><span class="next disabled">下一页</span></span></li>
								<li><span><span class="last disabled">末页</span></span></li>
							</ali:Yes>
							<ali:No>
								<li><a href="<%=PageNumber + 1%>"><span class="next">下一页</span></a></li>
								<li><a href="<%=PageCount%>"><span class="last">末页</span></a></li>
							</ali:No>
						</ali:LastPage>
					</ul>
				</div>
			</ali:Pagination>
		<%EndIf%>
	</div>
</section>