﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Stock.ShopID + "=" + Manager.User["ShopID"]);
	string and = String.Empty;

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
		condition.Append(and + Alias.Stock.CategoryID + "=" + categoryID);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "GoodsName")
			condition.Append(and + Alias.Stock.GoodsName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "GoodsNo")
			condition.Append(and + Alias.Stock.GoodsNo + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "GoodsBarCode")
			condition.Append(and + Alias.Stock.GoodsBarCode + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "SupplierName")
			condition.Append(and + Alias.Stock.SupplierName + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Stock.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Stock.InnerID + " ASC";
			break;
		default:
			sort = Alias.Stock.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<section data-page="stock_list" data-title="库存列表">
	<div class="path1"><span>您的位置：</span>库存列表</div>
	<form action="" class="search1">
		<select name="CategoryID" class="<%=ContentLang%>Font" data-ali-widget="combo" data-tree="true" data-root="0">
			<option value="" data-item="" data-parent="0">所有类别</option>
			<ali:Tree Mark="Goods" Object="GoodsCategory">
				<ali:Record>
					<option value="<%=ID%>" data-item="<%=ParentChain%>.<%=InnerID%>" data-parent="<%=ParentChain%>"><%=Name%></option>
					<%=ChildRecords%>
				</ali:Record>
			</ali:Tree>
		</select>
		<select name="Sort" data-ali-widget="combo">
			<option value="1">序号↓</option>
			<option value="2">序号↑</option>
			<option value="3">过期日期↓</option>
			<option value="4">过期日期↑</option>
		</select>
		<input name="Keyword" class="ali-input <%=ContentLang%>Font">
		<select name="KeywordType" data-ali-widget="combo">
			<option value="GoodsName">名称</option>
			<option value="GoodsNo">货号</option>
			<option value="GoodsBarCode">条码</option>
			<option value="SupplierName">供应商</option>
		</select>
		<button type="submit" class="ali-button">搜索</button>
	</form>
	<div class="content">
		<table data-ali-widget="grid" class="grid1">
			<thead>
				<tr>
					<th>商品名称</th>
					<th width="100">商品编号</th>
					<th width="100">商品条码</th>
					<th>商品规格</th>
					<th width="200">供应商</th>
					<th width="100">商品类别</th>
					<th width="100">平均价格</th>
					<th width="100">数量</th>
					<th width="100">过期日期</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="Stock" Page="PageNumber" PageSize="PageSizeValue" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr data-id="<%=InnerID%>">
							<td><%=GoodsName%></td>
							<td><%=GoodsNo%></td>
							<td><%=GoodsBarCode%></td>
							<td><%=GoodsSpec%></td>
							<td><%=SupplierName%></td>
							<td><%=CategoryName%></td>
							<td><%=Price%></td>
							<td><%=Amount%></td>
							<td>
								<%If !Convert.IsDBNull(ExpiredTime)%>
									<%=Convert.ToDateTime(ExpiredTime).ToString("yyyy-MM-dd")%>
								<%EndIf%>
							</td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="PageSizeValue" RecordCount="List[RecordCount]">
			<div class="pagination1" data-page-number="<%=PageNumber%>" data-page-count="<%=PageCount%>" data-page-size="<%=PageSize%>">
				<div class="pagination1-left">
					共<b><%=PageCount%></b>页，每页显示
						<select name="PageSize" data-ali-widget="combo">
							<option value="20">20</option>
							<option value="50">50</option>
							<option value="100">100</option>
							<option value="200">200</option>
						</select>条，共<b><%=RecordCount%></b>条记录
				</div>
				<ul class="pagination1-right">
					<ali:FirstPage>
						<ali:Yes>
							<li><span><span class="first disabled">首页</span></span></li>
							<li><span><span class="prev disabled">上一页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="1"><span class="first">首页</span></a></li>
							<li><a href="<%=PageNumber - 1%>"><span class="prev">上一页</span></a></li>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<li class="active"><span><%=Index%></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=Index%>"><%=Index%></a></li>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<li><span><span class="next disabled">下一页</span></span></li>
							<li><span><span class="last disabled">末页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=PageNumber + 1%>"><span class="next">下一页</span></a></li>
							<li><a href="<%=PageCount%>"><span class="last">末页</span></a></li>
						</ali:No>
					</ali:LastPage>

					<li class="go">
						<input type="text" name="PageNumber" value="1" size="4"><button></button>
					</li>
				</ul>
			</div>
		</ali:Pagination>
	</div>
</section>