(function()
{
	//-------------------------------------------------
	//#region 获取模板路径，并加到helper中
	var __p = $('script:last').attr('src');
	__p = __p.substr(0, __p.lastIndexOf('/js/module.js') + 1);
	_helper.addInit(__p, init);
	//#endregion 获取模板路径，并加到helper中
	//-------------------------------------------------
	
	//-------------------------------------------------
	//#region 辅助函数
	//词典中，获取关键字对应的值
	function w(k){return _helper.dict(__p, k);}
	//获取对象名称
	function o(f){return f.toString().match(/^function (\w+)\(/)[1];}
	//获取页面变量值
	function v(p, n){return $('>section', p).data(n);}
	//#endregion 辅助函数
	//-------------------------------------------------

	//-------------------------------------------------
	//#region 初始化
	function init(instance, page, panel)
	{
		if (page == 'stock_out_list')
		{
			//创建对象
			var stockOut = new StockOut(instance, panel);

			//#region 绑定事件
			panel.on('click', '[data-operation=ConfirmReceive]', stockOut.onConfirmReceiveClick)
				.on('submit', '[data-page=confirm_receive] form:first', stockOut.onConfirmReceiveSubmit)
				.on('submit', '[data-page=stock_in_from_stock_out] form:first', stockOut.onStockInFromStockOutSubmit);
			//#endregion
		}
	}
	//#endregion 初始化
	//-------------------------------------------------

	//-------------------------------------------------
	//#region 出库单
	function StockOut(instance, panel)
	{
		var __object = o(arguments.callee);

		this.onConfirmReceiveClick = function()
		{
			ali.dialog({name:'ConfirmReceive',modal:true,appendTo:panel,width:500,height:200,resizable:false,url:_helper.toAbsPanel(panel, 'confirm_receive.aspx?StockOutID=' + $(this).closest('tr').data('id')),onBeforeLoad:_helper.onDialogBeforeLoad,onShow:_helper.onDialogShow});
			return false;
		};
		
		this.onConfirmReceiveSubmit = function()
		{
			var data = _helper.serialize(this),
				stockOutId = $(this).data('stockOutId');

			//提交数据
			_helper.post({instance:instance,object:__object,operation:'ConfirmReceive',data:data,params:'ID=' + stockOutId,silent:true});

			//关闭对话框
			ali.dialog($(this).closest('.ali-dialog-body').children(), 'close');
			
			//弹出进货单对话框
			ali.dialog({name:'StockInFromStockOut',modal:true,appendTo:panel,width:800,height:400,resizable:false,url:_helper.toAbsPanel(panel, 'stock_in_from_stock_out.aspx?StockOutID=' + stockOutId),onBeforeLoad:_helper.onDialogBeforeLoad,onShow:_helper.onDialogShow});

			return false;
		};
		
		this.onStockInFromStockOutSubmit = function()
		{
			var grid = $('.ali-grid', this).prev();
			
			//获取所有行
			var rows = ali.grid(grid, 'getRows');

			//准备编号
			var nos = '';
			for (var i = 0; i < rows.length; i++)
			{
				if (i > 0)
					nos += '|';
				nos += rows[i].goodsNo;
			}
			
			//获取商品其他属性
			var moreProps = null;
			$.ajax(
			{
				type: 'GET',
				dataType: 'json',
				url: _helper.toAbsPanel(panel, 'ajax_goods.aspx?Nos=' + nos),
				async: false,
				success: function(data)
				{
					moreProps = data;
				}
			});
			
			//补充属性
			for (var i = 0; i < rows.length; i++)
			{
				for (var j = 0; j < moreProps.length; j++)
				{
					if (rows[i].goodsNo == moreProps[j].no || moreProps[j].spec.indexOf(rows[i].goodNo) != -1)
					{
						rows[i].categoryName = moreProps[j].categoryName;
						rows[i].categoryId = moreProps[j].categoryId;
						rows[i].categoryParentChain = moreProps[j].categoryParentChain;
						rows[i].supplierName = moreProps[j].supplierName;
						rows[i].supplierId = moreProps[j].supplierId;
						break;
					}
				}
			}

			//准备数据
			var data = 'No=' + $(this).data('stockInNo');
			data += '&ShopID=' + $(this).data('shopId');
			data += '&StockOutID=' + $(this).data('stockOutGuid');
			data += '&StockOutNo=' + $(this).data('stockOutNo');
			data += '&Memo=' + encodeURIComponent(this.Memo.value);

			//提交进货单数据
			var stockInId = _helper.post({mark:'Shop',object:'StockIn',operation:'Add',data:data,silent:true});
			
			//#region 提交进货单商品
			for (var i = 0; i < rows.length; i++)
			{
				//准备数据
				data = 'StockInID=' + stockInId;
				data += '&GoodsName=' + encodeURIComponent(rows[i].goodsName);
				data += '&GoodsNo=' + rows[i].goodsNo;
				data += '&GoodsBarCode=' + rows[i].goodsBarCode;
				data += '&GoodsSpec=' + encodeURIComponent(rows[i].goodsSpec);
				data += '&Price=' + encodeURIComponent(rows[i].price);
				data += '&Amount=' + encodeURIComponent(rows[i].amount);
				data += '&Memo=' + encodeURIComponent(rows[i].memo);
				
				//提交数据
				_helper.post({mark:'Shop',object:'StockIn.Detail',operation:'Add',data:data,silent:true});
				
				//#region 提交库存数据
				
				//准备数据
				data = 'ShopID=' + $(this).data('shopId');
				data += '&GoodsName=' + encodeURIComponent(rows[i].goodsName);
				data += '&GoodsNo=' + rows[i].goodsNo;
				data += '&GoodsBarCode=' + rows[i].goodsBarCode;
				data += '&GoodsSpec=' + encodeURIComponent(rows[i].goodsSpec);
				data += '&SupplierName=' + encodeURIComponent(rows[i].supplierName);
				data += '&SupplierID=' + rows[i].supplierId;
				data += '&CategoryName=' + encodeURIComponent(rows[i].categoryName);
				data += '&CategoryID=' + rows[i].categoryId;
				data += '&CategoryParentChain=' + rows[i].categoryParentChain;
				data += '&Price=' + encodeURIComponent(rows[i].price);
				data += '&Amount=' + encodeURIComponent(rows[i].amount);
				data += '&ExpiredTime=' + encodeURIComponent(rows[i].expiredTime);
				
				//提交数据
				_helper.post({mark:'Shop',object:'Stock',operation:'Add',data:data,silent:true});
				
				//#endregion
			}
			//#endregion
			
			ali.success(_lang_operation_success);

			//刷新列表
			$('.search1', panel).submit();

			//关闭对话框
			ali.dialog($(this).closest('.ali-dialog-body').children(), 'close');
			
			return false;
		};
	}
	//#endregion 出库单
	//-------------------------------------------------
})();
////@ sourceURL=AliShop.WarehouseModule.js