﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(AliShop.WarehouseModule.Alias.StockOut.ToID + "=" + Manager.User["ShopID"]);
	string and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "No")
			condition.Append(and + Alias.StockOut.No + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.StockOut.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.StockOut.CreateTime + " ASC";
			break;
		default:
			sort = Alias.StockOut.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<section data-page="stock_out_list" data-title="出库单列表">
	<div class="path1"><span>您的位置：</span>出库单列表</div>
	<form action="" class="search1">
		<select name="Sort" data-ali-widget="combo">
			<option value="1">发单日期↓</option>
			<option value="2">发单日期↑</option>
		</select>
		<input name="Keyword" class="ali-input <%=ContentLang%>Font">
		<select name="KeywordType" data-ali-widget="combo">
			<option value="No">出库单号</option>
		</select>
		<button type="submit" class="ali-button">搜索</button>
	</form>
	<div class="content">
		<table data-ali-widget="grid" class="grid1">
			<thead>
				<tr>
					<th width="150">出库单号</th>
					<th width="150">发单日期</th>
					<th>目标名称</th>
					<th width="100">目标编号</th>
					<th width="100">目标类型</th>
					<th width="200">订单状态</th>
					<th width="200">订单操作</th>
				</tr>
			</thead>
			<tbody>
				<ali:List ID="List" Object="StockOut" Page="PageNumber" PageSize="PageSizeValue" Condition="Condition()" Sort="Sort()" Validate="True">
					<ali:Record>
						<tr data-id="<%=InnerID%>">
							<td><%=No%></td>
							<td><%=Convert.ToDateTime(CreateTime).ToString("yyyy-MM-dd")%></td>
							<td><%=ToName%></td>
							<td><%=ToNo%></td>
							<td><%=ToType%></td>
							<td>
								<%If Int32.Equals(IsDelivered, 0)%>
									未发货
								<%ElseIf Int32.Equals(IsDelivered, 1)%>
									部分发货
								<%ElseIf Int32.Equals(IsDelivered, 2)%>
									已发货
								<%ElseIf Int32.Equals(IsDelivered, 3)%>
									已收货
								<%ElseIf Int32.Equals(IsDelivered, 4)%>
									部分退货
								<%ElseIf Int32.Equals(IsDelivered, 5)%>
									已退货
								<%EndIf%>
							</td>
							<td>
								<%If Int32.Equals(IsDelivered, 2)%>
									<a data-operation="ConfirmReceive" class="ali-button">确认收货</a>
								<%EndIf%>
							</td>
						</tr>
					</ali:Record>
				</ali:List>
			</tbody>
		</table>
		<ali:Pagination Page="PageNumber" PageSize="PageSizeValue" RecordCount="List[RecordCount]">
			<div class="pagination1" data-page-number="<%=PageNumber%>" data-page-count="<%=PageCount%>" data-page-size="<%=PageSize%>">
				<div class="pagination1-left">
					共<b><%=PageCount%></b>页，每页显示
						<select name="PageSize" data-ali-widget="combo">
							<option value="20">20</option>
							<option value="50">50</option>
							<option value="100">100</option>
							<option value="200">200</option>
						</select>条，共<b><%=RecordCount%></b>条记录
				</div>
				<ul class="pagination1-right">
					<ali:FirstPage>
						<ali:Yes>
							<li><span><span class="first disabled">首页</span></span></li>
							<li><span><span class="prev disabled">上一页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="1"><span class="first">首页</span></a></li>
							<li><a href="<%=PageNumber - 1%>"><span class="prev">上一页</span></a></li>
						</ali:No>
					</ali:FirstPage>
					<ali:CurrentPage Range="5">
						<ali:Yes>
							<li class="active"><span><%=Index%></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=Index%>"><%=Index%></a></li>
						</ali:No>
					</ali:CurrentPage>
					<ali:LastPage>
						<ali:Yes>
							<li><span><span class="next disabled">下一页</span></span></li>
							<li><span><span class="last disabled">末页</span></span></li>
						</ali:Yes>
						<ali:No>
							<li><a href="<%=PageNumber + 1%>"><span class="next">下一页</span></a></li>
							<li><a href="<%=PageCount%>"><span class="last">末页</span></a></li>
						</ali:No>
					</ali:LastPage>

					<li class="go">
						<input type="text" name="PageNumber" value="1" size="4"><button></button>
					</li>
				</ul>
			</div>
		</ali:Pagination>
	</div>
</section>