(function()
{
	//-------------------------------------------------
	//Start: 获取模板路径，并加到helper中
	var __p = $('script:last').attr('src');
	__p = __p.substr(0, __p.lastIndexOf('/js/module.js') + 1);
	_helper.addInit(__p, init);
	//End: 获取模板路径，并加到helper中
	//-------------------------------------------------
	
	//-------------------------------------------------
	//Start: 辅助函数
	//词典中，获取关键字对应的值
	function w(k){return _helper.dict(__p, k);}
	//获取对象名称
	function o(f){return f.toString().match(/^function (\w+)\(/)[1];}
	//获取页面变量值
	function v(p, n){return $('>section', p).data(n);}
	//End: 辅助函数
	//-------------------------------------------------
	
	//-------------------------------------------------
	//Start: 初始化
	function init(instance, page, panel)
	{
		if (page == 'department_list')
		{
			var department = new Department(instance, panel);

			//绑定事件
			ali.grid($('[data-ali-widget=grid]', panel), 'option', 'onMove', department.move);
			$('.ali-button', panel).click(department.del);
		}
		else if (page == 'department_add')
		{
			var department = new Department(instance, panel);
			
			//绑定事件
			$('form:first', panel).submit(department.add);
		}
		else if (page == 'department_edit')
		{
			var department = new Department(instance, panel);

			//绑定事件
			$('form:first', panel).submit(department.modify);
		}
		else if (page == 'staff_list')
		{
			var staff = new Staff(instance, panel);

			//绑定事件
			$('.recycle,.delete,.recover', panel).click(staff.update);
		}
		else if (page == 'staff_add')
		{
			var staff = new Staff(instance, panel);

			//绑定事件
			$('form:first', panel).submit(staff.add);
		}
		else if (page == 'staff_edit')
		{
			//绑定事件
			var staff = new Staff(instance, panel);
			
			//绑定事件
			$('form:first', panel).submit(staff.modify);
		}
	}
	//End: 初始化
	//-------------------------------------------------

	//-------------------------------------------------
	//Start: 部门
	function Department(instance, panel)
	{
		var __object = o(arguments.callee);

		this.add = function()
		{
			var data = prepareData(this);
			if (data == null)
				return false;

			_helper.post({instance:instance,object:__object,operation:'Add',data:data});

			return false;
		};

		this.modify = function()
		{
			var data = prepareData(this);
			if (data == null)
				return false;

			_helper.post({instance:instance,object:__object,operation:'Modify',data:data,params:'ID=' + v(panel, 'id')});

			return false;
		};
		
		this.move = function(element, from, to)
		{
			_helper.post({instance:instance,object:__object,operation:'Move',params:'From=' + from + '&To=' + to});
		};

		this.del = function()
		{
			ali.confirm(_lang_confirm_delete, $.proxy(function(returnValue)
			{
				if (returnValue)
				{
					//服务器中删除
					_helper.post({instance:instance,object:__object,operation:'Delete',params:'ID=' + $(this).closest('tr').data('id')});
					
					//客户端中删除
					ali.grid($('[data-ali-widget=grid]', panel), 'deleteRow', $(this).closest('tr')[0].rowIndex);
				}
			}, this));
		};
		
		function prepareData(form)
		{
			if ($.trim(form.Name.value) == '')
			{
				ali.error(w('name_empty'), $.proxy(function(){form.Name.select();}, form));
				return null;
			}
			
			var data = 'ParentID=' + encodeURIComponent(form.ParentID.value);
			data += '&Name=' + encodeURIComponent(form.Name.value);
			
			return data;
		}
	}
	//End: 部门
	//-------------------------------------------------

	//-------------------------------------------------
	//Start: 员工
	function Staff(instance, panel)
	{
		var __object = o(arguments.callee),
			__uploadHead,
			__uploadResume;

		this.add = function()
		{
			var data = prepareData(this);
			if (data == null)
				return false;

			var guid = _helper.post({instance:instance,object:__object,operation:'Add',data:data,silent:true});
			if (guid)
			{
				var id = _helper.post({instance:instance,object:__object,operation:'GetInnerIDFromGuid',data:data,params:'ID=' + guid,silent:true});
				
				uploadHead(id);
			}

			return false;
		};
		
		this.modify = function()
		{
			var data = prepareData(this);
			if (data == null)
				return false;

			var id = v(panel, 'id');
			var result = _helper.post({instance:instance,object:__object,operation:'Modify',data:data,params:'ID=' + id,silent:true});
			if (result != null)
				uploadHead(id);
			return false;
		};

		this.update = function()
		{
			_helper.update(instance, __object, this);
		};
		
		function prepareData(form)
		{
			if ($.trim(form.Name.value) == '')
			{
				ali.error(w('staff_name_empty'), $.proxy(function(){form.Name.select();}, this));
				return null;
			}
	
			if (!_helper.isAllowedType(form.Head.value, form.PictureAllowedType.value))
			{
				Alert(_lang_picture_type_must_be + form.PictureAllowedType.value, function(){form.Head.select();}, this);
				return null;
			}
			
			if (form.IDCardNo.value != '' && form.IDCardNo.value.length != 18)
			{
				ali.error(w('idcardno_incorrect'), $.proxy(function(){form.IDCardNo.select();}, this));
				return null;
			}
	
			if (form.Mobile.value != '' && !form.Mobile.value.match(/^\d{11}$/))
			{
				ali.error(w('mobile_incorrect'), $.proxy(function(){form.Mobile.select();}, this));
				return false;
			}
	
			if (form.QQ.value != '' && !form.QQ.value.match(/^\d+$/))
			{
				ali.error(w('qq_incorrect'), $.proxy(function(){form.QQ.select();}, this));
				return false;
			}
			
			if (form.Email.value != '' && !form.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
			{
				ali.error(w('email_incorrect'), $.proxy(function(){form.Email.select();}, this));
				return false;
			}
		
			var data = 'Name=' + encodeURIComponent(form.Name.value);
			data += '&DepartmentID=' + encodeURIComponent(form.DepartmentID.value);
			data += '&IDCardNo=' + encodeURIComponent(form.IDCardNo.value);
			data += '&Sex=' + encodeURIComponent($('[name=Sex]:checked').val());
			data += '&Birthday=' + encodeURIComponent(form.Birthday.value);
			data += '&NationID=' + encodeURIComponent(form.NationID.value);
			data += '&Origin=' + encodeURIComponent(form.Origin.value);
			data += '&IsMarried=' + encodeURIComponent($('[name=IsMarried]:checked').val());
			data += '&PartyID=' + encodeURIComponent(form.PartyID.value);
			data += '&DegreeID=' + encodeURIComponent(form.DegreeID.value);
			data += '&School=' + encodeURIComponent(form.School.value);
			data += '&Major=' + encodeURIComponent(form.Major.value);
			data += '&GraduationDate=' + encodeURIComponent(form.GraduationDate.value);
			data += '&JoinDate=' + encodeURIComponent(form.JoinDate.value);
			data += '&ContractDate=' + encodeURIComponent(form.ContractDate.value);
			data += '&IsActive=' + encodeURIComponent($('[name=IsActive]:checked').val());
			data += '&DimissionDate=' + encodeURIComponent(form.DimissionDate.value);
			data += '&Address=' + encodeURIComponent(form.Address.value);
			data += '&Mobile=' + encodeURIComponent(form.Mobile.value);
			data += '&QQ=' + encodeURIComponent(form.QQ.value);
			data += '&Email=' + encodeURIComponent(form.Email.value);
			
			data += '&Profile=' + encodeURIComponent(CKEDITOR.instances[form.Profile.id].getData());
			//data += '&Profile=' + encodeURIComponent(UE.getEditor(form.Profile).getContent());
			
			__uploadHead = ali.uploader($('[name=Head]', panel).next(), 'needUpload');
			if (!__uploadHead)
				data += '&Head=' + encodeURIComponent(form.Head.value);
		
			__uploadResume = ali.uploader($('[name=Resume]', panel).next(), 'needUpload');
			if (!__uploadResume)
				data += '&Resume=' + encodeURIComponent(form.Resume.value);
			
			return data;
		}
		
		function uploadHead(id)
		{
			if (!__uploadHead)
			{
				uploadResume(id);
				return;
			}
		
			ali.uploader($('[name=Head]', panel).next(), 'upload', {status:w('uploading_head'),params:'Instance=' + instance + '&Lang=' + _lang + '&Object=' + __object + '&Operation=UploadHead&ID=' + id,onComplete:function()
			{
				if (arguments[0] != 0)
				{
					ali.error(arguments[1]);
					ali.working();
				}
				else
				{
					$('[name=Head]').val(arguments[1]);
					uploadResume(id);
				}
			}});
		}
		
		function uploadResume(id)
		{
			if (!__uploadResume)
			{
				ali.success(_lang_operation_success);
				ali.working();
				return;
			}
		
			ali.uploader($('[name=Resume]', panel).next(), 'upload', {status:w('uploading_resume'),params:'Instance=' + instance + '&Lang=' + _lang + '&Object=Staff&Operation=UploadResume&ID=' + id,onComplete:function()
			{
				if (arguments[0] != 0)
				{
					ali.error(arguments[1]);
				}
				else
				{
					$('[name=Resume]').val(arguments[1]);
					ali.success(_lang_operation_success);
				}
				ali.working();
			}});
		}
	}
	//End: 员工
	//-------------------------------------------------
})();
////@ sourceURL=AliShop.StaffModule.js