﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:Get ID="Staff" Object="Staff" InnerID="Request.QueryString['ID']" Validate="True" />
<section data-page="staff_edit" data-title="编辑员工" data-id="<%=Staff[InnerID]%>">
	<div class="path1"><span>您的位置：</span><a href="list.aspx" target="ali-navtab">员工列表</a> → <b class="<%=ContentLang%>Font"><%=Staff[Name]%></b></div>
	<form action="" class="post">
		<div class="post-body">
			<table class="post-table">
				<tr>
					<th>姓名：</th>
					<td><input type="text" name="Name" value="<%=Staff[Name]%>" size="40" maxlength="255" class="ali-input ali-input-required <%=ContentLang%>Font"></td>
				</tr>
				<tr>
					<th>部门：</th>
					<td>
						<select name="DepartmentID" class="<%=ContentLang%>Font" data-ali-widget="combo" data-tree="true" data-root="0">
							<option value="" data-item="" data-parent="0">未指定</option>
							<ali:Tree Object="Department">
								<ali:Record>
									<%If Guid.Equals(ID, Staff[DepartmentID])%>
										<option value="<%=ID%>" data-item="<%=ParentChain%>.<%=InnerID%>" data-parent="<%=ParentChain%>" selected><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>" data-item="<%=ParentChain%>.<%=InnerID%>" data-parent="<%=ParentChain%>"><%=Name%></option>
									<%EndIf%>
									<%=ChildRecords%>
								</ali:Record>
							</ali:Tree>
						</select>
					</td>
				</tr>
				<tr>
					<th>头像：</th>
					<td><input type="text" name="Head" value="<%=Staff[Head]%>" size="55" class="ali-input"><a class="ali-button ali-uploader">浏览...</a></td>
				</tr>
				<tr>
					<th>身份证：</th>
					<td><input type="text" name="IDCardNo" value="<%=Staff[IDCardNo]%>" size="18" maxlength="255" class="ali-input <%=ContentLang%>Font"></td>
				</tr>
				<tr>
					<th>性别：</th>
					<td>
						<%If Convert.ToBoolean(Staff[Sex])%>
							<label><input type="radio" name="Sex" value="1" checked>男</label> <label><input type="radio" name="Sex" value="0">女</label>
						<%Else%>
							<label><input type="radio" name="Sex" value="1">男</label> <label><input type="radio" name="Sex" value="0" checked>女</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>出生日期：</th>
					<td><input type="text" name="Birthday" value="<%=(Convert.IsDBNull(Staff[Birthday])) ? "" : Convert.ToDateTime(Staff[Birthday]).ToString("yyyy-MM-dd")%>" size="18" maxlength="255" class="ali-input" readonly data-ali-widget="calendar"></td>
				</tr>
				<tr>
					<th>民族：</th>
					<td>
						<select name="NationID" class="<%=ContentLang%>Font" data-ali-widget="combo">
							<option value="">未指定</option>
							<ali:List Object="Nation">
								<ali:Record>
									<%If Guid.Equals(ID, Staff[NationID])%>
										<option value="<%=ID%>" selected><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>"><%=Name%></option>
									<%EndIf%>
								</ali:Record>
							</ali:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>籍贯：</th>
					<td><input type="text" name="Origin" value="<%=Staff[Origin]%>" size="20" maxlength="20" class="ali-input <%=ContentLang%>Font"></td>
				</tr>
				<tr>
					<th>是否结婚：</th>
					<td>
						<%If Convert.ToBoolean(Staff[IsMarried])%>
							<label><input type="radio" name="IsMarried" value="true" checked>是</label> <label><input type="radio" name="IsMarried" value="false">否</label>
						<%Else%>
							<label><input type="radio" name="IsMarried" value="true">是</label> <label><input type="radio" name="IsMarried" value="false" checked>否</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>政治面貌：</th>
					<td>
						<select name="PartyID" class="<%=ContentLang%>Font" data-ali-widget="combo">
							<option value="">未指定</option>
							<ali:List Object="Party">
								<ali:Record>
									<%If Guid.Equals(ID, Staff[PartyID])%>
										<option value="<%=ID%>" selected><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>"><%=Name%></option>
									<%EndIf%>
								</ali:Record>
							</ali:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>学历：</th>
					<td>
						<select name="DegreeID" class="<%=ContentLang%>Font" data-ali-widget="combo">
							<option value="">未指定</option>
							<ali:List Object="Degree">
								<ali:Record>
									<%If Guid.Equals(ID, Staff[DegreeID])%>
										<option value="<%=ID%>" selected><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>"><%=Name%></option>
									<%EndIf%>
								</ali:Record>
							</ali:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>毕业院校：</th>
					<td><input type="text" name="School" value="<%=Staff[School]%>" size="30" maxlength="50" class="ali-input <%=ContentLang%>Font"></td>
				</tr>
				<tr>
					<th>专业：</th>
					<td><input type="text" name="Major" value="<%=Staff[Major]%>" size="20" maxlength="30" class="ali-input <%=ContentLang%>Font"></td>
				</tr>
				<tr>
					<th>毕业日期：</th>
					<td><input type="text" name="GraduationDate" value="<%=(Convert.IsDBNull(Staff[GraduationDate])) ? "" : Convert.ToDateTime(Staff[GraduationDate]).ToString("yyyy-MM-dd")%>" size="18" class="ali-input" readonly data-ali-widget="calendar"></td>
				</tr>
				<tr>
					<th>入职日期：</th>
					<td><input type="text" name="JoinDate" value="<%=(Convert.IsDBNull(Staff[JoinDate])) ? "" : Convert.ToDateTime(Staff[JoinDate]).ToString("yyyy-MM-dd")%>" size="18" class="ali-input" readonly data-ali-widget="calendar"></td>
				</tr>
				<tr>
					<th>合同签订日期：</th>
					<td><input type="text" name="ContractDate" value="<%=(Convert.IsDBNull(Staff[ContractDate])) ? "" : Convert.ToDateTime(Staff[ContractDate]).ToString("yyyy-MM-dd")%>" size="18" class="ali-input" readonly data-ali-widget="calendar"></td>
				</tr>
				<tr>
					<th>是否在职：</th>
					<td>
						<%If Convert.ToBoolean(Staff[IsActive])%>
							<label><input type="radio" name="IsActive" value="true" checked>是</label> <label><input type="radio" name="IsActive" value="false">否</label>
						<%Else%>
							<label><input type="radio" name="IsActive" value="true">是</label> <label><input type="radio" name="IsActive" value="false" checked>否</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>离职日期：</th>
					<td><input type="text" name="DimissionDate" value="<%=(Convert.IsDBNull(Staff[DimissionDate])) ? "" : Convert.ToDateTime(Staff[DimissionDate]).ToString("yyyy-MM-dd")%>" size="18" class="ali-input" readonly data-ali-widget="calendar"></td>
				</tr>
				<tr>
					<th>通讯地址：</th>
					<td><input type="text" name="Address" value="<%=Staff[Address]%>" size="50" maxlength="150" class="ali-input <%=ContentLang%>Font"></td>
				</tr>
				<tr>
					<th>手机号码：</th>
					<td><input type="text" name="Mobile" value="<%=Staff[Mobile]%>" size="11" class="ali-input"></td>
				</tr>
				<tr>
					<th>QQ号码：</th>
					<td><input type="text" name="QQ" value="<%=Staff[QQ]%>" size="11" class="ali-input"></td>
				</tr>
				<tr>
					<th>电子邮件：</th>
					<td><input type="text" name="Email" value="<%=Staff[Email]%>" size="50" maxlength="50" class="ali-input"></td>
				</tr>
				<tr>
					<th>个人简介：</th>
					<td>
						<textarea name="Profile" data-lang="<%=ContentLang%>" data-instance-id="<%=InstanceID%>" class="editor"><%=HttpUtility.HtmlEncode(Staff[Profile].ToString())%></textarea>
					</td>
				</tr>
				<tr>
					<th>简历上传：</th>
					<td><input type="text" name="Resume" value="<%=Staff[Resume]%>" size="55" class="ali-input"><a class="ali-button ali-uploader">浏览...</a></td>
				</tr>
			</table>
		</div>
		<div class="post-footer"><button type="submit" class="ali-button">保 存</button><input type="hidden" name="PictureAllowedType" value="gif|jpg|jpeg|png|bmp"></div>
	</form>
</section>