﻿var g_action = null;
var _lang_move_to = "移动到";

function InitMove(submit, action, jumpTo, callback)
{
    g_action = action;

	var UpdateTip = function(e, source, target)
	{
		var moveTip = $("#MoveTip");
		if (source != null)
		{
			var tip = "<span style='color:#FF0;font-weight:bold' class='" + _lang + "Font'>" + source.attr("name") + "</span>";
			if (target != null)
				tip += "<br><br> &nbsp;&nbsp;" + _lang_move_to + " &nbsp;&nbsp;<br><br>&nbsp;<span style='color:#FF0;font-weight:bold' class='" + _lang + "Font'>" + target.attr("name") + "</span>";
			moveTip.html(tip);
		}
		var w = moveTip.width();
		var h = moveTip.height();
		var t = e.pageY - h / 2;
		var l;
		if (e.pageX - w - 50 > 0)
			l = e.pageX - w - 25;
		else
			l = e.pageX + 15;
		moveTip.css({top:t,left:l});
		moveTip.show();
	};
    
	var BindDroppable = function()
	{
		$("[sort]").droppable(
		{
			over : function(e, ui)
			{
				if (ui.helper.data("Source").index(this) != -1)
					return;
				
				ui.helper.data("Target", $(this));
	
				UpdateTip(e, ui.helper.data("Source"), ui.helper.data("Target"));
			},
			out : function(e, ui)
			{
				if (typeof(ui.helper.data("Target")) != "undefined")
					ui.helper.removeData("Target");
				
				UpdateTip(e, ui.helper.data("Source"), null);
			},
			drop : function(e, ui)
			{
				if (submit != null)
					window.location.href = submit + "?Action=" + g_action + "&From=" + ui.helper.data("Source").attr("sort") + "&To=" + ui.helper.data("Target").attr("sort") + "&JumpTo=" + escape(jumpTo);
				else
					callback(ui.helper.data("Source").attr("sort"), ui.helper.data("Target").attr("sort"), g_action);
			}
		});
	}
	
	$("body").append("<div id='Moving' style='display:none;position:absolute;cursor:move;filter:alpha(Opacity=50);-moz-opacity:0.5;opacity:0.5;background:#000'></div><div id='MoveTip' style='display:none;position:absolute;border:1px solid #CCC;padding:5px;color:#FFF;background:#666'></div>");

	var isMouseDown = false;
	$("#Moving").draggable(
	{
		delay : 100,
		drag : function(e, ui)
		{
			UpdateTip(e);
		}
	}).mousedown(function()
	{
		isMouseDown = true;
	}).mouseup(function()
	{
		isMouseDown = false;
		$(this).hide();
		$("#MoveTip").hide();
	}).mouseleave(function()
	{
		if (!isMouseDown)
			$(this).hide();
	});
	
	$("body").delegate("[sort]", "mouseenter", function()
	{
		if (!$(this).hasClass("ui-droppable"))
			BindDroppable();

		if (typeof($("#Moving").data("Target")) != "undefined")
		{
			$("#Moving").removeData("Target");
			return;
		}
		
		var w = $(this).outerWidth();
		var h = $(this).outerHeight();
		var t = $(this).offset().top;
		var l = $(this).offset().left;
		$("#Moving").data("Source", $(this)).show().css({width:w,height:h,top:t,left:l});
	});
}
