﻿function ShowAndHide(id)
{
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].getAttribute("ParentID") != id)
			continue;
	
		var show = false;
		if (arguments.length == 2)
		{
			show = false;
		}
		else
		{
			if(rows[i].style.display == "none")
				show = true;
			else
				show = false;
		}
		
		var img = document.getElementById("SH" + id);
		
		if(show)
		{
			rows[i].style.display = "";
			img.setAttribute("src", img.getAttribute("src").replace("close","open"));
		}
		else
		{
			rows[i].style.display = "none";
			img.setAttribute("src", img.getAttribute("src").replace("open","close"));
			
			ShowAndHide(rows[i].getAttribute("ItemID"), false);
		}
	}
}

function ShowAll()
{
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].getAttribute("ParentID") != "")
			rows[i].style.display = '';
			
		var img = document.getElementById("SH" + rows[i].getAttribute("ItemID"));
		if (img != null)
			img.setAttribute("src", img.getAttribute("src").replace("open","close"));
	}
}

function CloseAll()
{
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].getAttribute("ParentID") == null)
			continue;
			
		if (rows[i].getAttribute("ParentID") != "")
			rows[i].style.display = 'none';
			
		var img = document.getElementById("SH" + rows[i].getAttribute("ItemID"));
		if (img != null)
			img.setAttribute("src", img.getAttribute("src").replace("open","close"));
	}
}

function MakeTreeControl(id, imagePath)
{
	var result = "";

	var rows = document.getElementsByTagName("TR");
	var row = document.getElementById("Row" + id);
	var control = document.getElementById("Control" + id);
	var whitespace = "\r\n\t\t\t";
	var space = whitespace + "<span style=\"margin-left:20px\"></span>" + whitespace;
	var middleOpen = whitespace + "<img id=\"SH" + id + "\" onclick=\"ShowAndHide('" + id + "')\" src=\"" + imagePath + "tree/middle_open_flipCHS.gif\" class=\"ShowHide\" />" + whitespace;
	var middle = whitespace + "<img src=\"" + imagePath + "tree/middle_flipCHS.gif\" />" + whitespace;
	var bottomOpen = whitespace + "<img id=\"SH" + id + "\" onclick=\"ShowAndHide('" + id + "')\" src=\"" + imagePath + "tree/bottom_open_flipCHS.gif\" class=\"ShowHide\" />" + whitespace;
	var bottom = whitespace + "<img src=\"" + imagePath + "tree/bottom_flipCHS.gif\" />" + whitespace;
	var topOpen = whitespace + "<img id=\"SH" + id + "\" onclick=\"ShowAndHide('" + id + "')\" src=\"" + imagePath + "tree/top_open_flipCHS.gif\" class=\"ShowHide\" />" + whitespace;
	var top = whitespace + "<img src=\"" + imagePath + "tree/top_flipCHS.gif\" />" + whitespace;
	var line = whitespace + "<img src=\"" + imagePath + "tree/line.gif\" />" + whitespace;
	
	var HasNext = function()
	{
		var treeItem = row;
		if (arguments.length == 1)
			treeItem = arguments[0];
			
		var over = false;
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].getAttribute("ItemID") == treeItem.getAttribute("ItemID"))
			{
				over = true;
				continue;
			}
			
			if (!over)
				continue;
		
			if (rows[i].getAttribute("ParentID") == treeItem.getAttribute("ParentID"))
				return true;
		}
		
		return false;
	}
	
	var HasPrevious = function()
	{
		var treeItem = row;
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].getAttribute("ItemID") == treeItem.getAttribute("ItemID"))
				return false;
		
			if (rows[i].getAttribute("ParentID") == treeItem.getAttribute("ParentID"))
				return true;
		}
		
		return false;
	}
	
	var HasChild = function()
	{
		var treeItem = row;
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].getAttribute("ParentID") == treeItem.getAttribute("ItemID"))
				return true;
		}
		
		return false;
	}
	
	var GetParent = function(treeItem)
	{
		if (treeItem.getAttribute("ParentID") == "")
			return null;
	
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].getAttribute("ItemID") == treeItem.getAttribute("ParentID"))
				return rows[i];
		}
		return null;
	}
	
	if (row.getAttribute("ParentID") != "")
	{
		result = space;
		if (HasNext())
		{
			if (HasChild())
			{
				if (control.innerHTML.indexOf("_open") != -1)
					result += middleOpen;
				else
					result += middleOpen.replace("_open", "_close");
			}
			else
			{
				result += middle;
			}
		}
		else
		{
			if (HasChild())
			{
				if (control.innerHTML.indexOf("_open") != -1)
					result += bottomOpen;
				else
					result += bottomOpen.replace("_open", "_close");
			}
			else
			{
				result += bottom;
			}
		}
	}
	else
	{
		if (HasNext())
		{
			if (HasPrevious())
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = middleOpen;
					else
						result = middleOpen.replace("_open", "_close");
				}
				else
				{
					result = middle;
				}
			}
			else
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = topOpen;
					else
						result = topOpen.replace("_open", "_close");
				}
				else
				{
					result = top;
				}
			}
		}
		else
		{
			if (HasPrevious())
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = bottomOpen;
					else
						result = bottomOpen.replace("_open", "_close");
				}
				else
				{
					result = bottom;
				}
			}
			else
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = topOpen;
					else
						result = topOpen.replace("_open", "_close");
				}
				else
				{
					result = top;
				}
			}
		}
	}
	
	var parent = GetParent(row);
	var grand = null;
	while (parent != null)
	{
		grand = GetParent(parent);
		if (grand != null)
		{
			if (HasNext(parent))
				result = space + line + result;
			else
				result = space + space + result;
		}
		else
		{
			if (HasNext(parent))
				result = line + result;
		}
		
		parent = grand;
	}
	
	return result;
}

function ClientDelete(id)
{
	//删除所有属于他的
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].getAttribute("ParentID") == id)
			ClientDelete(rows[i].getAttribute("ItemID"))
	}
	
	//删除本身
	var row = document.getElementById("Row" + id);
	var table = row.parentNode.parentNode;
	table.deleteRow(row.rowIndex);
}

function IsInherit(child, parent, rows)
{
	if (child.getAttribute("ItemID") == parent.getAttribute("ItemID"))
		return true;

	while (true)
	{
		if (child.getAttribute("ParentID") == "")
			break;
			
		if (child.getAttribute("ParentID") == parent.getAttribute("ItemID"))
			return true;
	
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].getAttribute("ItemID") == child.getAttribute("ParentID"))
			{
				child = rows[i];
				break;
			}
		}
	}

	return false;
}

function ClientMove(fromID, toID, imagePath, isChild)
{
	//获取信息
	var from = document.getElementById("Row" + fromID);
	var to = document.getElementById("Row" + toID);
	var table = from.parentNode.parentNode;
	var fromIndex = from.rowIndex;
	var toIndex = to.rowIndex;
	
	//判断回路
	if (IsInherit(to, from, table.rows))
	{
		alert("不能移动！");
		return false;
	}
	
	//移动行
	if (navigator.userAgent.indexOf("Gecko") == -1)
	{
	    table.moveRow(fromIndex, toIndex);
	}
	else
	{
	    if (from.rowIndex > to.rowIndex)
	        to.parentNode.insertBefore(from, to);
	    else if (to.nextSibling != null)
	        to.parentNode.insertBefore(from, to.nextSibling);
	    else
	        to.parentNode.appendChild(from);
	}

	//移动所有属于他的
	var childCount = 0;
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].getAttribute("ParentID") == fromID)
		{
			ClientMove(rows[i].getAttribute("ItemID"), toID, imagePath, false);
			childCount++;
		}
	}
	
	if (arguments.length == 3)
	{
		//替换父ID
		from.setAttribute("ParentID", to.getAttribute("ParentID"));
		
		//替换树控制
		for (var i = 0; i <= rows.length; i++)
		{
			var row = table.rows[i];
			var control = document.getElementById("Control" + rows[i].getAttribute("ItemID"));
			if (control == null)
				break;
			control.innerHTML = MakeTreeControl(row.getAttribute("ItemID"), imagePath);
		}
	}
	
	return true;
}