<%@ Page PathInChannel="about/{ID}{Ext}" Mark="System" Object="Menu"%>
<!doctype html>
<html lang="<%=PageLang%>">
<head>
<ali:Get Mark="System" ID="Menu" Object="Menu" PageID="Request.QueryString['ID']" ForMeta="true" />
<ali:Get Mark="System" ID="MenuCategory" Object="MenuCategory" Guid="Menu[CategoryID]" />
<ali:Get Mark="System" ID="Parent" Object="Menu" Guid="Menu[ParentID]" />
<meta charset="utf-8">
<meta name="keywords" content="<%=MetaKeywords%>">
<meta name="description" content="<%=MetaDescription%>">
<title><%=Menu[Name]%> - <%=Channel[Name]%> - <%=Site[Name]%></title>
<ali:Comment><link rel="stylesheet" href="../S01/CHS/css/common.css"></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
</head>
<body>
<!-- start="顶部菜单" -->
<div class="top-menu">
	<div class="wrap">
		<!-- start="登陆状态" -->
		<div> <span> 亲，欢迎您的光临本站，赶快淘喜欢的宝贝吧！ <a href="<%=BuildUrl("User", "login")%>?Referer=<%=Request.RawUrl%>">[请登录]</a> <a href="<%=BuildUrl("User", "register")%>">[免费注册]</a> </span> <span style="display:none">你好！<a href="<%=BuildUrl("User", "index")%>" id="user"></a>，<a href="<%=BuildUrl("User", "logout")%>?Referer=<%=Request.RawUrl%>">安全退出</a></span></div>
		<!-- end="登陆状态" -->
		
		<!-- start="语言导航"-->
		<ali:Menu Condition="CategoryID={7dfb1283-df5c-4c2a-a94e-61d8dd38df5d}">
			<ul>
				<ali:Record>
					<li><a href="<%=URL%>" <%=Style%> target="<%=Target%>"><%=Name%></a></li>
				</ali:Record>
			</ul>
		</ali:Menu>
		<!-- end="语言导航" -->
	</div>
</div>

<div class="header">
	<div class="header-left"> <a href="<%=BuildUrl("index")%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>"></a> </div>
	<div class="header-mid">
		<!-- start="搜索" -->
		<form action="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_&List=_&Order=_&OrderMore=_&q=_{q}")%>">
			<dl>
				<dd>
					<input type="text" name="q" class="keyword <%=PageLang%>Font">
				</dd>
				<dt>
					<input type="submit" value="搜索">
				</dt>
			</dl>
		</form>
		<!-- end="搜索" -->
		
		<!-- start="热门搜索" -->
		<ul>
			<li>热门搜索：</li>
			<ali:List Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
				<ali:Record>
					<li><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></li>
				</ali:Record>
			</ali:List>
		</ul>
	     <!-- end="热门搜索" -->
	</div>
	<div class="header-right">
		<dl>
			<dt><a href="<%=BuildUrl("User", "index")%>">我的账号</a></dt>
			<dd style="display:none">
				<!-- start="我的账号" -->
				<ali:Menu Condition="CategoryID={1155117e-8090-4978-8359-b3719f325d34}">
					<ali:Record>
						 <a href="<%=URL%>" target="<%=Target%>"><%=Name%></a> 
					 </ali:Record> 	
				</ali:Menu>
				<!-- end="我的账号" -->
			</dd>
		</dl>
		<div><a href="<%=BuildUrl("cart")%>">购物车（<b id="cart-count">0</b>）</a></div>
	</div>
</div>

<!-- start="菜单" -->
<div class="menu">
	<dl>
		<dt>
			<h1>全部商品分类</h1>
			<!-- start="商品分类" -->
			<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID IS NULL">
				<ul>
					<ali:Record>
						<li>
							<a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a>
							<div>
								<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
									<ali:Record>
										<ol>
											<li><h2><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></h2></li>
											<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
												<ali:Record>
													<li><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></li>
												</ali:Record>
											</ali:List>
										</ol>
									</ali:Record>
								</ali:List>
							</div>
						</li>
					</ali:Record>
				</ul>
			</ali:List>
			<!-- end="商品分类" -->
		</dt>
		<!-- start="主菜单" -->
		<ali:Menu Condition="IsDisplay=true and CategoryID IS NULL" >
			<ali:Record>
				<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
			</ali:Record>
		</ali:Menu>
		<!-- end="主菜单" -->
	</dl>
</div>
<!-- end="菜单" -->

<!-- start="路径" -->
<div class="path">
	<ali:Path IncludeCurrentChannel="True">
		你的位置 :
		<ali:Record>
			<a href="<%=URL%>"><%=Name%></a> &gt;
		</ali:Record>
	</ali:Path>
	<%=MenuCategory[Name]%> &gt; <%If Parent != null%><%=Parent[Name]%> &gt; <%EndIf%><%=Menu[Name]%>
</div>
<!-- end="路径" -->

<div class="frame7">
	<div class="frame7-side">
		<div class="list8">
			<!-- start="帮助导航" -->
			<ali:Menu Condition="IsDisplay=true and ParentID IS NULL and CategoryID=MenuCategory[ID]">
				<ali:Record>
					<dl>
						<dt><a href="<%=URL%>"><%=Name%></a></dt>
						<ali:Menu Condition="IsDisplay=true and ParentID=ID">
							<ali:Record>
								<%If Guid.Equals(ID, Menu[ID])%>
									<dd><strong><%=Name%></strong></dd>
								<%Else%>
									<dd><a href="<%=URL%>"><%=Name%></a></dd>
								<%EndIf%>
							</ali:Record>
						</ali:Menu>
					</dl>
				</ali:Record>
			</ali:Menu>
			<!-- end="帮助导航" -->
		 </div>
	</div>
	<div class="frame7-main">
		<!-- start="内容" -->
		<div class="block26">
			<h1 class="block26-title"><%=Menu[Name]%></h1>
			<div class="block26-content"><%=Menu[Content]%></div>
		</div>
		<!-- end="内容" -->	
	</div>
</div>

<!-- start="页脚帮助导航" -->
<ali:Menu Condition="IsDisplay=true and CategoryID={43933a81-064a-4f2c-b32e-5e5f7f319f8e} and ParentID IS NULL">
	<div class="block2 margin1">
		<div class="block2-wrap">
			<ali:Record>
				<dl>
					<dt><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dt>
					<ali:Menu Condition="IsDisplay=true and ParentID=ID">
						<ali:Record>
							<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
						</ali:Record>
					</ali:Menu>
				</dl>
			</ali:Record>
		</div>
	</div>
</ali:Menu>
<!-- end="页脚帮助导航" -->

<!-- start="友情链接" -->
<div class="link">
	<ul>
		<ali:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ali:Record>
				<li><a href="<%=URL%>" target="_blank" ><img src="<%=Logo%>" alt="<%=Name%>"></a></li>
			</ali:Record>
		</ali:List>
	</ul>
</div>
<!-- end="友情链接" -->

<!-- start="脚注菜单" -->
<div class="footer-menu">
	<ali:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ali:Record>
			<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
			<ali:Separator>|</ali:Separator>
		</ali:Record>
	</ali:Menu>
</div>
<!--end="脚注菜单" -->
	
<!-- start="脚注" -->
<div class="footer">
	<%=Footer%>
</div>
<!-- end="脚注" -->

<script src="<%=CommonPath%>jquery/core.js"></script> 
<script src="<%=CommonPath%>json2.js"></script>
<script src="<%=CommonPath%>aliui/ali.min.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script src="<%=JsPath("global.js")%>"></script>
<script src="<%=JsPath%>common.js"></script>
<%=StatCode%>
</body>
</html>
