<%@ Page PathInChannel="cart{Ext}" %>
<!doctype html>
<html lang="<%=PageLang%>">
<head>
<meta name="keywords" content="<%=MetaKeywords%>">
<meta name="description" content="<%=MetaDescription%>">
<meta charset="utf-8">
<title>购物车 - <%=Channel[Name]%> - <%=Site[Name]%></title>
<link rel="stylesheet" href="<%=CommonPath%>aliui/skin/default/common.css">
<ali:Comment><link rel="stylesheet" href="../S01/CHS/css/common.css"></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
<script>
var _page = 'cart',
	_lang_yuan = '元',
	_lang_delete = '删除',
	_lang_cart_empty = '购物车已空！',
	_lang_keyword_empty = '请输入关键字！',
	_lang_amount_greater_than_stock = '数量不能超出库存量！';
</script>
</head>
<body>
<div class="top-menu">
	<div class="wrap">
		<!-- start="登陆状态" -->
		<div> <span> 亲，欢迎您的光临本站，赶快淘喜欢的宝贝吧！ <a href="<%=BuildUrl("User", "login")%>?Referer=<%=Request.RawUrl%>">[请登录]</a> <a href="<%=BuildUrl("User", "register")%>">[免费注册]</a> </span> <span style="display:none">你好！<a href="<%=BuildUrl("User", "index")%>" id="user"></a>，<a href="<%=BuildUrl("User", "logout")%>?Referer=<%=Request.RawUrl%>">安全退出</a></span></div>
		<!-- end="登陆状态" -->
		
		<!-- start="语言导航"-->
		<ali:Menu Condition="CategoryID={7dfb1283-df5c-4c2a-a94e-61d8dd38df5d}">
			<ul>
				<ali:Record>
					<li><a href="<%=URL%>" <%=Style%> target="<%=Target%>"><%=Name%></a></li>
				</ali:Record>
			</ul>
		</ali:Menu>
		<!-- end="语言导航" -->
	</div>
</div>

<div class="header">
	<div class="header-left"> <a href="<%=BuildUrl("index")%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>"></a> </div>
	<div class="header-mid">
		<!-- start="搜索" -->
		<form action="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_&List=_&Order=_&OrderMore=_&q=_{q}")%>">
			<dl>
				<dd>
					<input type="text" name="q" class="keyword <%=PageLang%>Font">
				</dd>
				<dt>
					<input type="submit" value="搜索">
				</dt>
			</dl>
		</form>
		<!-- end="搜索" -->
		
		<!-- start="热门搜索" -->
		<ul>
			<li>热门搜索：</li>
			<ali:List Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
				<ali:Record>
					<li><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></li>
				</ali:Record>
			</ali:List>
		</ul>
	     <!-- end="热门搜索" -->
	</div>
	<div class="header-right">
		<dl>
			<dt><a href="<%=BuildUrl("User", "index")%>">我的账号</a></dt>
			<dd style="display:none">
				<!-- start="我的账号" -->
				<ali:Menu Condition="CategoryID={1155117e-8090-4978-8359-b3719f325d34}">
					<ali:Record>
						 <a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
					 </ali:Record>
				</ali:Menu>
				<!-- end="我的账号" -->
			</dd>
		</dl>
		<div><a href="<%=BuildUrl("cart")%>">购物车（<b id="cart-count">0</b>）</a></div>
	</div>
</div>

<div class="menu">
	<dl>
		<dt>
			<h1>全部商品分类</h1>
			<!-- start="商品分类" -->
			<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID IS NULL">
				<ul>
					<ali:Record>
						<li>
							<a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&OrderMore=_&q=_")%>" target="_blank"><%=Name%></a>
							<div>
								<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
									<ali:Record>
										<ol>
											<li><h2><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&OrderMore=_&q=_")%>" target="_blank"><%=Name%></a></h2></li>
											<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
												<ali:Record>
													<li><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&OrderMore=_&q=_")%>" target="_blank"><%=Name%></a></li>
												</ali:Record>
											</ali:List>
										</ol>
									</ali:Record>
								</ali:List>
							</div>
						</li>
					</ali:Record>
				</ul>
			</ali:List>
			<!-- end="商品分类" -->
		</dt>
		<!-- start="主菜单" -->
		<ali:Menu Condition="IsDisplay=true and CategoryID IS NULL" >
			<ali:Record>
				<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
			</ali:Record>
		</ali:Menu>
		<!-- end="主菜单" -->
	</dl>
</div>

<!-- start="路径" -->
<div class="path">
	<ali:Path IncludeCurrentChannel="True">
		你的位置 :
		<ali:Record>
			<a href="<%=URL%>"><%=Name%></a> &gt;
		</ali:Record>
	</ali:Path>
	购物车
</div>
<!-- end="路径" -->

<!-- start="购物车商品列表" -->
<div class="frame10">
	<dl class="step">
		<dd class="one"><strong>1</strong>查看购物车</dd>
		<dd class="two"><strong>2</strong>填写购物信息</dd>
		<dd class="three"><strong>3</strong>完成订单</dd>
        <dt>我的购物车</dt>
	</dl>
	<div class="block6">
		<h1>已放入购物车的商品:</h1>
		<p>请在此确认你要购买的商品</p>
		<table>
			<thead>
				<tr>
					<th>商品名称</th>
					<th>商品规格</th>
					<th width="80">市场价</th>
					<th width="80">本店价</th>
					<th width="80">购买数量</th>
					<th width="80">小计</th>
					<th width="80">操作</th>
				</tr>
			</thead>
			<tbody>
			</tbody>
			<tfoot>
				<tr>
					<th>
						<a href="<%=BuildUrl("index")%>" class="continue">继续购物</a>
						<a href="" class="clear">清空购物车</a>
					</th>
					<td colspan="6">商品总额：<strong>￥<b id="sum">0</b></strong></td>
				</tr>
			</tfoot>
		</table>
		<div class="list23">
			<a href="<%=BuildUrl("order")%>" class="order">去结算</a>
		</div>
	</div>	
</div>
<!-- end="购物车商品列表" -->

<!-- start="页脚帮助导航" -->
<ali:Menu Condition="IsDisplay=true and CategoryID={43933a81-064a-4f2c-b32e-5e5f7f319f8e} and ParentID IS NULL">
	<div class="block2 margin1">
		<div class="block2-wrap">
			<ali:Record>
				<dl>
					<dt><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dt>
					<ali:Menu Condition="IsDisplay=true and ParentID=ID">
						<ali:Record>
							<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
						</ali:Record>
					</ali:Menu>
				</dl>
			</ali:Record>
		</div>
	</div>
</ali:Menu>
<!-- end="页脚帮助导航" -->

<!-- start="友情链接" -->
<div class="link">
	<ul>
		<ali:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ali:Record>
				<li><a href="<%=URL%>" target="_blank" ><img src="<%=Logo%>" alt="<%=Name%>"></a></li>
			</ali:Record>
		</ali:List>
	</ul>
</div>
<!-- end="友情链接" -->

<!-- start="脚注菜单" -->
<div class="footer-menu">
	<ali:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ali:Record>
			<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
			<ali:Separator>|</ali:Separator>
		</ali:Record>
	</ali:Menu>
</div>
<!--end="脚注菜单" -->
	
<!-- start="脚注" -->
<div class="footer">
	<%=Footer%>
</div>
<!-- end="脚注" -->

<script src="<%=CommonPath%>jquery/core.js"></script> 
<script src="<%=CommonPath%>json2.js"></script>
<script src="<%=CommonPath%>aliui/ali.min.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script src="<%=JsPath("global.js")%>"></script>
<script src="<%=JsPath%>common.js"></script>
<%=StatCode%>
</body>
</html>