<%@ Page PathInChannel="goods/{ID}{Ext}" Object="Goods" %>
<!doctype html>
<html lang="<%=PageLang%>">
<head>
<ali:Get ID="Goods" Object="Goods" PageID="Request.QueryString['ID']" ForMeta="true" />
<ali:Get ID="GoodsCategory" Object="GoodsCategory" Guid="Goods[CategoryID]"/>
<ali:Get ID="FreightTemplate" Object="FreightTemplate" Guid="Goods[FreightTemplateID]" />
<meta charset="utf-8">
<meta name="keywords" content="<%=MetaKeywords%>">
<meta name="description" content="<%=MetaDescription%>">
<title><%=Goods[Name]%> - <%=Goods[CategoryName]%> - <%=Channel[Name]%> - <%=Site[Name]%></title>
<link rel="stylesheet" href="<%=CommonPath%>aliui/skin/default/common.css">
<link rel="stylesheet" href="<%=CommonPath%>jqzoom/css/jquery.jqzoom.css">
<ali:Comment><link rel="stylesheet" href="../S01/CHS/css/common.css"></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
<script>
var _page = 'goods',
	_webPath = '<%=WebPath%>',
	_id = <%=Request.QueryString["ID"]%>,
	_guid = '<%=Goods[ID]%>',
	_no = '<%=Goods[No]%>',
	_channelPath = '<%=Channel[Path]%>',
	_elapse = 0,
	_weight = <%=Goods[Weight]%>,
	_volume = <%=Goods[Volume]%>,
	_freightTemplateId = '<%=FreightTemplate[ID]%>',
	_bear = '<%=FreightTemplate[Bear]%>',
	_method = '<%=FreightTemplate[Method]%>',
	<%If FreightTemplate == null%>
		_express = {},
		_ems = {},
		_post = {},
	<%Else%>
		_express = <%=FreightTemplate[Express]%>,
		_ems = <%=FreightTemplate[EMS]%>,
		_post = <%=FreightTemplate[Post]%>,
	<%EndIf%>
	_propValues = <%=Goods[Property]%>,
	_props = [
				<ali:List Object="Type.Property" Condition="TypeID=GoodsCategory[TypeID]">
					<ali:Record>
						{"id":"<%=ID%>","name":"<%=Name%>","options":[
							<ali:List Object="Type.Property.Option" Condition="PropertyID=ID">
								<ali:Record>
									{"id":"<%=ID%>","name":"<%=Name%>"}
									<ali:Separator>,</ali:Separator>
								</ali:Record>
							</ali:List>
						]}
						<ali:Separator>,</ali:Separator>
					</ali:Record>
				</ali:List>
			],
	_specValues = <%=Goods[Spec]%>,
	_specs = [
				<ali:List Object="Type.Spec" Condition="TypeID=GoodsCategory[TypeID]">
					<ali:Record>
						{"id":"<%=ID%>","name":"<%=Name%>","isColor":<%=Convert.ToString(IsColor).ToLower()%>,"canUpload":<%=Convert.ToString(CanUpload).ToLower()%>,"options":[
							<ali:List Object="Type.Spec.Option" Condition="SpecID=ID">
								<ali:Record>
									{"id":"<%=ID%>","name":"<%=Name%>","color":"<%=Color%>"}
									<ali:Separator>,</ali:Separator>
								</ali:Record>
							</ali:List>
						]}
						<ali:Separator>,</ali:Separator>
					</ali:Record>
				</ali:List>
			],
	_specForCart = '',
	_specIdForCart,
	_specNoForCart,
	_lang_operation_success = '操作成功！',
	_lang_operation_fail = '操作失败！',
	_lang_yuan = '元',
	_lang_day = '天 ',
	_lang_hour = '小时 ',
	_lang_minute = '分钟 ',
	_lang_second = '秒 ',
	_lang_add_cart_success = '已成功添加购物车！',
	_lang_cart_exist = '该商品在购物车中已经存在！',
	_lang_keyword_empty = '请输入关键字！',
	_lang_amount_must_be_digit = '数量必须是数字！',
	_lang_amount_greater_than_stock = '数量不能超出库存量！',
	_lang_not_login = '您还没登录，请登录！',
	_lang_freight_template_id_empty = '运费模板没有指定！';
</script>
</head>
<body>
<div class="top-menu">
	<div class="wrap">
		<!-- start="登陆状态" -->
		<div> <span> 亲，欢迎您的光临本站，赶快淘喜欢的宝贝吧！ <a href="<%=BuildUrl("User", "login")%>?Referer=<%=Request.RawUrl%>">[请登录]</a> <a href="<%=BuildUrl("User", "register")%>">[免费注册]</a> </span> <span style="display:none">你好！<a href="<%=BuildUrl("User", "index")%>" id="user"></a>，<a href="<%=BuildUrl("User", "logout")%>?Referer=<%=Request.RawUrl%>">安全退出</a></span> </div>
		<!-- end="登陆状态" -->
		
		<!-- start="语言导航"-->
		<ali:Menu Condition="CategoryID={7dfb1283-df5c-4c2a-a94e-61d8dd38df5d}">
			<ul>
				<ali:Record>
					<li><a href="<%=URL%>"<%=Style%> target="<%=Target%>"><%=Name%></a></li>
				</ali:Record>
			</ul>
		</ali:Menu>
		<!-- end="语言导航" -->
	</div>
</div>

<div class="header">
	<div class="header-left"> <a href="<%=BuildUrl("index")%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>"></a> </div>
	<div class="header-mid">
	   <!-- start="搜索" -->
		<form action="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_&List=_&Order=_&OrderMore=_&q=_{q}")%>">
			<dl>
				<dd>
					<input type="text" name="q" size="10" class="keyword <%=PageLang%>Font">
				</dd>
				<dt>
					<input type="submit" value="搜索">
				</dt>
			</dl>
		</form>
		<!-- end="搜索" -->
		
		<!-- start="热门搜索" -->
		<ul>
			<li>热门搜索：</li>
			<ali:List Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
				<ali:Record>
					<li><a href="<%=BuildUrl()%>" target="_blank" title="<%=Name%>"><%=Name%></a></li>
				</ali:Record>
			</ali:List>
		</ul>
	    <!-- end="热门搜索" -->
	</div>
	<div class="header-right">
		<dl>
			<dt><a href="<%=BuildUrl("User", "index")%>">我的账号</a></dt>
			<dd style="display:none">
				<!-- start="我的账号" -->
				<ali:Menu Condition="CategoryID={1155117e-8090-4978-8359-b3719f325d34}">
					<ali:Record>
						 <a href="<%=URL%>" target="<%=Target%>"><%=Name%></a> 
					 </ali:Record> 	
				</ali:Menu>
				<!-- end="我的账号" -->
			</dd>
		</dl>
		<div><a href="<%=BuildUrl("cart")%>">购物车(<b id="cart-count">0</b>)</a></div>
	</div>
</div>

<div class="menu">
	<dl>
		<dt>
			<h1>全部商品分类</h1>
			<!-- start="商品分类" -->
			<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID IS NULL">
				<ul>
					<ali:Record>
						<li>
							<a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a>
							<div>
								<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
									<ali:Record>
										<ol>
											<li><h2><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></h2></li>
											<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
												<ali:Record>
													<li><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></li>
												</ali:Record>
											</ali:List>
										</ol>
									</ali:Record>
								</ali:List>
							</div>
						</li>
					</ali:Record>
				</ul>
			</ali:List>
			<!-- end="商品分类" -->
		</dt>
		<!-- start="主菜单" -->
		<ali:Menu Condition="IsDisplay=true and CategoryID IS NULL" >
			<ali:Record>
				<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
			</ali:Record>
		</ali:Menu>
		<!-- end="主菜单" -->
	</dl>
</div>

<!-- start="路径" -->
<ali:Path IncludeCurrentChannel="True">
	<div class="path">
		你的位置 :
		<ali:Record>
			<a href="<%=URL%>" title="<%=Name%>"><%=Name%></a> &gt;
		</ali:Record>
		<a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + Goods[CategoryPageID] + "&BrandID=_&List=_&Order=_&q=_")%>"><%=Goods[CategoryName]%></a> &gt; <%=Goods[Name]%>
	</div>
</ali:Path>
<!-- end="路径" -->

<div class="frame6">
	<div class="frame6-side">
		<div class="list17">
			<h1>商品分类</h1>
			<!-- start="商品分类" -->
			<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID IS NULL">
				<dl>
					<ali:Record>
						<dt><%=Name%></dt>
						<ali:List Object="GoodsCategory" Page="1" PageSize="20" Condition="IsDisplay=true and ParentID=ID">
							<ali:Record>
								<dd><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></dd>
							</ali:Record>
						</ali:List>
					</ali:Record>
				</dl>
			</ali:List>
			<!-- end="商品分类" -->
		</div>
		
		<!-- start="最新产品"-->
		<div class="list6">
			<ali:List Object="Goods" Page="1" PageSize="4" Condition="IsDeleted=false and IsReleased=true" Sort="UpdateTime DESC" >
				<h1><span>最新商品</span></h1>
				<dl>
					 <ali:Record>
						<dt><a href="<%=BuildUrl()%>" title="<%=Name%>"><img src="<%=Thumbnail%>" alt=""></a></dt>
						<dd>
							<p><a href="<%=BuildUrl()%>" title="<%=Name%>"><%=Name%></a></p>
							<span><%=MarketPrice%>元</span>
						</dd>
					</ali:Record>
				</dl>
			</ali:List>
		</div>
		<!-- end="最新产品"-->
	</div>
	<div  class="frame6-main">
		<div class="frame9">
	   		<div class="frame9-side">
				<!-- start="商品大图和下面的小图" -->
				<div class="list18">
					<h1><a href="<%=Goods[Picture]%>" title="<%=Goods[Name]%>" rel="gal1" class="jqzoom"><img id="thumbnail" src="<%=Goods[Picture]%>" alt="<%=Goods[Name]%>" class="zoom"></a></h1>
					<p><a title="查看原图片" id="view-orgin-picture">查看原图片</a></p>
					<dl id="more-picture">
						<dt class="prev"></dt>
						<dd>
							<ali:List Object="Goods.Pictures" Condition="GoodsID=Goods[ID]">
								<ul>
									<li><a href="<%=Goods[Picture]%>" rel="{gallery: 'gal1', smallimage: '<%=Goods[Picture]%>',largeimage: '<%=Goods[Picture]%>'}"><img src="<%=Goods[Thumbnail]%>" alt="<%=Goods[Name]%>"></a></li>
									<ali:Record>
										<li><a href="<%=URL%>" rel="{gallery: 'gal1', smallimage: '<%=URL%>',largeimage: '<%=URL%>'}"><img src="<%=Thumbnail%>" alt="<%=Goods[Name]%>" data-url="<%=URL%>" data-spec-option-id="<%=SpecOptionID%>"></a></li>
									</ali:Record>
								</ul>
							</ali:List>
						</dd>
						<dt class="next"></dt>
					</dl>
				</div>
				<!-- end="商品大图和下面的小图" -->
			</div>
			<div class="frame9-main">
				<!-- start="商品参数" -->
				<div class="list19">	
					<h1  id="name"><%=Goods[Name]%></h1>
					<dl>
						<dt>商品货号：</dt>
						<dd id="no"><%=Goods[No]%></dd>
						<dt>商品品牌：</dt>
						<dd><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_" + Goods[BrandPageID] + "&List=_&Order=_&q=_")%>"><%=Goods[BrandName]%></a></dd>
						<dt>商品库存：</dt>
						<dd id="stock"><%=Goods[Stock]%></dd>
						<dt>商品重量：</dt>
						<dd><%=Goods[Weight]%></dd>
						<dt>上架时间：</dt>
						<dd><%=Goods[CreateTime]%></dd>
						<dt>商品点击数量：</dt>
						<dd><%=Goods[HitCount]%></dd>
					</dl>
			  	</div>
				<!-- end="商品参数" -->

				<!-- start="商品价格" -->
				<div class="list20">
					<ul>
						<li>市场价：￥<del id="market-price"><%=Convert.ToDecimal(Goods[MarketPrice]).ToString("0.00")%></del></li>
						<li>销售价：￥<strong id="sale-price"><%=Convert.ToDecimal(Goods[SalePrice]).ToString("0.00")%></strong></li>
						<li>节省：￥<span id="save-price"><%=(Convert.ToDecimal(Goods[MarketPrice]) - Convert.ToDecimal(Goods[SalePrice])).ToString("0.00")%></span></li>
					</ul>
				</div>
				<!-- end="商品价格" -->
				
				<!-- start="促销价格" -->
				<%If Convert.ToBoolean(Goods[Promote])%>
					<dl class="promotion">
						<%If DateTime.Now < Convert.ToDateTime(Goods[PromoteStart])%>
							<dt>促销价格：<em class="price1">即将开始...</em></dt>
							<dd>促销开始还有：<i data-second="<%=Convert.ToInt32((Convert.ToDateTime(Goods[PromoteStart]) - DateTime.Now).TotalSeconds)%>"></i></dd>
						<%ElseIf DateTime.Now > Convert.ToDateTime(Goods[PromoteEnd])%>
							<dt>促销价格：<em class="price2">已结束</em></dt>
						<%Else%>
							<dt>促销价格：<em class="price">￥<i><%=Goods[PromotePrice]%></i></em></dt>
							<dd>促销结束还有：<i data-second="<%=Convert.ToInt32((Convert.ToDateTime(Goods[PromoteEnd]) - DateTime.Now).TotalSeconds)%>"></i></dd>
						<%EndIf%>
					</dl>
				<%EndIf%>
				<!-- end="促销价格" -->
				
				<!-- start="会员价格" -->
				<ali:List Object="UserPrice" Condition="GoodsID=Goods[ID]">
					<div id="user-price" class="user">
						<b>
							<ali:Record>
								<ali:List Mark="User" Object="Role" Condition="ID=RoleID">
									<ali:Record>
										<span><%=Name%>：<em><i data-no="<%=No%>" data-is-default="<%=IsDefault%>"><%=Convert.ToDecimal(Price).ToString("0.00")%></i>元</em></span>
									</ali:Record>
								</ali:List>
							</ali:Record>
						</b>
					</div>
				</ali:List>
				<!-- end="会员价格" -->
				
				<!-- start="规格" -->
				<div class="spec">
					<div>
						<h1>购买数量：</h1><span class="amount"><input type="text" name="Amount" value="1" size="5"><a href="" class="up"></a><a href="" class="down"></a></span>
						<h1>商品总价：</h1><span><b><%=Convert.ToDecimal(Goods[SalePrice]).ToString("0.00")%></b>元</span>
					</div>
					<p><a href="" class="buy">立刻购买</a><a href="" class="cart">加入购物车</a><a href="" data-id="<%=Goods[ID]%>" data-page-id="<%=Goods[PageID]%>" data-name="<%=Goods[Name]%>" data-thumbnail="<%=Goods[Thumbnail]%>" class="collect">收藏</a></p>
				</div>
				<!-- end="规格" -->
			</div>
		</div>

		<div class="goods-tab">
			<h1 id="goods-tabmenu"><a class="active">商品描述</a><a>商品属性</a><a>用户评论</a></h1>
			<div class="content">
				<div class="description"><%=Goods[Description]%></div>
				<table class="property">
					<tbody></tbody>
				</table>
				<div class="comment margin2">
					<h1>用户评论<em>(共<i><%=Comment[RecordCount]%></i>条评论)</em></h1>
					
					<div>
						<!-- start="评论列表" -->
						<ali:List ID="Comment" Object="Comment" Page="PageNumber" PageSize="5" Condition="GoodsID=Goods[ID]">
							<ali:Record>
								<dl>
									<dt><label><%=Creator%></label></dt>
									<dd><pre><%=Content%></pre><p><%=CreateTime%></p></dd>
								</dl>
							</ali:Record>
						</ali:List>
						<!-- end="评论列表" -->
			
						<!-- start="分页" -->
						<ali:Pagination Page="PageNumber" PageSize="2" RecordCount="Comment[RecordCount]">
							<div class="pagenation2">
								总共 <%=Comment[RecordCount]%> 条记录，共 <%=PageCount%> 页.
	
								<ali:FirstPage>
									<ali:No>
										<a href="" data-page="<%=PageNumber - 1%>">上页</a>
									</ali:No>
								</ali:FirstPage>
			
								<ali:LastPage>
									<ali:No>
										<a href="" data-page="<%=PageNumber + 1%>">下页</a>
									</ali:No>
								</ali:LastPage>
							</div>
						</ali:Pagination>
						<!-- end="分页" -->
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- start="页脚帮助导航" -->
<ali:Menu Condition="IsDisplay=true and CategoryID={43933a81-064a-4f2c-b32e-5e5f7f319f8e} and ParentID IS NULL">
	<div class="block2 margin1">
		<div class="block2-wrap">
			<ali:Record>
				<dl>
					<dt><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dt>
					<ali:Menu Condition="IsDisplay=true and ParentID=ID">
						<ali:Record>
							<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
						</ali:Record>
					</ali:Menu>
				</dl>
			</ali:Record>
		</div>
	</div>
</ali:Menu>
<!-- end="页脚帮助导航" -->

<!-- start="友情链接" -->
<div class="link">
	<ul>
		<ali:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ali:Record>
				<li><a href="<%=URL%>" target="_blank" ><img src="<%=Logo%>" alt="<%=Name%>"></a></li>
			</ali:Record>
		</ali:List>
	</ul>
</div>
<!-- end="友情链接" -->

<!-- start="脚注菜单" -->
<div class="footer-menu">
	<ali:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ali:Record>
			<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
			<ali:Separator>|</ali:Separator>
		</ali:Record>
	</ali:Menu>
</div>
<!--end="脚注菜单" -->
	
<!-- start="脚注" -->
<div class="footer">
	<%=Footer%>
</div>
<!-- end="脚注" -->

<script src="<%=CommonPath%>jquery/core.js"></script> 
<script src="<%=CommonPath%>json2.js"></script>
<script src="<%=CommonPath%>jqzoom/js/jquery.jqzoom-core.js"></script>
<script src="<%=CommonPath%>aliui/ali.min.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script src="<%=JsPath("global.js")%>"></script>
<script src="<%=JsPath%>common.js"></script>
<%=StatCode%>
</body>
</html>
