<%@ Page PathInChannel="list{CategoryID:(_([a-zA-Z\d]+)?)?}{BrandID:(_([a-zA-Z\d]+)?)?}{List:(_(mix|grid|text)?)?}{Order:(_(\d+)?)?}{q:(_[^_\.]*)?}{Page}{Ext}" %>
<!doctype html>
<html lang="<%=PageLang%>">
<head>
<ali:Get ID="GoodsCategory" Object="GoodsCategory" PageID="CategoryID" />
<ali:Get ID="Brand" Object="Brand" PageID="BrandID" />
<meta charset="utf-8">
<meta name="keywords" content="<%=MetaKeywords%>">
<meta name="description" content="<%=MetaDescription%>">
<title><%If CategoryID != null%><%=GoodsCategory[Name]%><%EndIf%><%If BrandID != null%><%If CategoryID != null%> , <%EndIf%><%=Brand[Name]%><%EndIf%><%If Keyword != ""%><%If CategoryID != null || BrandID != null%> , <%EndIf%><%=Keyword%><%EndIf%> - <%=Channel[Name]%> - <%=Site[Name]%></title>
<link rel="stylesheet" href="<%=CommonPath%>aliui/skin/default/common.css">
<ali:Comment><link rel="stylesheet" href="../S01/CHS/css/common.css"></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
<script language="c#" runat="server">
protected string CategoryID
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["CategoryID"]) || Request.QueryString["CategoryID"] == "_")
			return null;
		else
			return Request.QueryString["CategoryID"].Substring(1);
	}
}

protected string BrandID
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["BrandID"]) || Request.QueryString["BrandID"] == "_")
			return null;
		else
			return Request.QueryString["BrandID"].Substring(1);
	}
}

protected string List
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["List"]) || Request.QueryString["List"] == "_")
			return "grid";
		else
			return Request.QueryString["List"].Substring(1);
	}
}

protected int Order
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["Order"]) || Request.QueryString["Order"] == "_")
			return 0;
		else
			return Convert.ToInt32(Request.QueryString["Order"].Substring(1));
	}
}

protected string Keyword
{
	get
	{
		if (String.IsNullOrEmpty(Request.QueryString["q"]) || Request.QueryString["q"] == "_")
			return "";
		else
			return Request.QueryString["q"].Substring(1);
	}
}

protected string BuildUrlString(string name, object value ,int page)
{
	string categoryID = null;
	if (name == "CategoryID")
	{
		categoryID = value == "" ? "_" : "_" + value;
	}
	else
	{
		categoryID = Request.QueryString["CategoryID"];
		if (String.IsNullOrEmpty(categoryID))
			categoryID = "_";
	}

	string brandID = null;
	if (name == "BrandID")
	{
		brandID = value == "" ? "_" : "_" + value;
	}
	else
	{
		brandID = Request.QueryString["BrandID"];
		if (String.IsNullOrEmpty(brandID))
			brandID = "_";
	}

	string list = null;
	if (name == "List")
	{
		list = value == "" ? "_" : "_" + value;
	}
	else
	{
		list = Request.QueryString["List"];
		if (String.IsNullOrEmpty(list))
			list = "_";
	}

	string order = null;
	if (name == "Order")
	{
		order = value == "" ? "_" : "_" + value;
	}
	else
	{
		order = Request.QueryString["Order"];
		if (String.IsNullOrEmpty(order))
			order = "_";
	}

	string q = null;
	if (name == "q")
	{
		q = value == "" ? "_" : "_" + value;
	}
	else
	{
		q = Request.QueryString["q"];
		if (String.IsNullOrEmpty(q))
			q = "_";
	}
	
	return BuildUrl(null, null, "CategoryID=" + categoryID + "&BrandID=" + brandID + "&List=" + list + "&Order=" + order + "&q=" + q + (page == 1 ? "" : "&Page=" + page));	
}

protected int ListCount
{
	get
	{
		if (List == "text")
			return Convert.ToInt32(<%=ListText[RecordCount]%>);
		else if (List == "grid")
			return Convert.ToInt32(<%=ListGrid[RecordCount]%>);
		else
			return Convert.ToInt32(<%=ListMix[RecordCount]%>);
	}
}

protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Goods.IsDeleted + "=false AND " + Alias.Goods.IsReleased + "=true");
	string and = " AND ";

	#region 类别
	if (CategoryID != null)
		condition.Append(and + Alias.Goods.IncludeSubCategory + "=" + GoodsCategory[Alias.GoodsCategory.ID]);
	#endregion

	#region 品牌
	if (BrandID != null)
		condition.Append(and + Alias.Goods.BrandID + "=" + Brand[Alias.Brand.ID]);
	#endregion

	#region 关键字
	if (Keyword != "")
		condition.Append(and + Alias.Goods.Name + " LIKE '%" + Keyword + "%'");
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Order)
	{
		case 1:
			sort = Alias.Goods.UpdateTime + " ASC";
			break;
		case 2:
			sort = Alias.Goods.SalePrice + " DESC";
			break;
		case 3:
			sort = Alias.Goods.SalePrice + " ASC";
			break;
		case 4:
			sort = Alias.Goods.UpdateTime + " DESC";//TODO：实现销售价格
			break;
		case 5:
			sort = Alias.Goods.UpdateTime + " ASC";//TODO：实现销售价格
			break;
		case 6:
			sort = Alias.Goods.HitCount + " DESC";
			break;
		case 7:
			sort = Alias.Goods.HitCount + " ASC";
			break;
		default:
			sort = Alias.Goods.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script>
var _page = 'goods_category',
	_webPath = '<%=WebPath%>',
	_loginPath = '<%=BuildUrl("User", "Login")%>',
	_channelPath = '<%=Channel[Path]%>',
	_order = <%=Order%>,
	_lang_yuan = '元',
	_lang_add_cart_success = '已成功添加购物车！',
	_lang_cart_exist = '该商品在购物车中已经存在！',
	_lang_keyword_empty = '请输入关键字！',
	_lang_operation_fail = '操作失败！',
	_lang_operation_success = '操作成功！',
	_lang_not_login = '您还没登录，请登录！';
</script>
</head>
<body>
<!-- start="顶部菜单" -->
<div class="top-menu">
	<div class="wrap">
		<!-- start="登陆状态" -->
		<div> <span> 亲，欢迎您的光临本站，赶快淘喜欢的宝贝吧！ <a href="<%=BuildUrl("User", "login")%>?Referer=<%=Request.RawUrl%>">[请登录]</a> <a href="<%=BuildUrl("User", "register")%>">[免费注册]</a> </span> <span style="display:none">你好！<a href="<%=BuildUrl("User", "index")%>" id="user"></a>，<a href="<%=BuildUrl("User", "logout")%>?Referer=<%=Request.RawUrl%>">安全退出</a></span> </div>
		<!-- end="登陆状态" -->
		
		<!-- start="语言导航"-->
		<ali:Menu Condition="CategoryID={7dfb1283-df5c-4c2a-a94e-61d8dd38df5d}">
			<ul>
				<ali:Record>
					<li><a href="<%=URL%>"<%=Style%> target="<%=Target%>"><%=Name%></a></li>
				</ali:Record>
			</ul>
		</ali:Menu>
		<!-- end="语言导航" -->
	</div>
</div>
<!-- end="顶部菜单" -->

<div class="header">
	<div class="header-left"> <a href="<%=BuildUrl("index")%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>"></a> </div>
	<div class="header-mid">
	   <!-- start="搜索"-->
		<form action="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_&List=_&Order=_&OrderMore=_&q=_{q}")%>">
			<dl>
				<dd>
					<input type="text" name="q" class="keyword <%=PageLang%>Font">
				</dd>
				<dt>
					<input type="submit" value="搜索">
				</dt>
			</dl>
		</form>
		<!-- end="搜索" -->
		<!-- start="热门搜索"-->
		<ul>
			<li>热门搜索：</li>
			<ali:List Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
				<ali:Record>
					<li><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></li>
				</ali:Record>
			</ali:List>
		</ul>
	    <!-- end="热门搜索" -->
	</div>
	<div class="header-right">
		<dl>
			<dt><a href="<%=BuildUrl("User", "index")%>">我的账号</a></dt>
			<dd style="display:none">
				<!-- start="我的账号"-->
				<ali:Menu Condition="CategoryID={1155117e-8090-4978-8359-b3719f325d34}">
					<ali:Record>
						 <a href="<%=URL%>" target="<%=Target%>"><%=Name%></a> 
					 </ali:Record> 	
				</ali:Menu>
				<!-- end="我的账号"-->
			</dd>
		</dl>
		<div><a href="<%=BuildUrl("cart")%>">购物车(<b id="cart-count">0</b>)</a></div>
	</div>
</div>

<div class="menu">
	<dl>
		<dt>
			<h1>全部商品分类</h1>
			<!-- start="商品分类" -->
			<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID IS NULL">
				<ul>
					<ali:Record>
						<li>
							<a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a>
							<div>
								<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
									<ali:Record>
										<ol>
											<li><h2><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></h2></li>
											<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
												<ali:Record>
													<li><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></li>
												</ali:Record>
											</ali:List>
										</ol>
									</ali:Record>
								</ali:List>
							</div>
						</li>
					</ali:Record>
				</ul>
			</ali:List>
			<!-- end="商品分类" -->
		</dt>
		<!-- start="主菜单" -->
		<ali:Menu Condition="IsDisplay=true and CategoryID IS NULL" >
			<ali:Record>
				<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
			</ali:Record>
		</ali:Menu>
		<!-- end="主菜单" -->
	</dl>
</div>

<!-- start="路径" -->
<ali:Path IncludeCurrentChannel="True">
	<div class="path">
		你的位置 :
		<ali:Record>
			<a href="<%=URL%>"><%=Name%></a> &gt;
		</ali:Record>
		<%If CategoryID != null%><%=GoodsCategory[Name]%><%EndIf%><%If BrandID != null%><%If CategoryID != null%> , <%EndIf%><%=Brand[Name]%><%EndIf%><%If Keyword != ""%><%If CategoryID != null || BrandID != null%> , <%EndIf%><%=Keyword%><%EndIf%>
	</div>
</ali:Path>
<!-- end="路径" -->

<div class="frame6">
	<div class="frame6-side">
		<!-- start="最新产品"-->
		<div class="list6">
			<ali:List Object="Goods" Page="1" PageSize="4" Condition="IsDeleted=false and IsReleased=true" Sort="UpdateTime DESC" >
				<h1><span>最新商品</span></h1>
				<dl>
					<ali:Record>
						<dt><a href="<%=BuildUrl()%>"><img src="<%=Thumbnail%>" alt="<%=Name%>"></a></dt>
						<dd>
							<p><a href="<%=BuildUrl()%>"><%=Name%></a></p>
							<span><%=MarketPrice%>元</span>
						</dd>
					</ali:Record>
				</dl>
			</ali:List>
		</div>
		<!-- end="最新产品"-->
		
		<!-- start="垂直广告 isAd="true" -->
		<ali:Ad Guid="{688D8C5C-2C16-41c8-A351-B9738443BCC4}">
			<div class="ad2"><a href="http://www.alibaza.com"><img src="<%=ImagePath%>ad/23.jpg" alt="ad" style="width:215px;height:260px"></a></div>
		</ali:Ad>
		<!-- end="垂直广告" -->
		
		<!-- start="浏览过的商品"-->
		<div class="history">
			<h1>浏览过的商品</h1>
			<div></div>
		</div>
		<!-- end="浏览过的商品"-->
	</div>
	<div class="frame6-main">
	   <!-- start="热门产品" -->
		<ali:List Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
			<div class="list11">
				<div>
					<ul>
						<ali:Record>
							<li>
								<dl>
									<dt><a href="<%=BuildUrl()%>" target="_blank"><img src="<%=Thumbnail%>" alt="<%=Name%>"></a></dt>
									<dd>
										<p><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></p>
										<b>￥<%=MarketPrice%></b>
										<span><a  href="<%=BuildUrl()%>" target="_blank">立即抢购</a></span>
									</dd>
								</dl>
							</li>
						</ali:Record>
					</ul>
				</div>
			</div>
		</ali:List>
		<!-- end="热门产品" -->

		<div class="list12">
			<h1>商品筛选</h1>
		  	<!-- start="商品类别" -->
			<dl>
                <ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID IS NULL">	
					<dt>类别：</dt>
					<ali:Record>
						<%If CategoryID == Convert.ToString(PageID)%>
							<dd><%=Name%></dd>
						<%Else%>
							<dd><a href="<%=BuildUrlString("CategoryID", PageID, 1)%>"><%=Name%></a></dd>
						<%EndIf%>
					</ali:Record>			
				</ali:List>	
			</dl>
			<!-- end="商品类别" -->

			<!-- start="品牌" -->
			<dl>
                <ali:List Object="Brand">	
					<dt>品牌：</dt>
					<ali:Record>
						<%If BrandID == Convert.ToString(PageID)%>
							<dd><%=Name%></dd>
						<%Else%>
							<dd><a href="<%=BuildUrlString("BrandID", PageID, 1)%>"><%=Name%></a></dd>
						<%EndIf%>
					</ali:Record>
				</ali:List>	
			</dl>
			<!-- end="品牌" -->
		</div>
		
		<div class="list13">
			<h1>总共找到<strong><%=ListCount%></strong>个商品
				<b class="col1"><strong><%=PageNumber%></strong><span>/</span></b>
			</h1>
			<ul>
				<li class="col2">
					<%If List == "mix"%>
						<a href="<%=BuildUrlString("List", "mix", 1)%>" class="mix active"></a>
					<%Else%>
						<a href="<%=BuildUrlString("List", "mix", 1)%>" class="mix"></a>
					<%EndIf%>
					<%If List == "grid"%>
						<a href="<%=BuildUrlString("List", "grid", 1)%>" class="grid active"></a>
					<%Else%>
						<a href="<%=BuildUrlString("List", "grid", 1)%>" class="grid"></a>
					<%EndIf%>
					<%If List == "text"%>
						<a href="<%=BuildUrlString("List", "text", 1)%>" class="text active"></a>
					<%Else%>
						<a href="<%=BuildUrlString("List", "text", 1)%>" class="text"></a>
					<%EndIf%>
				</li>
				<li class="col3">
					<%If Order == 3%>
						<a href="<%=BuildUrlString("Order", "2", 1)%>"><span class="asc-enable">价格</span></a>
					<%ElseIf Order == 2%>
						<a href="<%=BuildUrlString("Order", "3", 1)%>"><span class="desc-enable">价格</span></a>
					<%Else%>
						<a href="<%=BuildUrlString("Order", "2", 1)%>"><span class="asc-disable">价格</span></a>
					<%EndIf%>
					<%If Order == 5%>
						<a href="<%=BuildUrlString("Order", "4", 1)%>"><span class="asc-enable">销量</span></a>
					<%ElseIf Order == 4%>
						<a href="<%=BuildUrlString("Order", "5", 1)%>"><span class="desc-enable">销量</span></a>
					<%Else%>
						<a href="<%=BuildUrlString("Order", "4", 1)%>"><span class="asc-disable">销量</span></a>
					<%EndIf%>
					<%If Order == 7%>
						<a href="<%=BuildUrlString("Order", "6", 1)%>"><span class="asc-enable">人气</span></a>
					<%ElseIf Order == 6%>
						<a href="<%=BuildUrlString("Order", "7", 1)%>"><span class="desc-enable">人气</span></a>
					<%Else%>
						<a href="<%=BuildUrlString("Order", "6", 1)%>"><span class="asc-disable">人气</span></a>
					<%EndIf%>
				</li>
				<li class="col4">
					排序方式: 
					<select>
						<optgroup label="排序">
							<option value="<%=BuildUrlString("Order", "", 1)%>">按发布时间 新->旧</option>
							<option value="<%=BuildUrlString("Order", "1", 1)%>">按发布时间 旧->新</option>
							<option value="<%=BuildUrlString("Order", "2", 1)%>">按价格 从高到低</option>
							<option value="<%=BuildUrlString("Order", "3", 1)%>">按价格 从低到高 </option>
							<option value="<%=BuildUrlString("Order", "4", 1)%>">按销量 从高到低</option>
							<option value="<%=BuildUrlString("Order", "5", 1)%>">按销量 从低到高 </option>
							<option value="<%=BuildUrlString("Order", "6", 1)%>">按人气 从高到低</option>
							<option value="<%=BuildUrlString("Order", "7", 1)%>">按人气 从低到高 </option>
						</optgroup>
					</select>
				</li>
			</ul>
		</div>

		<%If List == "text"%>
			<table class="list14">
				<thead>
					<tr>
						<th>商品名称</th>
						<th>市场价格</th>
						<th>销售价格</th>
						<th>操作</th>
					</tr>
				</thead>
				<tbody>
					<!-- start="文字形式显示" -->	
					<ali:List ID="ListText" Object="Goods" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()">
						<ali:Record>
							<tr>
								<td><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></td>
								<td><del>￥<%=Convert.ToDecimal(MarketPrice).ToString("N")%></del></td>
								<td>￥<%=Convert.ToDecimal(SalePrice).ToString("N")%></td>
								<td><a href="" data-id="<%=ID%>" data-page-id="<%=PageID%>" data-name="<%=Name%>" data-thumbnail="<%=Thumbnail%>">加入收藏</a></td>
							</tr>
						</ali:Record>
					</ali:List>
					<!-- end="文字形式显示" -->
			   </tbody>
			</table>
		<%ElseIf List == "grid" %>
			<!-- start="图片形式显示" -->
			<ali:List ID="ListGrid" Object="Goods" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()">
				<div class="list15">
					<ul>
						<ali:Record>
							<li>
								 <a href="<%=BuildUrl()%>" target="_blank"><img src="<%=Thumbnail%>" alt="<%=Name%>"></a>
								 <p><a href="<%=BuildUrl()%>"><%=Name%></a></p>
								 <b>现价￥<%=Convert.ToDecimal(SalePrice).ToString("N")%></b>
								 <span>原价￥<%=Convert.ToDecimal(MarketPrice).ToString("N")%></span>
							</li>
						</ali:Record>
					</ul>		  
				</div>
			</ali:List>
			<!-- end="图片形式显示" -->
		<%Else%>	
			<!-- start="图片和文字形式显示" -->	
			<ali:List ID="ListMix" Object="Goods" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()">
				<div class="list16">
					<ali:Record>
						<dl>
							<dt>
								<a href="<%=BuildUrl()%>" target="_blank"><img src="<%=Thumbnail%>" alt="<%=Name%>"></a>
								<p><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></p>
							</dt>
							<dd>
								<div><b>现价￥<%=Convert.ToDecimal(SalePrice).ToString("N")%></b><span>原价￥<%=Convert.ToDecimal(MarketPrice).ToString("N")%></span></div>
								<strong>节省：￥<%=(Convert.ToDecimal(MarketPrice) - Convert.ToDecimal(SalePrice)).ToString("N")%></strong>
								<p><a href="<%=BuildUrl()%>" class="cart" data-id="<%=ID%>" data-no="<%=No%>" data-spec-id="" data-name="<%=Name%>" data-thumbnail="<%=Thumbnail%>" data-price="<%=SalePrice%>" data-amount="1">立即购买</a><a href="" data-id="<%=ID%>" data-page-id="<%=PageID%>" data-name="<%=Name%>" data-thumbnail="<%=Thumbnail%>" class="collect">收藏</a></p>
							</dd>
						</dl>
					</ali:Record>
			   </div>
			</ali:List>
			<!-- end="图片和文字形式显示" -->
		<%EndIf%>

		<!-- start="商品页数" -->
		<ali:Pagination Page="PageNumber" PageSize="20" RecordCount="ListCount">
			<div class="pagination" data-page-count="<%=PageCount%>">
				<ali:FirstPage>
					<ali:Yes>
						<a class="prev disable">上页</a>
					</ali:Yes>
					<ali:No>
						<a href="<%=PreviousPage%>" class="prev">上页</a>
					</ali:No>
				</ali:FirstPage>
				
				<ali:CurrentPage>
					<ali:Yes>
						<strong><%=Index%></strong>
					</ali:Yes>
					<ali:No>
						<span><a href="<%=URL%>"><%=Index%></a></span>
					</ali:No>
				</ali:CurrentPage>

				<ali:LastPage>
					<ali:Yes>
						<a class="next disable">下页</a>
					</ali:Yes>
					<ali:No>
						<a href="<%=NextPage%>" class="next">下页</a>
					</ali:No>
				</ali:LastPage>
			</div>
		</ali:Pagination>
		<!-- end="商品页数" -->
	</div>
</div>

<!-- start="页脚帮助导航" -->
<ali:Menu Condition="IsDisplay=true and CategoryID={43933a81-064a-4f2c-b32e-5e5f7f319f8e} and ParentID IS NULL">
	<div class="block2 margin1">
		<div class="block2-wrap">
			<ali:Record>
				<dl>
					<dt><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dt>
					<ali:Menu Condition="IsDisplay=true and ParentID=ID">
						<ali:Record>
							<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
						</ali:Record>
					</ali:Menu>
				</dl>
			</ali:Record>
		</div>
	</div>
</ali:Menu>
<!-- end="页脚帮助导航" -->

<!-- start="脚注菜单" -->
<div class="footer-menu">
	<ali:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ali:Record>
			<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
			<ali:Separator>|</ali:Separator>
		</ali:Record>
	</ali:Menu>
</div>
<!--end="脚注菜单" -->

<!-- start="友情链接" -->
<div class="link">
	<ul>
		<ali:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ali:Record>
				<li><a href="<%=URL%>" target="_blank" ><img src="<%=Logo%>" alt="<%=Name%>"></a></li>
			</ali:Record>
		</ali:List>
	</ul>
</div>
<!-- end="友情链接" -->

<!-- start="脚注" -->
<div class="footer">
	<%=Footer%>
</div>
<!-- end="脚注" -->

<script src="<%=CommonPath%>jquery/core.js"></script> 
<script src="<%=CommonPath%>json2.js"></script>
<script src="<%=CommonPath%>aliui/ali.min.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script src="<%=JsPath("global.js")%>"></script>
<script src="<%=JsPath%>common.js"></script>
<%=StatCode%>
</body>
</html>
