<%@ Page PathInChannel="order.aspx" %>
<%
if (Manager.User == null)
	Response.Redirect(<%=BuildUrl("User", "login", null)%> + "?Referer=" + Request.RawUrl);
%>
<!doctype html>
<html lang="<%=PageLang%>">
<head>
<ali:List ID="Regions" Object="Region" />
<ali:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<meta charset="utf-8">
<title>填写购物信息 - <%=Channel[Name]%> - <%=Site[Name]%></title>
<link rel="stylesheet" href="<%=CommonPath%>aliui/skin/default/common.css">
<ali:Comment><link rel="stylesheet" href="../S01/CHS/css/common.css"></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
<script language="c#" runat="server">
protected string BuildRegion(object regionId)
{
	StringBuilder result = new StringBuilder();

	DataRow[] regions = Regions.Select(Alias.Region.ID + "='" + regionId + "'");
	while (regions.Length != 0)
	{
		result.Insert(0, regions[0][Alias.Region.Name]);
		regions = Regions.Select(Alias.Region.ID + "='" + regions[0][Alias.Region.ParentID] + "'");
	}
	
	return result.ToString();
}
</script>
<script>
var _page = 'order',
	_webPath = '<%=WebPath%>',
	_city_path = '<%=BuildUrl("ajax_get_city")%>',
	_regionPath = '<%=BuildUrl("ajax_region")%>',
	_payPath = '<%=BuildUrl("pay")%>',
	_lang_yuan = '元',
	_lang_working = '正在操作...',
	_lang_operation_fail = '操作失败！',
	_lang_operation_success = '操作成功！',
	_lang_region_empty = '请选择地区！',
	_lang_receiver_address_empty = '请输入收货地址！',
	_lang_receiver_zip_empty = '请输入邮政编码！',
	_lang_receiver_name_empty = '请输入收货人姓名！',
	_lang_receiver_phone_empty = '请输入收货人电话！',
	_lang_no_address = '请选择收货地址！',
	_lang_no_goods = '没有任何商品！',
	_lang_buyer = '运费到付',
	_lang_seller = '卖家承担',
	_lang_express = '快递',
	_lang_ems = 'EMS',
	_lang_post = '平邮',
	_lang_invoice_rise_empty = '发票抬头不能为空！';
</script>
</head>
<body>
<!-- start="顶部菜单" -->
<div class="top-menu">
	<div class="wrap">
		<!-- start="登陆状态" -->
		<div> <span> 亲，欢迎您的光临本站，赶快淘喜欢的宝贝吧！ <a href="<%=BuildUrl("User", "login")%>?Referer=<%=Request.RawUrl%>">[请登录]</a> <a href="<%=BuildUrl("User", "register")%>">[免费注册]</a> </span> <span style="display:none">你好！<a href="<%=BuildUrl("User", "index")%>" id="user"></a>，<a href="<%=BuildUrl("User", "logout")%>?Referer=<%=Request.RawUrl%>">安全退出</a></span></div>
		<!-- end="登陆状态" -->
		
		<!-- start="语言导航"-->
		<ali:Menu Condition="CategoryID={7dfb1283-df5c-4c2a-a94e-61d8dd38df5d}">
			<ul>
				<ali:Record>
					<li><a href="<%=URL%>" <%=Style%> target="<%=Target%>"><%=Name%></a></li>
				</ali:Record>
			</ul>
		</ali:Menu>
		<!-- end="语言导航" -->
	</div>
</div>

<div class="header">
	<div class="header-left"> <a href="<%=BuildUrl("index")%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>"></a> </div>
	<div class="header-mid">
		<!-- start="搜索" -->
		<form action="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_&List=_&Order=_&OrderMore=_&q=_{q}")%>">
			<dl>
				<dd>
					<input type="text" name="q" class="keyword <%=PageLang%>Font">
				</dd>
				<dt>
					<input type="submit" value="搜索">
				</dt>
			</dl>
		</form>
		<!-- end="搜索" -->
		
		<!-- start="热门搜索" -->
		<ul>
			<li>热门搜索：</li>
			<ali:List Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
				<ali:Record>
					<li><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></li>
				</ali:Record>
			</ali:List>
		</ul>
	     <!-- end="热门搜索" -->
	</div>
	<div class="header-right">
		<dl>
			<dt><a href="<%=BuildUrl("User", "index")%>">我的账号</a></dt>
			<dd style="display:none">
				<!-- start="我的账号" -->
				<ali:Menu Condition="CategoryID={1155117e-8090-4978-8359-b3719f325d34}">
					<ali:Record>
						 <a href="<%=URL%>" target="<%=Target%>"><%=Name%></a> 
					 </ali:Record> 	
				</ali:Menu>
				<!-- end="我的账号" -->
			</dd>
		</dl>
		<div><a href="<%=BuildUrl("cart")%>">购物车（<b id="cart-count">0</b>）</a></div>
	</div>
</div>

<!-- start="菜单" -->
<div class="menu">
	<dl>
		<dt>
			<h1>全部商品分类</h1>
			<!-- start="商品分类" -->
			<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID IS NULL">
				<ul>
					<ali:Record>
						<li>
							<a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a>
							<div>
								<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
									<ali:Record>
										<ol>
											<li><h2><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></h2></li>
											<ali:List Object="GoodsCategory" Condition="IsDisplay=true and ParentID=ID">
												<ali:Record>
													<li><a href="<%=BuildUrl(null, "goods_category", "CategoryID=_" + PageID + "&BrandID=_&List=_&Order=_&q=_")%>" target="_blank"><%=Name%></a></li>
												</ali:Record>
											</ali:List>
										</ol>
									</ali:Record>
								</ali:List>
							</div>
						</li>
					</ali:Record>
				</ul>
			</ali:List>
			<!-- end="商品分类" -->
		</dt>

		<!-- start="主菜单" -->
		<ali:Menu Condition="IsDisplay=true and CategoryID IS NULL" >
			<ali:Record>
				<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
			</ali:Record>
		</ali:Menu>
		<!-- end="主菜单" -->
	</dl>
</div>
<!-- end="菜单" -->

<!-- start="路径" -->
<div class="path">
	<ali:Path IncludeCurrentChannel="True">
		你的位置 :
		<ali:Record>
			<a href="<%=URL%>"><%=Name%></a> &gt;
		</ali:Record>
	</ali:Path>
	结算中心
</div>
<!-- end="路径" -->

<!-- start="订单" -->
<div class="frame10">
	<dl class="step">
		<dd class="one1"><strong>1</strong>查看购物车</dd>
		<dd class="two1"><strong>2</strong>填写购物信息</dd>
		<dd class="three1"><strong>3</strong>完成订单</dd>
        <dt>我的购物车</dt>
	</dl>
	<div class="cart-items">
		<!-- start="收货地址" -->
		<table id="addresses" class="block3">
			<caption><h1>收货信息确认</h1></caption>
			<thead>
				<tr>
					<th>选择</th>
					<th>收货人</th>
					<th>所在地区</th>
					<th>详细地址</th>
					<th>邮政编码</th>
					<th>手机</th>
					<th>电话</th>
				</tr>
			</thead>
			<ali:List Object="Address" Condition="UserID=User['ID']">
				<tbody>
					<ali:Record>
						<tr data-name="<%=Name%>" data-region-id="<%=RegionID%>" data-phone="<%=Phone%>" data-mobile="<%=Mobile%>" data-address="<%=BuildRegion(RegionID)%><%=SubAddress%>" data-zip="<%=Zip%>">
							<td>
								<%If Convert.ToBoolean(IsDefault)%>
									<input type="radio" name="IsDefault" checked>
								<%Else%>
									<input type="radio" name="IsDefault">
								<%EndIf%>
							</td>
							<td><%=Name%></td>
							<td><%=BuildRegion(RegionID)%></td>
							<td><%=SubAddress%></td>
							<td><%=Zip%></td>
							<td><%=Mobile%></td>
							<td><%=Phone%></td>
						</tr>
					</ali:Record>
				</tbody>
			</ali:List>
			<tfoot>
				<tr>
					<td colspan="7"><label><input type="checkbox">新增收货人地址</label></td>
				</tr>
			</tfoot>
		</table>	
		<!-- end="收货地址" -->
		
		<!-- start="新增收货人地址" -->
		<form action="" id="new-address" class="new-address">
			<table>
				<caption><h1>新增收货人地址</h1></caption>
				<tbody>
					<tr>
						<th width="100"><em>*</em>收货地区:</th>
						<td colspan="5">
							<select>
								<option value="">请选择...</option>
								<ali:List Object="Region" Condition="ParentID IS NULL">
									<ali:Record>
										<option value="<%=ID%>"><%=Name%></option>
									</ali:Record>
								</ali:List>
							</select>
						</td>
					</tr>
					<tr>
						<th width="100"><em>*</em>收货地址:</th>
						<td colspan="3"><span></span><input type="text" name="SubAddress" size="40"></td>
						<th width="100"><em>*</em>邮政编码:</th>
						<td><input type="text" name="Zip" maxlength="6"></td>
					</tr>
					<tr>
						<th width="100"><em>*</em>收货人姓名:</th>
						<td><input type="text" name="Name" size="30"></td>
						<th width="100">电话:</th>
						<td><input type="text" name="Phone" maxlength="20"></td>
						<th width="100"><em>*</em>手机:</th>
						<td><input type="text" name="Mobile" maxlength="11"></td>
					</tr>
				</tbody>
				<tfoot>
					<tr>
						<td colspan="6"><label><input type="checkbox" name="IsDefault">是否默认</label><input type="submit" value="保存收货地址"></td>
					</tr>
				</tfoot>
			</table>
		</form>
		<!-- end="新增收货人地址" --> 		
		
		<!-- start="商品列表" -->
		<table id="goods" class="block4">
			<caption><h1>购买的商品</h1></caption>
			<thead>
				<tr>
					<th>商品名称</th>
					<th>商品规格</th>
					<th width="80">市场价</th>
					<th width="80">本店价</th>
					<th width="80">购买数量</th>
					<th width="80">运送方式</th>
					<th width="80">小计</th>
				</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
	
		<!-- start="发票" -->
		<table class="block4">
			<caption><h1>发票</h1></caption>
			<tbody>
				<tr>
					<th>是否要发票：</th>
					<td><label><input type="radio" name="NeedInvoice" value="true">是</label> <label><input type="radio" name="NeedInvoice" value="false" checked>否</label></td>
					<th>发票抬头：</th>
					<td><input type="text" name="InvoiceRise" size="40" class="CHSFont" disabled></td>
					<th>税率：</th>
					<td><input type="text" name="TaxRate" value="<%=Config[TaxRate]%>" size="5" disabled>%</td>
				</tr>
			</tbody>
		</table>
		<!-- end="发票" -->

		<div class="cart-footer">
			商品总价：<strong>￥<b id="price"></b></strong><br>
			运费合计：<strong>￥<b id="freight"></b></strong><br>
			订单总价：<strong>￥<b id="sum"></b></strong><br>
		</div>
	</div>
	<!-- end="商品列表" -->
	
	<div class="list22">
		<a href="<%=BuildUrl("cart")%>" class="return">返回购物车</a>

		<a href="" id="order" class="order">确认</a>
	</div>
</div>
<!-- end="订单" -->

<!-- start="页脚帮助导航" -->
<ali:Menu Condition="IsDisplay=true and CategoryID={43933a81-064a-4f2c-b32e-5e5f7f319f8e} and ParentID IS NULL">
	<div class="block2 margin1">
		<div class="block2-wrap">
			<ali:Record>
				<dl>
					<dt><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dt>
					<ali:Menu Condition="IsDisplay=true and ParentID=ID">
						<ali:Record>
							<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
						</ali:Record>
					</ali:Menu>
				</dl>
			</ali:Record>
		</div>
	</div>
</ali:Menu>
<!-- end="页脚帮助导航" -->

<!-- start="友情链接" -->
<div class="link">
	<ul>
		<ali:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ali:Record>
				<li><a href="<%=URL%>" target="_blank" ><img src="<%=Logo%>" alt="<%=Name%>"></a></li>
			</ali:Record>
		</ali:List>
	</ul>
</div>
<!-- end="友情链接" -->

<!-- start="脚注菜单" -->
<div class="footer-menu">
	<ali:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ali:Record>
			<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
			<ali:Separator>|</ali:Separator>
		</ali:Record>
	</ali:Menu>
</div>
<!--end="脚注菜单" -->
	
<!-- start="脚注" -->
<div class="footer">
	<%=Footer%>
</div>
<!-- end="脚注" -->

<script src="<%=CommonPath%>jquery/core.js"></script> 
<script src="<%=CommonPath%>json2.js"></script>
<script src="<%=CommonPath%>aliui/ali.min.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script src="<%=JsPath("global.js")%>"></script>
<script src="<%=JsPath%>common.js"></script>
<%=StatCode%>
</body>
</html>
