﻿<%
if (Manager.User == null)
	Response.Redirect(BuildUrl(null, "login", null));
%>
<!doctype html>
<html lang="<%=PageLang%>">
<head>
<ali:Get ID="Me" Object="User" Guid="User['ID']" />
<ali:Get ID="UserBalance" Object="User.Money" Operation="GetBalance(new Guid(User['ID']))" />
<meta charset="utf-8">
<title><%=Channel[Name]%> - <%=Site[Name]%></title>
<ali:Comment><link rel="stylesheet" href="../S01/CHS/css/common.css"></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
</head>
<body>
<div class="top-menu">
	<div class="wrap">
		<!-- start="登陆状态" -->
		<div> <span> 亲，欢迎您的光临本站，赶快淘喜欢的宝贝吧！ <a href="<%=BuildUrl("login")%>?Referer=<%=Request.RawUrl%>">[请登录]</a> <a href="<%=BuildUrl("register")%>">[免费注册]</a> </span> <span style="display:none">你好！<a href="<%=BuildUrl("index")%>" id="user"></a>，<a href="<%=BuildUrl("logout")%>?Referer=<%=Request.RawUrl%>">安全退出</a></span> </div>
		<!-- end="登陆状态" -->
		
		<!-- start="语言导航"-->
		<ali:Menu Condition="CategoryID={7dfb1283-df5c-4c2a-a94e-61d8dd38df5d}">
			<ul>
				<ali:Record>
					<li><a href="<%=URL%>"<%=Style%> target="<%=Target%>"><%=Name%></a></li>
				</ali:Record>
			</ul>
		</ali:Menu>
		<!-- end="语言导航" -->
	</div>
</div>

<div class="header">
	<div class="header-left"> <a href="<%=BuildUrl("index")%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>"></a> </div>
	<div class="header-mid">
	   <!-- start="搜索" -->
		<form action="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_&List=_&Order=_&OrderMore=_&q=_{q}")%>">
			<dl>
				<dd>
					<input type="text" name="q" class="keyword <%=PageLang%>Font">
				</dd>
				<dt>
					<input type="submit" value="搜索">
				</dt>
			</dl>
		</form>
		<!-- end="搜索" -->
		
		<!-- start="热门搜索" -->
		<ul>
			<li>热门搜索：</li>
			<ali:List Mark="Goods" Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
				<ali:Record>
					<li><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></li>
				</ali:Record>
			</ali:List>
		</ul>
	    <!-- end="热门搜索" -->
	</div>
	<div class="header-right">
		<dl>
			<dt><a href="<%=BuildUrl("index")%>">我的账号</a></dt>
			<dd style="display:none">
				<!-- start="我的账号" -->
				<ali:Menu Condition="CategoryID={1155117e-8090-4978-8359-b3719f325d34}">
					<ali:Record>
						 <a href="<%=URL%>" target="<%=Target%>"><%=Name%></a> 
					 </ali:Record> 	
				</ali:Menu>
				<!-- end="我的账号" -->
			</dd>
		</dl>
		<div><a href="<%=BuildUrl("Home", "cart")%>">购物车(<b id="cart-count">0</b>)</a></div>
	</div>
</div>

<div class="menu">
	<dl>
		<!-- start="主菜单" -->
		<ali:Menu Condition="IsDisplay=true and CategoryID IS NULL" >
			<ali:Record>
				<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
			</ali:Record>
		</ali:Menu>
		<!-- end="主菜单" -->
	</dl>
</div>

<!-- start="路径" -->
<div class="path">
	<ali:Path IncludeCurrentChannel="True">
		你的位置 :
		<ali:Record>
			<a href="<%=URL%>" title="<%=Name%>"><%=Name%></a> &gt;
		</ali:Record>
	</ali:Path>
	欢迎页面
</div>
<!-- end="路径" -->

<div class="frame5">
	<div class="frame5-side">
		<div class="frame5-border">
			<!-- start="账号列表"-->
			<div class="block13">
				<dl>
					<dt>
						<%If Convert.ToString(Me[Head]) == String.Empty%>
							<img src="<%=ImagePath%>head.jpg" alt="<%=Me[Name]%>">
						<%Else%>
							<img src="<%=Me[Head]%>" alt="<%=Me[Name]%>">
						<%EndIf%>
					</dt>
					<dd>你好！<%=User["Name"]%></dd>
				</dl>
				<p ><a href="<%=BuildUrl("logout")%>">安全退出</a></p>
				<ali:List Mark="System" Object="Channel.Menu" Condition="ParentID IS NULL and ChannelID=Channel[ID]">
					<ul>
						<ali:Record>
							<%If Request.RawUrl == Convert.ToString(Channel[Path]) + Convert.ToString(URL)%>
								<li><a href="<%=Channel[Path]%><%=URL%>" class="active"><img src="<%=ImagePath%>user.gif"><%=Name%></a></li>
							<%Else%>
								<li><a href="<%=Channel[Path]%><%=URL%>"><img src="<%=ImagePath%>user.gif"><%=Name%></a></li>
							<%EndIf%>
						</ali:Record>
					</ul>
				</ali:List>
			</div>
			<!-- end="账号列表" -->
		</div>	
	</div>
    <!-- start="欢迎页面信息"-->
	<div class="frame5-main">
		<div class="frame5-border">
			<!-- start="欢迎页面信息"-->
			<div class="block15">
				<h1><b><%=User["Name"]%></b>欢迎您到本店购物!</h1>
				<dl>
					<dt>登录次数：<span><%=Me[LoginTimes]%></span></dt>
					<dd>最后登录时间：<span><%=Me[LastLoginTime]%></span></dd>
					<dd>最后登录ip:<span><%=Me[LastLoginIP]%></span></dd>
					<dd>注册时间:<span><%=Me[CreateTime]%></span></dd>
				</dl>
				<ul>
					<li>
						<h2>你的账户</h2>
						<p>余额：<em><%=Convert.ToDecimal(UserBalance).ToString("0.00")%></em>元</p>
					</li>
					<li>
						<h2>用户提醒</h2>
						<p></p>
					</li>
				</ul>
			</div>
			<!-- end="欢迎页面信息" -->
		</div>
	</div>
</div>
<!-- end="用户账号信息"  -->

<!-- start="页脚帮助导航" -->
<ali:Menu Condition="IsDisplay=true and CategoryID={43933a81-064a-4f2c-b32e-5e5f7f319f8e} and ParentID IS NULL">
	<div class="block2 margin1">
		<div class="block2-wrap">
			<ali:Record>
				<dl>
					<dt><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dt>
					<ali:Menu Condition="IsDisplay=true and ParentID=ID">
						<ali:Record>
							<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
						</ali:Record>
					</ali:Menu>
				</dl>
			</ali:Record>
		</div>
	</div>
</ali:Menu>
<!-- end="页脚帮助导航" -->

<!-- start="友情链接" -->
<div class="link">
	<ul>
		<ali:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ali:Record>
				<li><a href="<%=URL%>" target="_blank" ><img src="<%=Logo%>" alt="<%=Name%>"></a></li>
			</ali:Record>
		</ali:List>
	</ul>
</div>
<!-- end="友情链接" -->

<!-- start="脚注菜单" -->
<div class="footer-menu">
	<ali:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ali:Record>
			<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
			<ali:Separator>|</ali:Separator>
		</ali:Record>
	</ali:Menu>
</div>
<!--end="脚注菜单" -->
	
<!-- start="脚注" -->
<div class="footer">
	<%=Footer%>
</div>
<!-- end="脚注" -->

<script src="<%=CommonPath%>jquery/core.js"></script> 
<script src="<%=CommonPath%>json2.js"></script>
<script src="<%=CommonPath%>aliui/ali.min.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script src="<%=JsPath("global.js")%>"></script>
<script src="<%=JsPath%>common.js"></script>
<%=StatCode%>
</body>
</html>
